/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.copyqualifiedname;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.copyqualifiedname.CopyQualifiedNameService;
import org.eclipse.xtext.ui.util.ClipboardUtil;

public abstract class AbstractCopyQualifiedNameHandler
extends AbstractHandler {
    @Inject
    private IResourceServiceProvider.Registry registry;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String qualifiedName = this.getQualifiedName(event);
        return ClipboardUtil.copy(qualifiedName);
    }

    protected abstract String getQualifiedName(ExecutionEvent var1);

    protected String getQualifiedName(EObject selectedElement) {
        CopyQualifiedNameService copyQualifiedNameService = this.getCopyQualifiedNameService(selectedElement);
        if (copyQualifiedNameService == null) {
            return null;
        }
        return copyQualifiedNameService.getQualifiedName(selectedElement, null);
    }

    protected String getQualifiedName(EObject selectedElement, EObject context) {
        CopyQualifiedNameService copyQualifiedNameService = this.getCopyQualifiedNameService(selectedElement);
        if (copyQualifiedNameService == null) {
            return null;
        }
        return copyQualifiedNameService.getQualifiedName(selectedElement, context);
    }

    protected CopyQualifiedNameService getCopyQualifiedNameService(EObject selectedElement) {
        if (selectedElement == null) {
            return null;
        }
        IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(selectedElement.eResource().getURI());
        if (resourceServiceProvider == null) {
            return null;
        }
        return (CopyQualifiedNameService)resourceServiceProvider.get(CopyQualifiedNameService.class);
    }
}

