/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.services;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.services.AnnotationUtil;

public class GenericEndpoint
implements Endpoint {
    private static final Logger LOG = Logger.getLogger(GenericEndpoint.class.getName());
    private final LinkedHashMap<String, Function<Object, CompletableFuture<Object>>> methodHandlers = new LinkedHashMap();
    private final Object delegate;

    public GenericEndpoint(Object delegate) {
        this.delegate = delegate;
        this.recursiveFindRpcMethods(delegate, new HashSet(), new HashSet());
    }

    protected void recursiveFindRpcMethods(Object current, Set<Class<?>> visited, Set<Class<?>> visitedForDelegate) {
        AnnotationUtil.findRpcMethods(current.getClass(), visited, methodInfo -> {
            Function<Object, CompletableFuture> handler = arg -> {
                try {
                    Object[] objectArray;
                    if (arg == null) {
                        objectArray = new Object[]{};
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = arg;
                    }
                    Object[] argument = objectArray;
                    return (CompletableFuture)methodInfo.method.invoke(current, argument);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            if (this.methodHandlers.put(methodInfo.name, handler) != null) {
                throw new IllegalStateException("Multiple methods for name " + methodInfo.name);
            }
        });
        AnnotationUtil.findDelegateSegments(current.getClass(), visitedForDelegate, method -> {
            try {
                Object delegate = method.invoke(current, new Object[0]);
                if (delegate != null) {
                    this.recursiveFindRpcMethods(delegate, visited, visitedForDelegate);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CompletableFuture<?> request(String method, Object parameter) {
        Function<Object, CompletableFuture<Object>> handler = this.methodHandlers.get(method);
        if (handler != null) {
            return handler.apply(parameter);
        }
        if (this.delegate instanceof Endpoint) {
            return ((Endpoint)this.delegate).request(method, parameter);
        }
        String message = "Unsupported request method: " + method;
        LOG.log(Level.WARNING, message);
        CompletableFuture exceptionalResult = new CompletableFuture();
        ResponseError error = new ResponseError(ResponseErrorCode.InvalidRequest, message, null);
        exceptionalResult.completeExceptionally(new ResponseErrorException(error));
        return exceptionalResult;
    }

    @Override
    public void notify(String method, Object parameter) {
        Function<Object, CompletableFuture<Object>> handler = this.methodHandlers.get(method);
        if (handler != null) {
            handler.apply(parameter);
            return;
        }
        if (this.delegate instanceof Endpoint) {
            ((Endpoint)this.delegate).notify(method, parameter);
            return;
        }
        LOG.log(Level.WARNING, "Unsupported notification method: " + method);
    }
}

