/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.EStructuralFeatureNode;
import org.eclipse.xtext.ui.editor.outline.impl.IOutlineTreeStructureProvider;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineNodeFactory;
import org.eclipse.xtext.ui.label.ILabelProviderImageDescriptorExtension;
import org.eclipse.xtext.util.CancelIndicator;

public class BackgroundOutlineTreeProvider
implements IOutlineTreeStructureProvider,
IOutlineTreeProvider,
IOutlineTreeProvider.Background,
IOutlineTreeProvider.Cancelable {
    @Inject
    private ILabelProvider labelProvider;
    @Inject
    private OutlineNodeFactory factory;
    private CancelIndicator cancelIndicator = CancelIndicator.NullImpl;

    @Override
    public IOutlineNode createRoot(IXtextDocument document, CancelIndicator cancelIndicator) {
        try {
            this.cancelIndicator = cancelIndicator;
            IOutlineNode iOutlineNode = this.factory.createRoot(document, this.getImageDescriptor(document), this.getText(document), this);
            return iOutlineNode;
        }
        finally {
            this.cancelIndicator = CancelIndicator.NullImpl;
        }
    }

    @Override
    public IOutlineNode createRoot(IXtextDocument document) {
        return this.createRoot(document, CancelIndicator.NullImpl);
    }

    protected void checkCanceled() {
        if (this.cancelIndicator.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public void createChildren(IOutlineNode parentNode, EObject modelElement) {
        this.checkCanceled();
        if (modelElement != null && parentNode.hasChildren()) {
            if (parentNode instanceof DocumentRootNode) {
                this.internalCreateChildren((DocumentRootNode)parentNode, modelElement);
            } else if (parentNode instanceof EStructuralFeatureNode) {
                this.internalCreateChildren((EStructuralFeatureNode)parentNode, modelElement);
            } else {
                this.internalCreateChildren(parentNode, modelElement);
            }
        }
    }

    protected void internalCreateChildren(DocumentRootNode parentNode, EObject modelElement) {
        Object text = this.getText(modelElement);
        if (text == null) {
            text = modelElement.eResource().getURI().trimFileExtension().lastSegment();
        }
        ImageDescriptor imageDescriptor = this.getImageDescriptor(modelElement);
        this.factory.createEObjectNode(parentNode, modelElement, imageDescriptor, text, this.isLeaf(modelElement));
    }

    protected void internalCreateChildren(EStructuralFeatureNode parentNode, EObject modelElement) {
        Object values = modelElement.eGet(parentNode.getEStructuralFeature());
        if (values != null) {
            if (parentNode.getEStructuralFeature().isMany()) {
                for (EObject value : EcoreUtil2.typeSelect((List)((List)values), EObject.class)) {
                    this.createNode(parentNode, value);
                }
            } else if (values instanceof EObject) {
                this.createNode(parentNode, (EObject)values);
            }
        }
    }

    protected void internalCreateChildren(IOutlineNode parentNode, EObject modelElement) {
        for (EObject childElement : modelElement.eContents()) {
            this.createNode(parentNode, childElement);
        }
    }

    protected EObjectNode createNode(IOutlineNode parentNode, EObject modelElement) {
        this.checkCanceled();
        Object text = this.getText(modelElement);
        boolean isLeaf = this.isLeaf(modelElement);
        if (text == null && isLeaf) {
            return null;
        }
        ImageDescriptor image = this.getImageDescriptor(modelElement);
        return this.factory.createEObjectNode(parentNode, modelElement, image, text, isLeaf);
    }

    protected ImageDescriptor getImageDescriptor(Object modelElement) {
        if (this.getLabelProvider() instanceof ILabelProviderImageDescriptorExtension) {
            return ((ILabelProviderImageDescriptorExtension)this.getLabelProvider()).getImageDescriptor(modelElement);
        }
        return null;
    }

    protected Object getText(Object modelElement) {
        if (this.getLabelProvider() instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            return ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.getLabelProvider()).getStyledText(modelElement);
        }
        return this.getLabelProvider().getText(modelElement);
    }

    protected boolean isLeaf(final EObject modelElement) {
        return !Iterables.any((Iterable)modelElement.eClass().getEAllContainments(), (Predicate)new Predicate<EReference>(){

            public boolean apply(EReference containmentRef) {
                return modelElement.eIsSet((EStructuralFeature)containmentRef);
            }
        });
    }

    protected OutlineNodeFactory getOutlineNodeFactory() {
        return this.factory;
    }

    protected ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }
}

