/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperContribution;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.ui.resource.JarEntryLocator;
import org.eclipse.xtext.ui.resource.PackageFragmentRootWalker;
import org.eclipse.xtext.ui.resource.SourceAttachmentPackageFragmentRootWalker;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.ui.util.JavaProjectClasspathChangeAnalyzer;
import org.eclipse.xtext.ui.workspace.WorkspaceLockAccess;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class Storage2UriMapperJavaImpl
implements IStorage2UriMapperJdtExtensions,
IStorage2UriMapperContribution,
IElementChangedListener {
    private static final Logger log = Logger.getLogger(Storage2UriMapperJavaImpl.class);
    @Inject
    protected JarEntryLocator locator;
    @Inject
    protected IJdtHelper jdtHelper;
    @Inject
    protected UriValidator uriValidator;
    @Inject
    protected JavaProjectClasspathChangeAnalyzer javaProjectClasspathChangeAnalyzer;
    @Inject
    protected IWorkspace workspace;
    @Inject
    protected IStorage2UriMapper host;
    @Inject
    protected WorkspaceLockAccess workspaceLockAccess;
    protected final Map<String, PackageFragmentRootData> cachedPackageFragmentRootData = Maps.newLinkedHashMap();
    protected volatile boolean isInitialized = false;
    protected AtomicReference<CountDownLatch> initializerGuard = new AtomicReference();

    public void setJdtHelper(IJdtHelper jdtHelper) {
        this.jdtHelper = jdtHelper;
    }

    public void setLocator(JarEntryLocator locator) {
        this.locator = locator;
    }

    public void setJavaProjectClasspathChangeAnalyzer(JavaProjectClasspathChangeAnalyzer javaProjectClasspathChangeAnalyzer) {
        this.javaProjectClasspathChangeAnalyzer = javaProjectClasspathChangeAnalyzer;
    }

    public void setUriValidator(UriValidator uriValidator) {
        this.uriValidator = uriValidator;
    }

    public void setHost(IStorage2UriMapper host) {
        this.host = host;
    }

    public void setWorkspaceLockAccess(WorkspaceLockAccess workspaceLockAccess) {
        this.workspaceLockAccess = workspaceLockAccess;
    }

    @Override
    public boolean isRejected(IFolder folder) {
        return this.jdtHelper.isFromOutputPath((IResource)folder);
    }

    @Override
    public Pair<URI, URI> getURIMapping(IPackageFragmentRoot root) throws JavaModelException {
        PackageFragmentRootData data = this.getData(root);
        if (data.uriPrefix == null) {
            return null;
        }
        IPath path = root.isExternal() ? root.getPath() : root.getUnderlyingResource().getLocation();
        URI physical = null;
        if (root.isArchive()) {
            String archiveScheme = "zip".equalsIgnoreCase(root.getPath().getFileExtension()) ? "zip" : "jar";
            physical = URI.createURI((String)(archiveScheme + ":file:" + path.toFile().getPath() + "!/"));
        } else {
            physical = URI.createFileURI((String)(path.toFile().getPath() + "/"));
        }
        return Tuples.create((Object)data.uriPrefix, (Object)physical);
    }

    @Override
    public Map<URI, IStorage> getAllEntries(IPackageFragmentRoot root) {
        try {
            IResource underlyingResource = root.getUnderlyingResource();
            if (underlyingResource instanceof IFolder) {
                return this.host.getAllEntries((IContainer)((IFolder)underlyingResource));
            }
        }
        catch (JavaModelException e) {
            if (!e.isDoesNotExist()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return Collections.emptyMap();
        }
        PackageFragmentRootData data = this.getData(root);
        return data.uri2Storage;
    }

    protected PackageFragmentRootData getData(IPackageFragmentRoot root) {
        boolean isCachable = this.shouldHandle(root);
        if (isCachable) {
            return this.getCachedData(root);
        }
        PackageFragmentRootData data = this.initializeData(root);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PackageFragmentRootData getCachedData(IPackageFragmentRoot root) {
        String path = root.getPath().toString();
        Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
        synchronized (map) {
            if (this.cachedPackageFragmentRootData.containsKey(path)) {
                PackageFragmentRootData data = this.cachedPackageFragmentRootData.get(path);
                if (this.isUpToDate(data, root)) {
                    data.addRoot(root);
                    return data;
                }
                this.cachedPackageFragmentRootData.remove(path);
            }
        }
        PackageFragmentRootData data = this.initializeData(root);
        Map<String, PackageFragmentRootData> map2 = this.cachedPackageFragmentRootData;
        synchronized (map2) {
            this.cachedPackageFragmentRootData.put(path, data);
        }
        return data;
    }

    protected boolean isUpToDate(PackageFragmentRootData data, IPackageFragmentRoot root) {
        return Objects.equals(data.modificationStamp, this.computeModificationStamp(root));
    }

    protected Object computeModificationStamp(IPackageFragmentRoot root) {
        try {
            if (root.exists()) {
                Object result;
                IResource resource = root.getUnderlyingResource();
                if (resource != null && (result = this.getLastModified(resource)) != null) {
                    return result;
                }
                return root.getPath().toFile().lastModified();
            }
        }
        catch (CoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new Object();
    }

    protected Object getLastModified(IResource resource) throws CoreException {
        IPath location = resource.getLocation();
        if (location != null) {
            return location.toFile().lastModified();
        }
        long timestamp = resource.getLocalTimeStamp();
        if (timestamp == -1L) {
            return null;
        }
        return timestamp;
    }

    protected PackageFragmentRootData initializeData(final IPackageFragmentRoot root) {
        final PackageFragmentRootData data = this.createPackageFragmentRootData(root);
        data.addRoot(root);
        if (this.shouldHandle(root)) {
            try {
                SourceAttachmentPackageFragmentRootWalker<Void> walker = new SourceAttachmentPackageFragmentRootWalker<Void>(){

                    @Override
                    protected URI getURI(IFile file, PackageFragmentRootWalker.TraversalState state) {
                        if (!Storage2UriMapperJavaImpl.this.uriValidator.isPossiblyManaged((IStorage)file)) {
                            return null;
                        }
                        return super.getURI(file, state);
                    }

                    @Override
                    protected URI getURI(IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
                        if (!Storage2UriMapperJavaImpl.this.uriValidator.isPossiblyManaged((IStorage)jarEntry)) {
                            return null;
                        }
                        URI uri = Storage2UriMapperJavaImpl.this.locator.getURI(root, jarEntry, state);
                        if (!Storage2UriMapperJavaImpl.this.uriValidator.isValid(uri, (IStorage)jarEntry)) {
                            return null;
                        }
                        return uri;
                    }

                    @Override
                    protected Void handle(URI uri, IStorage storage, PackageFragmentRootWalker.TraversalState state) {
                        data.uri2Storage.put(uri, storage);
                        return null;
                    }
                };
                walker.traverse(root, false);
                if (walker.getBundleSymbolicName() != null) {
                    data.uriPrefix = URI.createPlatformResourceURI((String)(walker.getBundleSymbolicName() + "/"), (boolean)true);
                }
            }
            catch (RuntimeException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (JavaModelException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return data;
    }

    protected PackageFragmentRootData createPackageFragmentRootData(IPackageFragmentRoot root) {
        return new PackageFragmentRootData(this.computeModificationStamp(root));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        String authority;
        URI archiveURI;
        Collection<PackageFragmentRootData> packageFragmentRootDatas;
        Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
        synchronized (map) {
            packageFragmentRootDatas = this.cachedPackageFragmentRootData.values();
        }
        ArrayList<Pair<IStorage, IProject>> regularMatches = new ArrayList<Pair<IStorage, IProject>>(1);
        ArrayList<Pair> archiveMatches = null;
        Path archivePath = null;
        if (uri.isArchive() && ((archiveURI = URI.createURI((String)(authority = uri.authority()).substring(0, authority.length() - 1))).isFile() || archiveURI.isPlatformResource())) {
            archivePath = new Path(archiveURI.isPlatformResource() ? archiveURI.toPlatformString(true) : archiveURI.toFileString());
            archiveMatches = new ArrayList<Pair>(1);
        }
        for (PackageFragmentRootData data : packageFragmentRootDatas) {
            URI prefix;
            URI expectedURI;
            IStorage storage;
            if (data.uriPrefix == null || uri.toString().startsWith(data.uriPrefix.toString())) {
                IStorage storage2 = data.uri2Storage.get(uri);
                if (storage2 == null || !data.exists()) continue;
                Map<String, IPackageFragmentRoot> map2 = data.associatedRoots;
                synchronized (map2) {
                    for (IPackageFragmentRoot root : data.associatedRoots.values()) {
                        regularMatches.add((Pair<IStorage, IProject>)Tuples.create((Object)storage2, (Object)root.getJavaProject().getProject()));
                        archiveMatches = null;
                    }
                    continue;
                }
            }
            if (archiveMatches == null || archivePath == null || data.uriPrefix == null || !archivePath.equals((Object)data.getPath()) || (storage = data.uri2Storage.get(expectedURI = (prefix = data.uriPrefix.lastSegment().length() == 0 ? data.uriPrefix.trimSegments(1) : data.uriPrefix).appendSegments(uri.segments()))) == null || !data.exists()) continue;
            Map<String, IPackageFragmentRoot> map3 = data.associatedRoots;
            synchronized (map3) {
                for (IPackageFragmentRoot root : data.associatedRoots.values()) {
                    archiveMatches.add(Tuples.create((Object)storage, (Object)root.getJavaProject().getProject()));
                }
            }
        }
        if (archiveMatches != null) {
            return archiveMatches;
        }
        return regularMatches;
    }

    @Override
    public URI getUri(IStorage storage) {
        if (storage instanceof IJarEntryResource) {
            IJarEntryResource casted = (IJarEntryResource)storage;
            IPackageFragmentRoot packageFragmentRoot = casted.getPackageFragmentRoot();
            Map<URI, IStorage> data = this.getAllEntries(packageFragmentRoot);
            for (Map.Entry<URI, IStorage> entry : data.entrySet()) {
                if (!entry.getValue().equals(casted)) continue;
                return entry.getKey();
            }
            if (packageFragmentRoot.exists() && packageFragmentRoot.isArchive()) {
                IPath jarPath = packageFragmentRoot.getPath();
                URI jarURI = packageFragmentRoot.isExternal() ? URI.createFileURI((String)jarPath.toOSString()) : URI.createPlatformResourceURI((String)jarPath.toString(), (boolean)true);
                URI result = URI.createURI((String)("archive:" + String.valueOf(jarURI) + "!" + String.valueOf(storage.getFullPath())));
                return result;
            }
        }
        return null;
    }

    public void elementChanged(ElementChangedEvent event) {
        if (!this.initializeCache(true)) {
            return;
        }
        Set<IJavaProject> javaProjectsWithClasspathChange = this.javaProjectClasspathChangeAnalyzer.getJavaProjectsWithClasspathChange(event.getDelta());
        if (!javaProjectsWithClasspathChange.isEmpty()) {
            for (IJavaProject project : javaProjectsWithClasspathChange) {
                this.updateCache(project);
            }
        }
        for (IJavaElementDelta projectDelta : this.getProjectDeltas(event.getDelta())) {
            IJavaProject project = (IJavaProject)projectDelta.getElement();
            if ((projectDelta.getKind() & 2) != 0) {
                this.clearCache(project, Collections.emptySet());
            }
            switch (projectDelta.getFlags()) {
                case 512: {
                    this.updateCache(project);
                    break;
                }
                case 1024: {
                    this.clearCache(project, Collections.emptySet());
                }
            }
        }
    }

    public void setWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
    }

    protected void updateCache(IJavaProject project) {
        HashSet datas = Sets.newHashSet();
        try {
            try {
                if (project.exists() && project.getProject().isAccessible()) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
                    int n = iPackageFragmentRootArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                        boolean isCachable = this.shouldHandle(root);
                        if (isCachable) {
                            datas.add(this.getCachedData(root));
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                if (!e.isDoesNotExist()) {
                    log.error((Object)("Error getting package fragments roots of " + project.getElementName()), (Throwable)e);
                }
                this.clearCache(project, datas);
            }
        }
        finally {
            this.clearCache(project, datas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache(IJavaProject project, Set<PackageFragmentRootData> toBeKept) {
        ArrayList values;
        Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
        synchronized (map) {
            values = Lists.newArrayList(this.cachedPackageFragmentRootData.values());
        }
        ArrayList toBeRemoved = Lists.newArrayList();
        for (PackageFragmentRootData data : values) {
            Map<String, IPackageFragmentRoot> associatedRoots;
            if (toBeKept.contains(data)) continue;
            Map<String, IPackageFragmentRoot> map2 = associatedRoots = data.associatedRoots;
            synchronized (map2) {
                Iterator<IPackageFragmentRoot> i = associatedRoots.values().iterator();
                IPackageFragmentRoot someRoot = null;
                boolean didChange = false;
                while (i.hasNext()) {
                    IPackageFragmentRoot root = i.next();
                    if (project.equals(root.getJavaProject())) {
                        i.remove();
                        didChange = true;
                        continue;
                    }
                    if (someRoot != null) continue;
                    someRoot = root;
                }
                if (associatedRoots.size() == 0) {
                    toBeRemoved.add(data);
                } else if (didChange) {
                    final IPackageFragmentRoot rootToProcess = someRoot;
                    data.uri2Storage = new ForwardingMap<URI, IStorage>(){
                        Map<URI, IStorage> delegate;

                        protected Map<URI, IStorage> delegate() {
                            if (this.delegate == null) {
                                this.delegate = Storage2UriMapperJavaImpl.this.initializeData((IPackageFragmentRoot)rootToProcess).uri2Storage;
                                return this.delegate;
                            }
                            return this.delegate;
                        }
                    };
                }
            }
        }
        if (!toBeRemoved.isEmpty()) {
            Map<String, PackageFragmentRootData> map3 = this.cachedPackageFragmentRootData;
            synchronized (map3) {
                this.cachedPackageFragmentRootData.values().removeAll(toBeRemoved);
            }
        }
    }

    @Override
    public void initializeCache() {
        this.initializeCache(false);
    }

    public void asyncInitializeCache() {
        if (!this.isInitialized) {
            this.useNewThreadToInitialize(false);
        }
    }

    public void syncInitializeCache() {
        this.initializeCache(true);
    }

    protected boolean initializeCache(boolean wait) {
        if (!this.isInitialized) {
            switch (this.workspaceLockAccess.isWorkspaceLockedByCurrentThread(this.workspace)) {
                case YES: {
                    try {
                        this.doInitializeCache();
                    }
                    catch (CoreException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    CountDownLatch guard = this.initializerGuard.get();
                    if (guard != null) {
                        guard.countDown();
                    }
                    return true;
                }
                case NO: {
                    this.useNewThreadToInitialize(wait);
                    return true;
                }
                case SHUTDOWN: {
                    return false;
                }
            }
        }
        return true;
    }

    protected void useNewThreadToInitialize(boolean wait) {
        WorkspaceLockAccess.Result workspaceLockedByCurrentThread = this.workspaceLockAccess.isWorkspaceLockedByCurrentThread(this.workspace);
        if (workspaceLockedByCurrentThread == WorkspaceLockAccess.Result.SHUTDOWN) {
            return;
        }
        if (wait && workspaceLockedByCurrentThread == WorkspaceLockAccess.Result.YES) {
            throw new IllegalStateException("Cannot wait for the thread to finish if we currently hold the WS lock");
        }
        CountDownLatch myGuard = this.initializerGuard.get();
        if (myGuard == null) {
            CountDownLatch newGuard = new CountDownLatch(1);
            if (this.initializerGuard.compareAndSet(null, newGuard)) {
                myGuard = newGuard;
                this.startInitializerThread(newGuard);
            } else {
                myGuard = this.initializerGuard.get();
            }
        }
        if (myGuard == null) {
            throw new IllegalStateException();
        }
        if (wait) {
            try {
                myGuard.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void startInitializerThread(final CountDownLatch countDown) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Storage2UriMapperJavaImpl.this.doInitializeCache();
                    }
                    catch (CoreException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        countDown.countDown();
                    }
                }
                finally {
                    countDown.countDown();
                }
            }
        }, "Storage2UriMapperJavaImpl::doInitializeCache").start();
    }

    protected void doInitializeCache() throws CoreException {
        if (!this.isInitialized) {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (!Storage2UriMapperJavaImpl.this.isInitialized) {
                        IProject[] iProjectArray = Storage2UriMapperJavaImpl.this.workspace.getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            if (project.isAccessible() && JavaProject.hasJavaNature((IProject)project)) {
                                IJavaProject javaProject = JavaCore.create((IProject)project);
                                Storage2UriMapperJavaImpl.this.updateCache(javaProject);
                            }
                            ++n2;
                        }
                        Storage2UriMapperJavaImpl.this.isInitialized = true;
                    }
                }
            };
            if (this.workspace.isTreeLocked()) {
                runnable.run(null);
            } else {
                this.workspace.run(runnable, null, 1, null);
            }
        }
    }

    protected Set<IJavaElementDelta> getProjectDeltas(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (delta.getElement().getElementType() == 2) {
            return Collections.singleton(delta);
        }
        LinkedHashSet result = null;
        if (element instanceof IJavaModel) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                Set<IJavaElementDelta> projectDeltas = this.getProjectDeltas(child);
                if (!projectDeltas.isEmpty()) {
                    if (result == null) {
                        result = Sets.newLinkedHashSet();
                    }
                    result.addAll(projectDeltas);
                }
                ++n2;
            }
        }
        return result == null ? Collections.emptySet() : result;
    }

    public static class PackageFragmentRootData {
        public URI uriPrefix;
        public final Object modificationStamp;
        public final Map<String, IPackageFragmentRoot> associatedRoots;
        public Map<URI, IStorage> uri2Storage = Maps.newLinkedHashMap();

        public PackageFragmentRootData(Object modificationStamp) {
            this.modificationStamp = modificationStamp;
            this.associatedRoots = Collections.synchronizedMap(new LinkedHashMap());
        }

        public String toString() {
            return String.valueOf(this.getPath()) + " / " + String.valueOf(this.uriPrefix);
        }

        public boolean exists() {
            IPackageFragmentRoot root = this.anyPackageFragmentRoot();
            return root != null && root.exists();
        }

        public IPath getPath() {
            IPackageFragmentRoot root = this.anyPackageFragmentRoot();
            if (root == null) {
                return null;
            }
            return root.getPath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IPackageFragmentRoot anyPackageFragmentRoot() {
            Map<String, IPackageFragmentRoot> map = this.associatedRoots;
            synchronized (map) {
                block4: {
                    if (!this.associatedRoots.isEmpty()) break block4;
                    return null;
                }
                return this.associatedRoots.values().iterator().next();
            }
        }

        public void addRoot(IPackageFragmentRoot root) {
            if (root != null) {
                if ("JImageModuleFragmentBridge".equals(root.getClass().getSimpleName())) {
                    return;
                }
                this.associatedRoots.put(root.getHandleIdentifier(), root);
            }
        }
    }
}

