/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.xtext.ui.refactoring.IRenameRefactoringProvider;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameProcessor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

public class DefaultRenameRefactoringProvider
implements IRenameRefactoringProvider {
    @Inject
    private Provider<AbstractRenameProcessor> processorProvider;

    @Override
    public ProcessorBasedRefactoring getRenameRefactoring(IRenameElementContext renameElementContext) {
        RenameProcessor processor = this.getRenameProcessor(renameElementContext);
        if (processor != null) {
            return new RenameRefactoring(processor);
        }
        return null;
    }

    @Override
    public RenameProcessor getRenameProcessor(IRenameElementContext renameElementContext) {
        AbstractRenameProcessor processor = (AbstractRenameProcessor)((Object)this.processorProvider.get());
        if (processor != null && processor.initialize(renameElementContext)) {
            return processor;
        }
        return null;
    }

    protected static class RenameRefactoring
    extends ProcessorBasedRefactoring {
        private RenameProcessor fProcessor;

        public RenameRefactoring(RenameProcessor processor) {
            super((RefactoringProcessor)processor);
            Assert.isNotNull((Object)processor);
            this.fProcessor = processor;
        }

        public RefactoringProcessor getProcessor() {
            return this.fProcessor;
        }

        protected RefactoringTickProvider doGetRefactoringTickProvider() {
            return new RefactoringTickProvider(1, 200, 1, 1);
        }
    }
}

