/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeModelBasedRegionAccessBuilder;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.resource.XtextResource;

public class NodeModelBasedRegionAccess
extends AbstractRegionAccess {
    private final Map<EObject, AbstractEObjectRegion> eObjectToTokens;
    private final XtextResource resource;

    protected NodeModelBasedRegionAccess(NodeModelBasedRegionAccessBuilder builder) {
        this.resource = builder.getXtextResource();
        this.eObjectToTokens = ImmutableMap.copyOf(builder.getEObjectToTokensMap(this));
    }

    @Override
    public XtextResource getResource() {
        return this.resource;
    }

    @Override
    protected String getText() {
        return this.getResource().getParseResult().getRootNode().getText();
    }

    @Override
    public String textForOffset(int offset, int length) {
        return this.getResource().getParseResult().getRootNode().getText().substring(offset, offset + length);
    }

    @Override
    public AbstractEObjectRegion regionForEObject(EObject obj) {
        return this.eObjectToTokens.get(obj);
    }

    @Override
    public IEObjectRegion regionForRootEObject() {
        return this.regionForEObject((EObject)this.resource.getContents().get(0));
    }

    @Override
    public ITextSegment regionForDocument() {
        return new TextSegment(this, 0, this.resource.getParseResult().getRootNode().getTotalEndOffset());
    }

    @Override
    public boolean hasSyntaxError() {
        return this.resource.getParseResult().hasSyntaxErrors();
    }
}

