/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.scoping.featurecalls.AbstractFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.typing.SynonymTypesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFeaturesForTypeProvider
extends AbstractFeaturesForTypeProvider {
    @Inject
    private SynonymTypesProvider synonymTypesProvider;

    @Override
    public Iterable<JvmFeature> getFeaturesByName(String name, JvmTypeReference declarator, Iterable<JvmTypeReference> hierarchy) {
        return this.doGetFeaturesByName(name, declarator, hierarchy);
    }

    protected Iterable<JvmFeature> doGetFeaturesByName(String name, JvmTypeReference declarator, Iterable<JvmTypeReference> hierarchy) {
        if (declarator == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        List rawTypes = this.getRawTypeHelper().getAllRawTypes(declarator, null);
        for (JvmType rawType : rawTypes) {
            if (!(rawType instanceof JvmDeclaredType)) continue;
            this.collectFeatures(name, rawType, result);
        }
        for (JvmTypeReference synonym : this.synonymTypesProvider.getSynonymTypes(declarator, false)) {
            List synonymRawTypes = this.getRawTypeHelper().getAllRawTypes(synonym, declarator.eResource());
            for (JvmType synonymRawType : synonymRawTypes) {
                if (!(synonymRawType instanceof JvmDeclaredType) || rawTypes.contains(synonymRawType)) continue;
                this.collectFeatures(name, synonymRawType, result);
            }
        }
        return result;
    }

    protected void collectFeatures(String name, JvmType rawType, List<JvmFeature> result) {
        if (rawType instanceof JvmDeclaredType) {
            if (name != null) {
                Iterables.addAll(result, (Iterable)((JvmDeclaredType)rawType).findAllFeaturesByName(name));
            } else {
                Iterables.addAll(result, (Iterable)((JvmDeclaredType)rawType).getAllFeatures());
            }
        }
    }

    @Override
    public Iterable<JvmFeature> getAllFeatures(JvmTypeReference declarator, Iterable<JvmTypeReference> hierarchy) {
        return this.doGetFeaturesByName(null, declarator, hierarchy);
    }

    @Override
    public boolean isExtensionProvider() {
        return false;
    }
}

