/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.access.impl.Primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaReflectAccess {
    private static final Logger log = Logger.getLogger(JavaReflectAccess.class);
    private ClassLoader classLoader = this.getClass().getClassLoader();

    @Inject(optional=true)
    public void setClassLoader(ClassLoader classlaoder) {
        this.classLoader = classlaoder;
    }

    public Field getField(JvmField field) {
        Class<?> class1 = this.getRawType(field.getDeclaringType());
        if (class1 == null) {
            return null;
        }
        try {
            return class1.getDeclaredField(field.getSimpleName());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public Method getMethod(JvmExecutable exe) {
        Class<?> class1 = this.getRawType(exe.getDeclaringType());
        if (class1 == null) {
            return null;
        }
        if (exe instanceof JvmOperation) {
            Class<?>[] paramTypes = this.getParamTypes(exe);
            try {
                return class1.getDeclaredMethod(exe.getSimpleName(), paramTypes);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public Class<?> getRawType(JvmType type) {
        if (type.eIsProxy()) {
            throw new IllegalStateException("Cannot resolve proxy: " + EcoreUtil.getURI((EObject)type));
        }
        if (type instanceof JvmTypeParameter) {
            JvmTypeParameter tp = (JvmTypeParameter)type;
            EList constraints = tp.getConstraints();
            for (JvmTypeConstraint jvmTypeConstraint : constraints) {
                if (!(jvmTypeConstraint instanceof JvmUpperBound)) continue;
                return this.getRawType(jvmTypeConstraint.getTypeReference());
            }
            return Object.class;
        }
        try {
            if (type instanceof JvmPrimitiveType) {
                return Primitives.forName(type.getCanonicalName());
            }
            return this.classLoader.loadClass(type.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private Class<?>[] getParamTypes(JvmExecutable exe) {
        EList<JvmFormalParameter> parameters = ((JvmOperation)exe).getParameters();
        ArrayList result = Lists.newArrayList();
        for (JvmFormalParameter p : parameters) {
            result.add(this.getRawType(p.getParameterType()));
        }
        return result.toArray(new Class[result.size()]);
    }

    private Class<?> getRawType(JvmTypeReference ref) {
        return this.getRawType(ref.getType());
    }
}

