/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.parser;

import org.eclipse.uml2.diagram.parser.ExternalToString;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.VisibilityKind;

public abstract class AbstractToString
implements ExternalToString {
    protected String getVisibility(NamedElement namedElement) {
        VisibilityKind visibility = namedElement.getVisibility();
        switch (visibility.getValue()) {
            case 3: {
                return "~";
            }
            case 1: {
                return "-";
            }
            case 2: {
                return "#";
            }
            case 0: {
                return "";
            }
        }
        throw new IllegalArgumentException("Unknown visibility for :" + namedElement + ", that is: " + visibility);
    }

    protected void appendName(StringBuffer result, NamedElement namedElement) {
        if (namedElement == null) {
            return;
        }
        String name = namedElement.getName();
        if (!AbstractToString.isEmpty(name)) {
            result.append(name);
        }
    }

    protected void appendType(StringBuffer result, TypedElement typedElement) {
        if (typedElement == null) {
            return;
        }
        Type type = typedElement.getType();
        if (type == null) {
            return;
        }
        AbstractToString.appendType(result, type.getName());
    }

    protected static void appendType(StringBuffer result, String typeName) {
        if (AbstractToString.isEmpty(typeName)) {
            return;
        }
        result.append(" : ");
        result.append(typeName);
    }

    protected static boolean isEmpty(String text) {
        return text == null || text.trim().length() == 0;
    }

    protected void appendMultiplicity(StringBuffer result, MultiplicityElement element) {
        this.appendMultiplicity(result, element, true);
    }

    protected void appendMultiplicity(StringBuffer result, MultiplicityElement element, boolean skipIfExactlyOne) {
        if (element == null) {
            return;
        }
        int lower = element.getLower();
        int upper = element.getUpper();
        if (upper == 1 && lower == 1 && skipIfExactlyOne) {
            return;
        }
        result.append(" [");
        if (lower != upper) {
            result.append(lower);
            result.append('.').append('.');
        }
        if (upper == -1) {
            result.append('*');
        } else {
            result.append(upper);
        }
        result.append(']');
    }

    protected static class ModifiersBuilder {
        private final StringBuffer myBuffer = new StringBuffer();

        public void appendModifier(String modifier) {
            if (modifier.length() == 0) {
                return;
            }
            if (this.myBuffer.length() != 0) {
                this.myBuffer.append(", ");
            }
            this.myBuffer.append(modifier);
        }

        public void writeInto(StringBuffer output) {
            if (this.myBuffer.length() == 0) {
                return;
            }
            output.append(" ");
            output.append("{ ");
            output.append(this.myBuffer);
            output.append(" }");
        }

        public String toString() {
            return super.toString();
        }
    }
}

