/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.language;

import com.google.common.collect.ImmutableSet;
import java.util.EventObject;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.language.ILanguage;

public class LanguageChangeEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    private final int type;
    private final URI modelURI;
    private final boolean uriHasExtension;
    private final Set<ILanguage> languages;

    public LanguageChangeEvent(Object source, int type, URI modelURI, boolean uriHasExtension, Iterable<ILanguage> languages) {
        super(source);
        this.type = type;
        this.modelURI = modelURI;
        this.uriHasExtension = uriHasExtension;
        this.languages = ImmutableSet.copyOf(languages);
    }

    public int getType() {
        return this.type;
    }

    public URI getModelURI() {
        return this.modelURI;
    }

    public boolean getURIHasExtension() {
        return this.uriHasExtension;
    }

    public Set<ILanguage> getLanguages() {
        return this.languages;
    }
}

