/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.providers;

import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.GetIconOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.IIconProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.swt.graphics.Image;

public class ElementTypeIconProvider
extends AbstractProvider
implements IIconProvider {
    public boolean provides(IOperation operation) {
        boolean result = operation instanceof GetIconOperation;
        if (result) {
            GetIconOperation getIcon = (GetIconOperation)operation;
            result = getIcon.getHint().getAdapter(IElementType.class) != null;
        }
        return result;
    }

    public Image getIcon(IAdaptable hint, int flags) {
        Image result = null;
        IElementType elementType = (IElementType)AdapterUtils.adapt((Object)hint, IElementType.class, null);
        if (elementType != null) {
            URL url = elementType.getIconURL();
            result = url == null ? null : this.getIcon(url);
        }
        return result;
    }

    protected Image getIcon(URL iconURL) {
        return ExtendedImageRegistry.INSTANCE.getImage((Object)iconURL);
    }

    protected URL getIconURL(IElementType elementType) {
        ISpecializationType subtype;
        IElementType[] supertypes;
        URL result = elementType.getIconURL();
        if (result == null && elementType instanceof ISpecializationType && (supertypes = (subtype = (ISpecializationType)elementType).getSpecializedTypes()) != null) {
            int i = 0;
            while (result == null && i < supertypes.length) {
                result = this.getIconURL(supertypes[i]);
                ++i;
            }
        }
        return result;
    }
}

