/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.editor;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.nattable.editor.AbstractUMLMultiValueCellEditor;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Stereotype;

public abstract class AbstractMultiValuePrimitiveTypeCellEditor
extends AbstractUMLMultiValueCellEditor {
    protected AbstractMultiValuePrimitiveTypeCellEditor(Object axisElement, ITableAxisElementProvider elementProvider) {
        super(axisElement, elementProvider);
    }

    @Override
    protected Object createDialog(EObject realEditedObject, EStructuralFeature realFeature, Stereotype stereotype, ResourceSet resourceSet) {
        ReferenceValueFactory factory;
        Collection coll;
        UMLContentProvider p = new UMLContentProvider(realEditedObject, realFeature, stereotype, resourceSet);
        String title = realFeature.getName();
        boolean unique = realFeature.isUnique();
        boolean ordered = realFeature.isOrdered();
        int upperBound = realFeature.getUpperBound();
        Object value = realEditedObject.eGet(realFeature);
        IElementSelector selector = this.getElementSelector(unique, (ILabelProvider)new UMLLabelProvider(), (IStaticContentProvider)p);
        MultipleValueDialog dialog = new MultipleValueDialog(Display.getCurrent().getActiveShell(), selector, title, unique, ordered, upperBound){

            protected void okPressed() {
                Object[] result;
                super.okPressed();
                ArrayList<Object> newValue = new ArrayList<Object>();
                Object[] objectArray = result = this.getResult();
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    newValue.add(object);
                    ++n2;
                }
                AbstractMultiValuePrimitiveTypeCellEditor.this.returnedValue = newValue;
                AbstractMultiValuePrimitiveTypeCellEditor.this.editHandler.commit(newValue, SelectionLayer.MoveDirectionEnum.NONE);
            }
        };
        dialog.setContextElement((Object)realEditedObject);
        dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        if (value != null && value instanceof Collection && !(coll = (Collection)value).isEmpty()) {
            dialog.setInitialSelections(coll.toArray());
        }
        if ((factory = this.getFactory()) != null) {
            dialog.setFactory(factory);
        }
        return dialog;
    }
}

