/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.core.composite;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.Messages;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.core.composite.AbstractIResourceComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CoreIFileComposite
extends AbstractIResourceComposite<IFile> {
    public CoreIFileComposite(Composite parent) {
        super(parent);
    }

    public CoreIFileComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public IFile getValue() {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getText().getText());
        if (member instanceof IFile) {
            IFile file = (IFile)member;
            return file;
        }
        return null;
    }

    @Override
    protected final void browseResource() {
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        elementTreeSelectionDialog.setMessage(Messages.CoreIFileComposite_selectFile);
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setDoubleClickSelects(true);
        elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length != 1 || !(selection[0] instanceof IFile)) {
                    return new Status(4, "org.eclipse.papyrus.emf.facet.widgets.celleditors", Messages.CoreIFileComposite_mustSelectFile);
                }
                return Status.OK_STATUS;
            }
        });
        elementTreeSelectionDialog.open();
        Object result = elementTreeSelectionDialog.getFirstResult();
        if (result != null && result instanceof IFile) {
            IFile selectedFile = (IFile)result;
            this.setValue((IResource)selectedFile);
            this.fireCommit();
        }
    }
}

