/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.outline;

import org.eclipse.core.text.StringMatcher;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class QuickOutlineNamePatternFilter
extends ViewerFilter {
    private StringMatcher fStringMatcher = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fStringMatcher == null || !(viewer instanceof TreeViewer)) {
            return true;
        }
        TreeViewer treeViewer = (TreeViewer)viewer;
        String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
        if (matchName != null && this.fStringMatcher.match(matchName)) {
            return true;
        }
        return this.hasUnfilteredChild(treeViewer, element);
    }

    private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
        Object[] children;
        Object[] objectArray = children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (this.select((Viewer)viewer, element, child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setStringMatcher(StringMatcher stringMatcher) {
        this.fStringMatcher = stringMatcher;
    }
}

