/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.AbstractRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.GMFT_BasedRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.InducedRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.Representation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.UseContext;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;

public class ChildrenListRepresentation {
    private static final String DEBUG_PREFIX = "[EXPANSION_DIAGRAM]";
    public HashMap<String, AbstractRepresentation> IDMap = new HashMap();
    public HashMap<String, List<String>> parentChildrenRelation = new HashMap();
    protected UseContext useContext;

    public ChildrenListRepresentation(UseContext useContext) {
        this.useContext = useContext;
        this.initStructure();
    }

    protected void createStructure(AbstractRepresentation representation, ArrayList<String> idListToAdd) {
        if (representation instanceof Representation) {
            String hint = null;
            if (representation instanceof GMFT_BasedRepresentation) {
                hint = ((GMFT_BasedRepresentation)representation).getReusedID();
            } else if (((Representation)representation).getGraphicalElementTypeRef() != null && ((Representation)representation).getGraphicalElementTypeRef() instanceof ElementTypeConfiguration) {
                ElementTypeConfiguration elementTypeConfiguration = ((Representation)representation).getGraphicalElementTypeRef();
                IElementType elementType = ElementTypeRegistry.getInstance().getType(elementTypeConfiguration.getIdentifier());
                if (elementType instanceof IHintedType) {
                    hint = ((IHintedType)elementType).getSemanticHint();
                }
            }
            idListToAdd.add(hint);
            if (this.IDMap.get(hint) == null) {
                this.IDMap.put(hint, representation);
                ArrayList<String> subRepresentationIDs = new ArrayList<String>();
                for (InducedRepresentation compartments : ((Representation)representation).getInducedRepresentations()) {
                    this.createStructure(compartments, subRepresentationIDs);
                }
                for (Representation subRepresentation : ((Representation)representation).getSubRepresentations()) {
                    this.createStructure(subRepresentation, subRepresentationIDs);
                }
                if (subRepresentationIDs.size() > 0) {
                    this.parentChildrenRelation.put(hint, subRepresentationIDs);
                }
            }
        } else if (representation instanceof InducedRepresentation) {
            idListToAdd.add(((InducedRepresentation)representation).getHint());
            if (this.IDMap.get(((InducedRepresentation)representation).getHint()) == null) {
                this.IDMap.put(((InducedRepresentation)representation).getHint(), representation);
                ArrayList<String> compartmentChildreen = new ArrayList<String>();
                for (Representation subRepresentation : ((InducedRepresentation)representation).getChildren()) {
                    this.createStructure(subRepresentation, compartmentChildreen);
                }
                if (compartmentChildreen.size() > 0) {
                    this.parentChildrenRelation.put(((InducedRepresentation)representation).getHint(), compartmentChildreen);
                }
            }
        }
    }

    protected void initStructure() {
        ArrayList<String> childreen = new ArrayList<String>();
        for (Representation currentR : this.useContext.getRepresentations()) {
            this.createStructure(currentR, childreen);
        }
        this.parentChildrenRelation.put(this.useContext.getDiagramType(), childreen);
    }

    public String toString() {
        String out = "[EXPANSION_DIAGRAM]+ChildrenListRepresentation for " + this.useContext.getDiagramType();
        out = out + "\n[EXPANSION_DIAGRAM]+-->ID - Representation";
        for (String currentID : this.IDMap.keySet()) {
            out = out + "\n[EXPANSION_DIAGRAM]    \"" + currentID + "\" " + String.valueOf(this.IDMap.get(currentID));
        }
        out = out + "\n[EXPANSION_DIAGRAM]+--> ParentID- ChildrenIDs";
        for (String currentID : this.parentChildrenRelation.keySet()) {
            out = out + "\n[EXPANSION_DIAGRAM]    \"" + currentID + "\" " + String.valueOf(this.parentChildrenRelation.get(currentID));
        }
        return out;
    }
}

