/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.builder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotDiagnostician;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.validation.ValidationContext;
import org.eclipse.ocl.pivot.validation.ValidationRegistryAdapter;
import org.eclipse.ocl.xtext.base.ui.builder.ValidationEntry;
import org.eclipse.ocl.xtext.base.ui.messages.BaseUIMessages;
import org.eclipse.ocl.xtext.base.utilities.PivotDiagnosticConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.IDiagnosticConverter;
import org.eclipse.xtext.validation.Issue;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class MultiValidationJob
extends Job {
    public static final @NonNull TracingOption VALIDATOR = new TracingOption("org.eclipse.ocl.xtext.base.ui", "validator");
    private static final Logger log = Logger.getLogger(MultiValidationJob.class);
    private static final @NonNull IDiagnosticConverter converter = new PivotDiagnosticConverter();
    private final @NonNull ValidationQueue validationQueue = new ValidationQueue();

    public MultiValidationJob() {
        super(BaseUIMessages.MultiValidationJob_Name);
    }

    public void addValidations(@NonNull Iterable<@NonNull ValidationEntry> entries) {
        int state;
        if (this.validationQueue.addAll(entries) && (state = this.getState()) == 0) {
            this.schedule();
        }
    }

    protected synchronized void canceling() {
        this.validationQueue.clear();
        super.canceling();
    }

    protected boolean checkResourceErrors(@NonNull AddMarkersOperation operation, @NonNull Resource resource, @NonNull IProgressMonitor monitor) {
        if (operation.isEMF()) {
            for (Resource.Diagnostic error : resource.getErrors()) {
                if (monitor.isCanceled()) {
                    return false;
                }
                operation.accept(error, 4);
            }
            for (Resource.Diagnostic warning : resource.getWarnings()) {
                if (monitor.isCanceled()) {
                    return false;
                }
                operation.accept(warning, 2);
            }
        } else {
            for (Resource.Diagnostic error : resource.getErrors()) {
                if (monitor.isCanceled()) {
                    return false;
                }
                converter.convertResourceDiagnostic(error, Severity.ERROR, (IAcceptor)operation);
            }
            for (Resource.Diagnostic warning : resource.getWarnings()) {
                if (monitor.isCanceled()) {
                    return false;
                }
                converter.convertResourceDiagnostic(warning, Severity.WARNING, (IAcceptor)operation);
            }
        }
        return true;
    }

    protected boolean checkValidatorDiagnostics(@NonNull AddMarkersOperation operation, @NonNull Resource resource, @NonNull IProgressMonitor monitor) {
        ResourceSet resourceSet = resource.getResourceSet();
        assert (resourceSet != null);
        ValidationRegistryAdapter validationRegistry = ValidationRegistryAdapter.getAdapter((ResourceSet)resourceSet);
        ValidationContext validationContext = new ValidationContext((EValidator.Registry)validationRegistry);
        PivotDiagnostician.BasicDiagnosticWithRemove diagnostics = new PivotDiagnostician.BasicDiagnosticWithRemove("org.eclipse.emf.ecore", 0, EcorePlugin.INSTANCE.getString("_UI_DiagnosticRoot_diagnostic", new Object[]{resource.getURI()}), new Object[]{resource});
        Diagnostician diagnostician = validationContext.getDiagnostician();
        for (EObject eObject : resource.getContents()) {
            if (monitor.isCanceled()) {
                return false;
            }
            diagnostician.validate(eObject, (DiagnosticChain)diagnostics, (Map)validationContext);
        }
        this.convertValidatorDiagnostics(operation, (Diagnostic)diagnostics, null);
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void convertValidatorDiagnostics(@NonNull AddMarkersOperation operation, @NonNull Diagnostic diagnostic, @Nullable Diagnostic parentDiagnostic) {
        if (diagnostic.getChildren().isEmpty()) {
            operation.accept(diagnostic, null);
        } else {
            @NonNull List childDiagnostics = ClassUtil.nullFree((List)diagnostic.getChildren());
            if (diagnostic.getMessage() == null) {
                for (Diagnostic childDiagnostic : childDiagnostics) {
                    this.convertValidatorDiagnostics(operation, childDiagnostic, null);
                }
            } else {
                for (Diagnostic childDiagnostic : childDiagnostics) {
                    operation.accept(childDiagnostic, diagnostic);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doValidate(@NonNull ValidationEntry entry, @NonNull SubMonitor monitor) throws CoreException {
        block73: {
            block75: {
                block76: {
                    block74: {
                        block72: {
                            throwable = null;
                            operation = null;
                            file = entry.getFile();
                            project = file.getProject();
                            if (project != null && project.isOpen()) break block72;
                            var16_8 = entry;
                            synchronized (var16_8) {
                                if (throwable != null) {
                                    if (throwable instanceof WrappedException) {
                                        entry.setThrowable(((WrappedException)throwable).getCause());
                                    } else {
                                        entry.setThrowable(throwable);
                                    }
                                } else if (operation != null) {
                                    entry.setMarkerDatas(operation.getMarkerDatas());
                                }
                                entry.notifyAll();
                            }
                            ThreadLocalExecutor.reset();
                            return;
                        }
                        ThreadLocalExecutor.reset();
                        ocl = entry.createOCL();
                        environmentFactory = ocl.getEnvironmentFactory();
                        classLoader = this.getClassLoader(project);
                        if (classLoader != null) {
                            ((MetamodelManagerInternal)environmentFactory.getMetamodelManager()).addClassLoader(classLoader);
                        }
                        monitor.worked(1);
                        markerType = entry.getMarkerId();
                        uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                        resourceSet = ocl.getResourceSet();
                        resource = null;
                        try {
                            resource = resourceSet.getResource(uri, true);
                        }
                        catch (Exception e) {
                            throwable = e;
                        }
                        monitor.worked(1);
                        operation = new AddMarkersOperation((IResource)file, markerType);
                        if (resource == null) break block73;
                        EcoreUtil.resolveAll((ResourceSet)resourceSet);
                        monitor.worked(3);
                        if (this.checkResourceErrors(operation, resource, (IProgressMonitor)monitor)) break block74;
                        var16_9 = entry;
                        synchronized (var16_9) {
                            if (throwable != null) {
                                if (throwable instanceof WrappedException) {
                                    entry.setThrowable(((WrappedException)throwable).getCause());
                                } else {
                                    entry.setThrowable(throwable);
                                }
                            } else if (operation != null) {
                                entry.setMarkerDatas(operation.getMarkerDatas());
                            }
                            entry.notifyAll();
                        }
                        ThreadLocalExecutor.reset();
                        return;
                    }
                    if (!(resource instanceof CSResource)) break block75;
                    asResource = ((CSResource)resource).getASResource();
                    if (this.checkResourceErrors(operation, (Resource)asResource, (IProgressMonitor)monitor)) break block76;
                    var16_10 = entry;
                    synchronized (var16_10) {
                        if (throwable != null) {
                            if (throwable instanceof WrappedException) {
                                entry.setThrowable(((WrappedException)throwable).getCause());
                            } else {
                                entry.setThrowable(throwable);
                            }
                        } else if (operation != null) {
                            entry.setMarkerDatas(operation.getMarkerDatas());
                        }
                        entry.notifyAll();
                    }
                    ThreadLocalExecutor.reset();
                    return;
                }
                if (this.checkValidatorDiagnostics(operation, (Resource)asResource, (IProgressMonitor)monitor)) ** GOTO lbl132
                var16_11 = entry;
                synchronized (var16_11) {
                    if (throwable != null) {
                        if (throwable instanceof WrappedException) {
                            entry.setThrowable(((WrappedException)throwable).getCause());
                        } else {
                            entry.setThrowable(throwable);
                        }
                    } else if (operation != null) {
                        entry.setMarkerDatas(operation.getMarkerDatas());
                    }
                    entry.notifyAll();
                }
                ThreadLocalExecutor.reset();
                return;
            }
            if (this.checkValidatorDiagnostics(operation, resource, (IProgressMonitor)monitor)) ** GOTO lbl132
            var16_12 = entry;
            synchronized (var16_12) {
                if (throwable != null) {
                    if (throwable instanceof WrappedException) {
                        entry.setThrowable(((WrappedException)throwable).getCause());
                    } else {
                        entry.setThrowable(throwable);
                    }
                } else if (operation != null) {
                    entry.setMarkerDatas(operation.getMarkerDatas());
                }
                entry.notifyAll();
            }
            ThreadLocalExecutor.reset();
            return;
        }
        try {
            try {
                monitor.worked(1);
                operation.addMessage("org.eclipse.ocl.xtext.base.ui.Marker", 2, "Failed to create EMF Resource for '" + uri + "'");
lbl132:
                // 3 sources

                monitor.worked(1);
                try {
                    operation.run((IProgressMonitor)monitor);
                }
                catch (InvocationTargetException e) {
                    MultiValidationJob.log.error((Object)"Could not create marker.", (Throwable)e);
                }
                catch (InterruptedException var14_25) {
                    // empty catch block
                }
                monitor.worked(1);
                ocl.dispose();
                ThreadLocalExecutor.reset();
            }
            catch (Throwable e) {
                if (throwable == null) {
                    throwable = e;
                }
                throw e;
            }
        }
        catch (Throwable var15_26) {
            var16_13 = entry;
            synchronized (var16_13) {
                if (throwable != null) {
                    if (throwable instanceof WrappedException) {
                        entry.setThrowable(((WrappedException)throwable).getCause());
                    } else {
                        entry.setThrowable(throwable);
                    }
                } else if (operation != null) {
                    entry.setMarkerDatas(operation.getMarkerDatas());
                }
                entry.notifyAll();
            }
            ThreadLocalExecutor.reset();
            throw var15_26;
        }
        var16_14 = entry;
        synchronized (var16_14) {
            if (throwable != null) {
                if (throwable instanceof WrappedException) {
                    entry.setThrowable(((WrappedException)throwable).getCause());
                } else {
                    entry.setThrowable(throwable);
                }
            } else if (operation != null) {
                entry.setMarkerDatas(operation.getMarkerDatas());
            }
            entry.notifyAll();
        }
        ThreadLocalExecutor.reset();
    }

    protected @Nullable ClassLoader getClassLoader(@NonNull IProject project) throws CoreException {
        Bundle bundle = Platform.getBundle((String)project.getName());
        if (bundle != null) {
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (bundleWiring != null) {
                return bundleWiring.getClassLoader();
            }
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String[] defaultRuntimeClassPath = null;
        try {
            defaultRuntimeClassPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (defaultRuntimeClassPath == null) {
            return null;
        }
        ArrayList<@NonNull URL> urlList = new ArrayList<URL>();
        String[] stringArray = defaultRuntimeClassPath;
        int n = defaultRuntimeClassPath.length;
        int n2 = 0;
        while (n2 < n) {
            String classPathEntry = stringArray[n2];
            Path classPathEntryPath = new Path(classPathEntry);
            java.net.URI classPathEntryURI = classPathEntryPath.toFile().toURI();
            try {
                urlList.add(classPathEntryURI.toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        @NonNull URL[] urlArray = urlList.toArray(new URL[urlList.size()]);
        return new URLClassLoader(urlArray, javaProject.getClass().getClassLoader());
    }

    protected IStatus run(IProgressMonitor monitor) {
        List<ValidationEntry> validationList;
        while (!(validationList = this.validationQueue.getValidationList()).isEmpty()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(5 * validationList.size()));
            Collections.sort(validationList, NameUtil.TO_STRING_COMPARATOR);
            for (ValidationEntry entry : validationList) {
                block14: {
                    long end;
                    if (subMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    long start = System.currentTimeMillis();
                    try {
                        String message = NLS.bind((String)BaseUIMessages.MultiValidationJob_Validating, (Object)entry.getFile().getFullPath().toString());
                        subMonitor.subTask(message);
                        this.doValidate(entry, subMonitor);
                    }
                    catch (OperationCanceledException canceled) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        if (VALIDATOR.isActive()) {
                            end = System.currentTimeMillis();
                            VALIDATOR.println(String.valueOf(end - start) + " ms for \"" + entry.getFile().getFullPath().toString() + "\" on \"" + Thread.currentThread().getName() + "\"");
                        }
                        return iStatus;
                    }
                    catch (Throwable e) {
                        try {
                            log.error((Object)("Error running " + this.getName()), e);
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (VALIDATOR.isActive()) {
                                end = System.currentTimeMillis();
                                VALIDATOR.println(String.valueOf(end - start) + " ms for \"" + entry.getFile().getFullPath().toString() + "\" on \"" + Thread.currentThread().getName() + "\"");
                            }
                        }
                    }
                    if (VALIDATOR.isActive()) {
                        end = System.currentTimeMillis();
                        VALIDATOR.println(String.valueOf(end - start) + " ms for \"" + entry.getFile().getFullPath().toString() + "\" on \"" + Thread.currentThread().getName() + "\"");
                    }
                }
                this.validationQueue.remove(entry);
                subMonitor.worked(1);
            }
            subMonitor.done();
        }
        if (monitor != null) {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected static class AddMarkersOperation
    extends WorkspaceModifyOperation
    implements IAcceptor<Issue> {
        protected final @NonNull IResource resource;
        protected final @NonNull String issueMarkerType;
        protected final @NonNull List<@NonNull MarkerData> markerDatas = new ArrayList<MarkerData>();

        public AddMarkersOperation(@NonNull IResource resource, @NonNull String issueMarkerType) {
            this.resource = resource;
            this.issueMarkerType = issueMarkerType;
        }

        public void accept(@NonNull Diagnostic diagnostic, @Nullable Diagnostic parentDiagnostic) {
            if (diagnostic.getSeverity() != 0) {
                this.markerDatas.add(new DiagnosticMarkerData(diagnostic, this.issueMarkerType, parentDiagnostic));
            }
        }

        public void accept(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Resource.Diagnostic diagnostic, int severity) {
            this.markerDatas.add(new ResourceDiagnosticMarkerData(diagnostic, this.issueMarkerType, severity));
        }

        public void accept(@NonNull Issue issue) {
            this.markerDatas.add(new IssueMarkerData(this.resource, this.issueMarkerType, issue));
        }

        public void addMessage(String markerType, int severity, @NonNull String message) {
            assert (markerType != null);
            this.markerDatas.add(new SimpleMarkerData(markerType, severity, message));
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            if (!this.resource.exists()) {
                return;
            }
            this.resource.deleteMarkers(this.issueMarkerType, true, 2);
            for (MarkerData markerData : this.markerDatas) {
                if (monitor.isCanceled()) {
                    return;
                }
                markerData.createMarker(this.resource);
            }
        }

        public @NonNull List<@NonNull MarkerData> getMarkerDatas() {
            return this.markerDatas;
        }

        public boolean isEMF() {
            return this.issueMarkerType == "org.eclipse.emf.ecore.diagnostic";
        }
    }

    protected static class DiagnosticMarkerData
    implements MarkerData {
        protected final @NonNull String markerType;
        protected final @NonNull Object severity;
        protected final String message;
        protected @Nullable String location = null;
        protected Integer lineNumber = null;
        protected @Nullable String uriAttribute = null;
        protected final @Nullable String relatedURIsAttribute;

        public DiagnosticMarkerData(@NonNull Diagnostic diagnostic, @NonNull String markerType, @Nullable Diagnostic parentDiagnostic) {
            this.markerType = markerType;
            int severity = diagnostic.getSeverity();
            this.severity = severity < 2 ? Integer.valueOf(0) : (severity < 4 ? Integer.valueOf(1) : Integer.valueOf(2));
            this.message = diagnostic.getMessage();
            List data = diagnostic.getData();
            if (data == null && parentDiagnostic != null) {
                data = parentDiagnostic.getData();
            }
            StringBuilder relatedURIs = null;
            if (data != null) {
                boolean first = true;
                for (Object element : data) {
                    Resource.Diagnostic resourceDiagnostic;
                    if (element instanceof EObject) {
                        EObject eObject = (EObject)element;
                        if (first) {
                            first = false;
                            this.uriAttribute = EcoreUtil.getURI((EObject)eObject).toString();
                            continue;
                        }
                        if (relatedURIs == null) {
                            relatedURIs = new StringBuilder();
                        } else {
                            relatedURIs.append(' ');
                        }
                        relatedURIs.append(URI.encodeFragment((String)EcoreUtil.getURI((EObject)eObject).toString(), (boolean)false));
                        continue;
                    }
                    if (!(element instanceof Resource.Diagnostic) || (resourceDiagnostic = (Resource.Diagnostic)element).getLocation() == null) continue;
                    String lineString = Integer.toString(resourceDiagnostic.getLine());
                    String columnString = Integer.toString(resourceDiagnostic.getColumn());
                    this.location = EMFEditUIPlugin.getPlugin().getString("_UI_MarkerLocation", (Object[])new String[]{lineString, columnString});
                    this.lineNumber = resourceDiagnostic.getLine();
                    try {
                        Method getObjectMethod = resourceDiagnostic.getClass().getMethod("getObject", new Class[0]);
                        Object object = getObjectMethod.invoke((Object)resourceDiagnostic, new Object[0]);
                        if (!(object instanceof EObject)) break;
                        this.uriAttribute = EcoreUtil.getURI((EObject)((EObject)object)).toString();
                        Method getFeatureMethod = resourceDiagnostic.getClass().getMethod("getFeature", new Class[0]);
                        Object feature = getFeatureMethod.invoke((Object)resourceDiagnostic, new Object[0]);
                        if (!(feature instanceof EObject)) break;
                        if (relatedURIs == null) {
                            relatedURIs = new StringBuilder();
                        } else {
                            relatedURIs.append(' ');
                        }
                        relatedURIs.append(URI.encodeFragment((String)EcoreUtil.getURI((EObject)((EObject)feature)).toString(), (boolean)false));
                    }
                    catch (Throwable throwable) {}
                    break;
                }
            }
            this.relatedURIsAttribute = relatedURIs != null ? relatedURIs.toString() : null;
        }

        @Override
        public @NonNull IMarker createMarker(@NonNull IResource resource) throws CoreException {
            IMarker marker = resource.createMarker(this.markerType);
            marker.setAttribute("location", (Object)this.location);
            marker.setAttribute("severity", this.severity);
            marker.setAttribute("lineNumber", (Object)this.lineNumber);
            marker.setAttribute("message", (Object)this.message);
            if (this.uriAttribute != null) {
                marker.setAttribute("uri", (Object)this.uriAttribute);
            }
            if (this.relatedURIsAttribute != null) {
                marker.setAttribute("relatedURIs", (Object)this.relatedURIsAttribute);
            }
            return marker;
        }

        @Override
        public @NonNull String getMessageText() {
            return String.valueOf(this.message);
        }
    }

    protected static class IssueMarkerData
    implements MarkerData {
        protected final @NonNull String markerType;
        protected final @NonNull String location;
        protected final String codeKey;
        protected final @NonNull Object severity;
        protected final Integer charStart;
        protected @Nullable Integer charEnd;
        protected final Integer lineNumber;
        protected final Integer columnKey;
        protected final String message;
        protected @Nullable String uriKey;
        protected @Nullable String dataKey;
        protected final @Nullable String uriAttribute;
        protected @Nullable String relatedURIsAttribute = null;

        public IssueMarkerData(@NonNull IResource resource, @NonNull String markerType, @NonNull Issue issue) {
            this.markerType = markerType;
            String lineNR = "";
            if (issue.getLineNumber() != null) {
                lineNR = "line: " + issue.getLineNumber() + " ";
            }
            this.location = String.valueOf(lineNR) + resource.getFullPath().toString();
            this.codeKey = issue.getCode();
            switch (issue.getSeverity()) {
                case ERROR: {
                    this.severity = 2;
                    break;
                }
                case WARNING: {
                    this.severity = 1;
                    break;
                }
                case INFO: {
                    this.severity = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(issue.getSeverity()));
                }
            }
            this.charStart = issue.getOffset();
            if (issue.getOffset() != null && issue.getLength() != null) {
                this.charEnd = issue.getOffset() + issue.getLength();
            }
            this.lineNumber = issue.getLineNumber();
            this.columnKey = issue.getColumn();
            this.message = issue.getMessage();
            if (issue.getUriToProblem() != null) {
                this.uriKey = issue.getUriToProblem().toString();
            }
            if (issue.getData() != null && issue.getData().length > 0) {
                this.dataKey = Strings.pack((String[])issue.getData());
            }
            String[] data = issue.getData();
            StringBuilder relatedURIs = null;
            String uriAttribute = null;
            boolean first = true;
            if (data != null) {
                String[] stringArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (first) {
                        first = false;
                        uriAttribute = string;
                    } else {
                        if (relatedURIs == null) {
                            relatedURIs = new StringBuilder();
                        } else {
                            relatedURIs.append(' ');
                        }
                        relatedURIs.append(URI.encodeFragment((String)string, (boolean)false));
                    }
                    ++n2;
                }
            }
            this.uriAttribute = uriAttribute;
            if (relatedURIs != null) {
                this.relatedURIsAttribute = relatedURIs.toString();
            }
        }

        @Override
        public @NonNull IMarker createMarker(@NonNull IResource resource) throws CoreException {
            IMarker marker = resource.createMarker(this.markerType);
            marker.setAttribute("location", (Object)this.location);
            marker.setAttribute("CODE_KEY", (Object)this.codeKey);
            marker.setAttribute("severity", this.severity);
            marker.setAttribute("charStart", (Object)this.charStart);
            if (this.charEnd != null) {
                marker.setAttribute("charEnd", (Object)this.charEnd);
            }
            marker.setAttribute("lineNumber", (Object)this.lineNumber);
            marker.setAttribute("COLUMN_KEY", (Object)this.columnKey);
            marker.setAttribute("message", (Object)this.message);
            if (this.uriKey != null) {
                marker.setAttribute("URI_KEY", (Object)this.uriKey);
            }
            if (this.dataKey != null) {
                marker.setAttribute("DATA_KEY", (Object)this.dataKey);
            }
            if (this.uriAttribute != null) {
                marker.setAttribute("uri", (Object)this.uriAttribute);
            }
            if (this.relatedURIsAttribute != null) {
                marker.setAttribute("relatedURIs", (Object)this.relatedURIsAttribute);
            }
            return marker;
        }

        @Override
        public @NonNull String getMessageText() {
            return String.valueOf(this.message);
        }
    }

    public static interface MarkerData {
        public @NonNull IMarker createMarker(@NonNull IResource var1) throws CoreException;

        public @NonNull String getMessageText();
    }

    protected static class ResourceDiagnosticMarkerData
    implements MarkerData {
        protected final @NonNull String markerType;
        protected final @NonNull Object severity;
        protected final String message;
        protected @Nullable String location = null;
        protected Integer lineNumber = null;
        protected @Nullable String uriAttribute = null;
        protected final @Nullable String relatedURIsAttribute;

        public ResourceDiagnosticMarkerData(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Resource.Diagnostic diagnostic, @NonNull String markerType, int severity) {
            this.markerType = markerType;
            this.severity = severity < 2 ? Integer.valueOf(0) : (severity < 4 ? Integer.valueOf(1) : Integer.valueOf(2));
            this.message = diagnostic.getMessage();
            String relatedURIsAttribute = null;
            if (diagnostic.getLocation() != null) {
                String lineString = Integer.toString(diagnostic.getLine());
                String columnString = Integer.toString(diagnostic.getColumn());
                this.location = EMFEditUIPlugin.getPlugin().getString("_UI_MarkerLocation", (Object[])new String[]{lineString, columnString});
                this.lineNumber = diagnostic.getLine();
                try {
                    Method getObjectMethod = diagnostic.getClass().getMethod("getObject", new Class[0]);
                    Object object = getObjectMethod.invoke((Object)diagnostic, new Object[0]);
                    if (object instanceof EObject) {
                        this.uriAttribute = EcoreUtil.getURI((EObject)((EObject)object)).toString();
                        Method getFeatureMethod = diagnostic.getClass().getMethod("getFeature", new Class[0]);
                        Object feature = getFeatureMethod.invoke((Object)diagnostic, new Object[0]);
                        if (feature instanceof EObject) {
                            relatedURIsAttribute = EcoreUtil.getURI((EObject)((EObject)feature)).toString();
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.relatedURIsAttribute = relatedURIsAttribute;
        }

        @Override
        public @NonNull IMarker createMarker(@NonNull IResource resource) throws CoreException {
            IMarker marker = resource.createMarker(this.markerType);
            marker.setAttribute("location", (Object)this.location);
            marker.setAttribute("severity", this.severity);
            marker.setAttribute("lineNumber", (Object)this.lineNumber);
            marker.setAttribute("message", (Object)this.message);
            if (this.uriAttribute != null) {
                marker.setAttribute("uri", (Object)this.uriAttribute);
            }
            if (this.relatedURIsAttribute != null) {
                marker.setAttribute("relatedURIs", (Object)this.relatedURIsAttribute);
            }
            return marker;
        }

        @Override
        public @NonNull String getMessageText() {
            return String.valueOf(this.message);
        }
    }

    protected static class SimpleMarkerData
    implements MarkerData {
        protected final @NonNull String markerType;
        protected final @NonNull Object severity;
        protected final @NonNull String message;

        public SimpleMarkerData(@NonNull String markerType, int severity, @NonNull String message) {
            this.markerType = markerType;
            this.severity = severity;
            this.message = message;
        }

        @Override
        public @NonNull IMarker createMarker(@NonNull IResource resource) throws CoreException {
            IMarker marker = resource.createMarker(this.markerType);
            marker.setAttribute("severity", this.severity);
            marker.setAttribute("message", (Object)this.message);
            return marker;
        }

        @Override
        public @NonNull String getMessageText() {
            return this.message;
        }
    }

    private static final class ValidationQueue {
        private final @NonNull Set<@NonNull ValidationEntry> queue = new HashSet<ValidationEntry>();

        private ValidationQueue() {
        }

        public synchronized boolean addAll(@NonNull Iterable<@NonNull ValidationEntry> entries) {
            boolean added = false;
            for (ValidationEntry entry : entries) {
                if (!this.queue.add(entry)) continue;
                added = true;
            }
            return added;
        }

        public synchronized void clear() {
            this.queue.clear();
        }

        public synchronized @NonNull List<@NonNull ValidationEntry> getValidationList() {
            return new ArrayList<ValidationEntry>(this.queue);
        }

        public synchronized void remove(@NonNull ValidationEntry entry) {
            this.queue.remove(entry);
        }
    }
}

