/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.TreeMap;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.jdbc.DelegatingConnection;
import org.eclipse.net4j.internal.db.DBDatabase;
import org.eclipse.net4j.internal.db.DBPreparedStatement;
import org.eclipse.net4j.internal.db.DBResultSet;
import org.eclipse.net4j.internal.db.DBSchemaTransaction;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.om.OMPlatform;

public final class DBConnection
extends DelegatingConnection
implements IDBConnection {
    private static final boolean VALIDATE_CHECKOUTS = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.internal.db.DBConnection.VALIDATE_CHECKOUTS");
    private final TreeMap<String, DBPreparedStatement> cache = new TreeMap();
    private HashBag<DBPreparedStatement> checkOuts;
    private final DBDatabase database;
    private int cacheSize;
    private int lastTouch;
    private boolean closed;

    public DBConnection(DBDatabase database, Connection delegate) {
        super(delegate);
        this.database = database;
        if (VALIDATE_CHECKOUTS) {
            this.checkOuts = new HashBag();
        }
        try {
            delegate.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new DBException(ex, "SET AUTO COMMIT = false");
        }
    }

    @Override
    public DBDatabase getDatabase() {
        return this.database;
    }

    public String getUserID() {
        return this.database.getUserID();
    }

    @Override
    public void close() {
        DBUtil.close(this.getDelegate());
        this.closed = true;
        this.database.closeConnection(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public IDBSchemaTransaction openSchemaTransaction() {
        DBSchemaTransaction schemaTransaction = this.database.openSchemaTransaction(this);
        return schemaTransaction;
    }

    @Override
    @Deprecated
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDBPreparedStatement prepareStatement(String sql, IDBPreparedStatement.ReuseProbability reuseProbability) {
        return this.prepareStatement(sql, 1003, 1007, reuseProbability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDBPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, IDBPreparedStatement.ReuseProbability reuseProbability) {
        DBPreparedStatement preparedStatement;
        this.database.beginSchemaAccess(false);
        DBConnection dBConnection = this;
        synchronized (dBConnection) {
            preparedStatement = this.cache.remove(sql);
            if (preparedStatement == null) {
                try {
                    PreparedStatement delegate = this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency);
                    preparedStatement = new DBPreparedStatement(this, sql, reuseProbability, delegate);
                }
                catch (SQLException ex) {
                    throw new DBException(ex);
                }
            } else {
                --this.cacheSize;
                DBPreparedStatement nextCached = preparedStatement.getNextCached();
                if (nextCached != null) {
                    this.cache.put(sql, nextCached);
                    preparedStatement.setNextCached(null);
                }
            }
            if (VALIDATE_CHECKOUTS) {
                this.checkOuts.add((Object)preparedStatement);
            }
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, IDBPreparedStatement.ReuseProbability.LOW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePreparedStatement(DBPreparedStatement preparedStatement) {
        try {
            if (preparedStatement == null) {
                return;
            }
            DBConnection dBConnection = this;
            synchronized (dBConnection) {
                if (VALIDATE_CHECKOUTS) {
                    this.checkOuts.remove((Object)preparedStatement);
                }
                preparedStatement.setTouch(++this.lastTouch);
                String sql = preparedStatement.getSQL();
                DBPreparedStatement cached = this.cache.put(sql, preparedStatement);
                if (cached != null) {
                    preparedStatement.setNextCached(cached);
                }
                if (++this.cacheSize > this.database.getStatementCacheCapacity()) {
                    String firstKey = this.cache.firstKey();
                    DBPreparedStatement old = this.cache.remove(firstKey);
                    DBPreparedStatement nextCached = old.getNextCached();
                    DBUtil.close(old.getDelegate());
                    --this.cacheSize;
                    if (nextCached != null) {
                        this.cache.put(firstKey, nextCached);
                    }
                }
            }
        }
        finally {
            this.database.endSchemaAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateStatementCache() {
        DBConnection dBConnection = this;
        synchronized (dBConnection) {
            if (VALIDATE_CHECKOUTS) {
                CheckUtil.checkState((boolean)this.checkOuts.isEmpty(), (String)("Statements are checked out: " + this.checkOuts));
            }
            for (DBPreparedStatement preparedStatement : this.cache.values()) {
                while (preparedStatement != null) {
                    PreparedStatement delegate = preparedStatement.getDelegate();
                    DBUtil.close(delegate);
                    preparedStatement = preparedStatement.getNextCached();
                }
            }
            this.cache.clear();
            this.cacheSize = 0;
        }
    }

    public String convertString(DBPreparedStatement preparedStatement, int parameterIndex, String value) {
        return this.getDatabase().convertString(preparedStatement, parameterIndex, value);
    }

    public String convertString(DBResultSet resultSet, int columnIndex, String value) {
        return this.getDatabase().convertString(resultSet, columnIndex, value);
    }

    public String convertString(DBResultSet resultSet, String columnLabel, String value) {
        return this.getDatabase().convertString(resultSet, columnLabel, value);
    }
}

