/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime;

import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.nebula.cwt.base.BaseCombo;
import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VCanvas;
import org.eclipse.nebula.cwt.v.VGridLayout;
import org.eclipse.nebula.cwt.v.VLabel;
import org.eclipse.nebula.cwt.v.VLayout;
import org.eclipse.nebula.cwt.v.VNative;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.cwt.v.VTracker;
import org.eclipse.nebula.widgets.cdatetime.AnalogTimePicker;
import org.eclipse.nebula.widgets.cdatetime.CDT;
import org.eclipse.nebula.widgets.cdatetime.CDateTimeBuilder;
import org.eclipse.nebula.widgets.cdatetime.CDateTimePainter;
import org.eclipse.nebula.widgets.cdatetime.DatePicker;
import org.eclipse.nebula.widgets.cdatetime.DiscreteTimePicker;
import org.eclipse.nebula.widgets.cdatetime.Resources;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class CDateTime
extends BaseCombo {
    private static final int FIELD_NONE = -1;
    private static final int DISCARD = 0;
    private static final int WRAP = 1;
    private static final int BLOCK = 2;
    VPanel picker;
    VNative<Spinner> spinner;
    boolean internalFocusShift = false;
    boolean rightClick = false;
    private Date cancelDate;
    private Calendar calendar;
    private DateFormat df;
    Locale locale;
    TimeZone timezone;
    DateFormat.Field[] field;
    int activeField;
    private boolean tabStops = false;
    int style;
    String pattern = null;
    int format = -1;
    private CDateTimePainter painter;
    Listener textListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 15: {
                    CDateTime.this.rightClick = false;
                    if (CDateTime.this.internalFocusShift) {
                        if (CDateTime.this.activeField >= 0) break;
                        CDateTime.this.fieldFirst();
                        CDateTime.this.updateText();
                        break;
                    }
                    if (VTracker.getLastTraverse() == 8) {
                        CDateTime.this.fieldLast();
                    } else {
                        CDateTime.this.fieldFirst();
                    }
                    CDateTime.this.updateText();
                    break;
                }
                case 16: {
                    if (CDateTime.this.rightClick || CDateTime.this.internalFocusShift) break;
                    CDateTime.this.commitEditField();
                    CDateTime.this.updateText();
                    break;
                }
                case 1: {
                    CDateTime.this.handleKey(event);
                    break;
                }
                case 3: {
                    if (event.button == 1) {
                        CDateTime.this.fieldFromTextSelection();
                        break;
                    }
                    if (event.button == 2) {
                        CDateTime.this.fieldNext();
                        break;
                    }
                    if (event.button != 3) break;
                    CDateTime.this.rightClick = true;
                    break;
                }
                case 37: {
                    if (event.count > 0) {
                        CDateTime.this.fieldAdjust(1);
                    } else {
                        CDateTime.this.fieldAdjust(-1);
                    }
                    event.doit = false;
                    break;
                }
                case 4: {
                    if (event.button != 1) break;
                    CDateTime.this.fieldFromTextSelection();
                    break;
                }
                case 31: {
                    CDateTime.this.handleTraverse(event);
                    break;
                }
                case 25: {
                    CDateTime.this.verify(event);
                }
            }
        }
    };
    private Point textSelectionOffset = new Point(0, 0);
    private EditField editField;
    private String[] separator;
    private int[] calendarFields;
    private boolean isTime;
    private boolean isDate;
    private String nullText = null;
    private boolean defaultNullText = true;
    private boolean singleSelection;
    private Date[] selection = new Date[0];
    private boolean scrollable = true;
    CDateTimeBuilder builder;
    VPanel pickerPanel;
    private TimeZone[] allowedTimezones;

    private static int convertStyle(int style) {
        int rstyle = 0;
        if ((style & 2) != 0) {
            rstyle |= 4;
        }
        if ((style & 4) != 0) {
            rstyle |= 0x40;
        }
        if ((style & 0x2000) != 0) {
            rstyle |= 8;
        }
        if ((style & 0x80) != 0) {
            rstyle |= 0x4000;
        }
        if ((style & 0x200) != 0) {
            rstyle |= 0x4000;
        }
        if ((style & 1) != 0) {
            rstyle |= 0x800;
        }
        if (win32) {
            rstyle |= 0x20000000;
        }
        return rstyle;
    }

    public CDateTime(Composite parent, int style) {
        super(parent, CDateTime.convertStyle(style));
        this.init(style);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener != null) {
            TypedListener typedListener = new TypedListener((SWTEventListener)listener);
            this.addListener(13, (Listener)typedListener);
            this.addListener(14, (Listener)typedListener);
        }
    }

    protected void addTextListener() {
        this.removeTextListener();
        Text control = (Text)this.text.getControl();
        control.addListener(15, this.textListener);
        control.addListener(16, this.textListener);
        control.addListener(1, this.textListener);
        control.addListener(3, this.textListener);
        control.addListener(37, this.textListener);
        control.addListener(4, this.textListener);
        control.addListener(25, this.textListener);
        this.text.addListener(31, this.textListener);
    }

    private boolean commitEditField() {
        if (this.editField != null) {
            int cf = this.getCalendarField();
            int val = this.editField.getValue();
            this.editField.reset();
            if (cf == 2) {
                --val;
            }
            return this.fieldSet(cf, val, 0);
        }
        return true;
    }

    private void createPicker() {
        if (this.isSimple()) {
            this.pickerPanel = this.panel;
            this.setContent((Control)this.panel.getComposite());
        } else if (this.isDropDown()) {
            this.disposePicker();
            Shell shell = this.getContentShell();
            int style = (this.isSimple() ? 0 : 2048) | 0x20000000;
            VCanvas canvas = new VCanvas((Composite)shell, style);
            this.pickerPanel = canvas.getPanel();
            this.pickerPanel.setWidget((Composite)canvas);
            VGridLayout layout = new VGridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 1;
            this.pickerPanel.setLayout((VLayout)layout);
            this.setContent((Control)this.pickerPanel.getComposite());
            canvas.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    if (27 == event.keyCode) {
                        event.doit = false;
                        if (CDateTime.this.selection.length > 0 && CDateTime.this.selection[0] != CDateTime.this.cancelDate) {
                            CDateTime.this.setSelection(CDateTime.this.cancelDate);
                            CDateTime.this.fireSelectionChanged();
                        }
                        CDateTime.this.setOpen(false);
                    }
                }
            });
            if (this.field.length > 1 || this.isTime) {
                this.createPickerToolbar(this.pickerPanel);
            }
        }
        if (this.isDate) {
            DatePicker dp = new DatePicker(this);
            dp.setScrollable(this.scrollable);
            dp.setFields(this.calendarFields);
            dp.updateView();
            this.picker = dp;
        } else if (this.isTime) {
            if ((this.style & 0x8000000) != 0) {
                DiscreteTimePicker dtp = new DiscreteTimePicker(this);
                dtp.setFields(this.calendarFields);
                dtp.updateView();
                this.picker = dtp;
            } else {
                AnalogTimePicker atp = new AnalogTimePicker(this);
                atp.setFields(this.calendarFields);
                atp.updateView();
                this.picker = atp;
            }
        }
        if (this.isDropDown()) {
            this.picker.setLayoutData(new GridData(4, 4, false, false));
        }
    }

    private void createPickerToolbar(VPanel parent) {
        VPanel tb = new VPanel(parent, 0);
        VGridLayout layout = new VGridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        tb.setLayout((VLayout)layout);
        tb.setLayoutData(new GridData(131072, 128, false, false));
        tb.setData("PickerPart", (Object)CDT.PickerPart.Toolbar);
        VButton b = new VButton(tb, 524320);
        b.setData("PickerPart", (Object)CDT.PickerPart.OkButton);
        b.setToolTipText(Resources.getString("accept.text", this.locale));
        b.setLayoutData(new GridData(4, 4, false, false));
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CDateTime.this.setOpen(false);
            }
        });
        b = new VButton(tb, 524544);
        b.setData("PickerPart", (Object)CDT.PickerPart.CancelButton);
        b.setToolTipText(Resources.getString("cancel.text", this.locale));
        b.setLayoutData(new GridData(4, 4, false, false));
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CDateTime.this.setSelection(CDateTime.this.cancelDate);
                CDateTime.this.fireSelectionChanged();
                CDateTime.this.setOpen(false);
            }
        });
        b = new VButton(tb, 524288);
        b.setData("PickerPart", (Object)CDT.PickerPart.ClearButton);
        b.setText(Resources.getString("clear.text", this.locale));
        b.setToolTipText(Resources.getString("clear.text", this.locale));
        b.setLayoutData(new GridData(4, 4, false, false));
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CDateTime.this.setOpen(false);
                CDateTime.this.setSelection(null);
                CDateTime.this.fireSelectionChanged();
            }
        });
        VLabel sep = new VLabel(parent, 258);
        sep.setLayoutData(new GridData(4, 4, false, false));
    }

    private void disposePicker() {
        if (this.content != null) {
            if (this.picker != null) {
                this.picker.dispose();
                this.picker = null;
            }
            if (this.isDropDown()) {
                Control c = this.content;
                this.setContent(null);
                c.dispose();
                if (this.contentShell != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (CDateTime.this.contentShell != null && !CDateTime.this.contentShell.isDisposed()) {
                                CDateTime.this.contentShell.dispose();
                                CDateTime.this.contentShell = null;
                            }
                        }
                    });
                }
            }
        }
    }

    void fieldAdjust(int amount) {
        if (!this.hasSelection()) {
            this.setSelection(this.calendar.getTime());
            this.fireSelectionChanged();
        } else {
            int cf = this.getCalendarField();
            if (cf >= 0) {
                this.fieldRoll(cf, amount, 1);
            }
        }
    }

    void fieldFirst() {
        if (this.allowedTimezones == null) {
            if (15 == this.getCalendarField(this.field[0])) {
                this.setActiveField(1);
            } else {
                this.setActiveField(0);
            }
        } else {
            this.setActiveField(0);
        }
    }

    void fieldFromTextSelection() {
        if (!this.hasSelection()) {
            this.fieldNext();
        } else {
            Point sel = ((Text)this.text.getControl()).getSelection();
            AttributedCharacterIterator aci = this.df.formatToCharacterIterator(this.calendar.getTime());
            if (sel.x > this.textSelectionOffset.x) {
                sel.x += this.textSelectionOffset.y;
            }
            aci.setIndex(sel.x);
            Object[] oa = aci.getAttributes().keySet().toArray();
            if (oa.length == 0 && sel.x > 0) {
                --sel.x;
                aci.setIndex(sel.x);
                oa = aci.getAttributes().keySet().toArray();
            }
            if (oa.length > 0) {
                int i = 0;
                while (i < this.field.length) {
                    if (oa[0].equals(this.field[i])) {
                        if (this.allowedTimezones == null) {
                            if (15 == this.getCalendarField(this.field[i])) break;
                            this.setActiveField(i);
                            break;
                        }
                        this.setActiveField(i);
                        break;
                    }
                    ++i;
                }
                this.updateText();
            }
        }
    }

    void fieldLast() {
        if (this.allowedTimezones == null) {
            if (15 == this.getCalendarField(this.field[this.field.length - 1])) {
                this.setActiveField(this.field.length - 2);
            } else {
                this.setActiveField(this.field.length - 1);
            }
        } else {
            this.setActiveField(this.field.length - 1);
        }
    }

    void fieldNext() {
        this.fieldNext(false);
    }

    void fieldNext(boolean async) {
        if (this.activeField >= 0 && this.activeField < this.field.length - 1) {
            if (this.allowedTimezones == null) {
                if (15 == this.getCalendarField(this.field[this.activeField + 1])) {
                    if (this.activeField < this.field.length - 2) {
                        this.setActiveField(this.activeField + 2);
                    } else {
                        this.setActiveField(0);
                    }
                } else {
                    this.setActiveField(this.activeField + 1);
                }
            } else {
                this.setActiveField(this.activeField + 1);
            }
        } else if (this.allowedTimezones == null) {
            if (15 == this.getCalendarField(this.field[0])) {
                this.setActiveField(1);
            } else {
                this.setActiveField(0);
            }
        } else {
            this.setActiveField(0);
        }
        this.updateText(async);
    }

    private void fieldPrev() {
        this.fieldPrev(false);
    }

    void fieldPrev(boolean async) {
        if (this.activeField > 0 && this.activeField < this.field.length) {
            if (this.allowedTimezones == null) {
                if (15 == this.getCalendarField(this.field[this.activeField - 1])) {
                    if (this.activeField > 1) {
                        this.setActiveField(this.activeField - 2);
                    } else {
                        this.setActiveField(this.field.length - 1);
                    }
                } else {
                    this.setActiveField(this.activeField - 1);
                }
            } else {
                this.setActiveField(this.activeField - 1);
            }
        } else if (this.allowedTimezones == null) {
            if (15 == this.getCalendarField(this.field[this.field.length - 1])) {
                this.setActiveField(this.field.length - 2);
            } else {
                this.setActiveField(this.field.length - 1);
            }
        } else {
            this.setActiveField(this.field.length - 1);
        }
        this.updateText(async);
    }

    private boolean fieldRoll(int calendarField, int rollAmount, int style) {
        if (!this.getEditable()) {
            return false;
        }
        if (calendarField == 15 && this.allowedTimezones != null) {
            boolean timeZoneSet = false;
            int idx = 0;
            while (idx < this.allowedTimezones.length) {
                TimeZone activeTimeZone = this.getTimeZone();
                if (activeTimeZone.getID() == this.allowedTimezones[idx].getID()) {
                    if (rollAmount < 0) {
                        if (idx == 0) {
                            this.setTimeZone(this.allowedTimezones[this.allowedTimezones.length - 1]);
                        } else {
                            this.setTimeZone(this.allowedTimezones[idx - 1]);
                        }
                    } else if (rollAmount > 0) {
                        if (idx == this.allowedTimezones.length - 1) {
                            this.setTimeZone(this.allowedTimezones[0]);
                        } else {
                            this.setTimeZone(this.allowedTimezones[idx + 1]);
                        }
                    }
                    timeZoneSet = true;
                    break;
                }
                ++idx;
            }
            if (!timeZoneSet) {
                this.setTimeZone(this.allowedTimezones[0]);
            }
        } else {
            this.calendar.roll(calendarField, rollAmount);
        }
        if (this.selection.length > 0) {
            this.selection[0] = this.calendar.getTime();
        }
        this.updateText();
        this.updatePicker();
        this.fireSelectionChanged(calendarField);
        return true;
    }

    private boolean fieldSet(int calendarField, int value, int style) {
        if (!this.getEditable()) {
            return false;
        }
        if (calendarField >= 0) {
            if (value > this.calendar.getActualMaximum(calendarField)) {
                if (style == 0) {
                    return false;
                }
                if (style == 1) {
                    value = this.calendar.getActualMinimum(calendarField);
                } else if (style == 2) {
                    value = this.calendar.getActualMaximum(calendarField);
                }
            } else if (value < this.calendar.getActualMinimum(calendarField)) {
                if (style == 0) {
                    return false;
                }
                if (style == 1) {
                    value = this.calendar.getActualMaximum(calendarField);
                } else if (style == 2) {
                    value = this.calendar.getActualMinimum(calendarField);
                }
            }
            this.calendar.set(calendarField, value);
            if (this.selection.length > 0) {
                this.selection[0] = this.calendar.getTime();
            }
            this.updateText();
            this.updatePicker();
            this.fireSelectionChanged(calendarField);
        }
        return true;
    }

    void fireSelectionChanged() {
        this.fireSelectionChanged(false);
    }

    void fireSelectionChanged(boolean defaultSelection) {
        if (defaultSelection && this.isOpen()) {
            this.setOpen(false);
        }
        Event event = new Event();
        event.data = this.getSelection();
        this.notifyListeners(13, event);
        if (defaultSelection) {
            this.notifyListeners(14, event);
        }
    }

    void fireSelectionChanged(int field) {
        Event event = new Event();
        event.data = this.getSelection();
        event.detail = field;
        if (this.field.length == 1) {
            if (this.isOpen()) {
                this.setOpen(false);
            }
            this.notifyListeners(13, event);
            this.notifyListeners(14, event);
        } else {
            this.notifyListeners(13, event);
        }
    }

    VButton getButtonWidget() {
        return this.button;
    }

    int getCalendarField() {
        return this.hasField(this.activeField) ? this.getCalendarField(this.field[this.activeField]) : -1;
    }

    int getCalendarField(DateFormat.Field field) {
        int cf = field.getCalendarField();
        if (cf < 0) {
            if (field.toString().indexOf("hour 1") > -1) {
                cf = 10;
            } else if (field.toString().contains("zone")) {
                cf = 15;
            }
        }
        return cf;
    }

    Calendar getCalendarInstance() {
        return this.getCalendarInstance(this.calendar.getTimeInMillis());
    }

    public Calendar getCalendarInstance(Date date) {
        if (date == null) {
            return this.getCalendarInstance(System.currentTimeMillis());
        }
        return this.getCalendarInstance(date.getTime());
    }

    public Calendar getCalendarInstance(long date) {
        Calendar cal = Calendar.getInstance(this.timezone, this.locale);
        cal.setTimeInMillis(date);
        return cal;
    }

    Date getCalendarTime() {
        return this.calendar.getTime();
    }

    long getCalendarTimeInMillis() {
        return this.calendar.getTimeInMillis();
    }

    public boolean getEditable() {
        return !this.panel.hasStyle(8);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getNullText() {
        if (this.nullText == null) {
            if (this.isDate) {
                return Resources.getString("null_text.date", this.locale);
            }
            return Resources.getString("null_text.time", this.locale);
        }
        return this.nullText;
    }

    CDateTimePainter getPainter() {
        if (this.painter == null) {
            this.setPainter(new CDateTimePainter());
        }
        return this.painter;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Date getSelection() {
        return this.hasSelection() ? this.selection[0] : null;
    }

    public int getStyle() {
        return this.style;
    }

    public String getText() {
        return this.checkText() ? this.text.getText() : null;
    }

    VNative<Text> getTextWidget() {
        return this.text;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    void handleKey(Event event) {
        if (event.stateMask != 0) {
            return;
        }
        if (13 == event.keyCode || 0x1000050 == event.keyCode) {
            this.fireSelectionChanged(true);
        } else if (8 == event.keyCode || 127 == event.keyCode) {
            event.doit = false;
            this.setSelection(null);
            this.fireSelectionChanged();
        } else if (!this.hasField(this.activeField) && !this.hasSelection()) {
            event.doit = false;
        } else {
            switch (event.keyCode) {
                case 45: 
                case 16777261: {
                    this.fieldAdjust(-1);
                    break;
                }
                case 43: 
                case 61: 
                case 16777259: {
                    this.fieldAdjust(1);
                    break;
                }
                case 8: {
                    if (this.editField == null) break;
                    this.editField.removeLastCharacter();
                    break;
                }
                case 0x1000002: {
                    this.fieldAdjust(-1);
                    this.updateText(true);
                    break;
                }
                case 0x1000001: {
                    this.fieldAdjust(1);
                    this.updateText(true);
                    break;
                }
                case 0x1000003: {
                    this.fieldPrev(true);
                    break;
                }
                case 0x1000004: {
                    this.fieldNext(true);
                    break;
                }
                default: {
                    if (this.hasField(this.activeField) && this.activeField + 1 < this.separator.length && String.valueOf(event.character).equals(this.separator[this.activeField + 1])) {
                        this.fieldNext();
                        break;
                    }
                    if (this.hasSelection() || !String.valueOf(event.character).matches("[0-9]")) break;
                    this.fieldAdjust(0);
                    this.fieldFirst();
                }
            }
        }
    }

    void handleTraverse(Event event) {
        boolean allowTimeZoneEdit = this.allowedTimezones != null;
        switch (event.detail) {
            case 64: {
                if (event.keyCode == 0x1000004) {
                    this.fieldNext();
                    break;
                }
                if (event.keyCode != 0x1000002) break;
                this.fieldAdjust(-1);
                break;
            }
            case 32: {
                if (event.keyCode == 0x1000003) {
                    this.fieldPrev();
                    break;
                }
                if (event.keyCode != 0x1000001) break;
                this.fieldAdjust(1);
                break;
            }
            case 13: {
                this.fieldNext();
                this.fireSelectionChanged();
                break;
            }
            case 16: {
                if (!this.tabStops || !this.hasSelection()) break;
                if (this.activeField == this.field.length - 1 || this.activeField == this.field.length - 2 && 15 == this.getCalendarField(this.field[this.field.length - 1]) && !allowTimeZoneEdit) {
                    event.doit = true;
                    break;
                }
                event.doit = false;
                if (this.activeField < 0) {
                    this.fieldPrev();
                    break;
                }
                this.fieldNext();
                break;
            }
            case 8: {
                if (!this.tabStops || !this.hasSelection()) break;
                if (this.activeField == 0 || this.activeField == 1 && 15 == this.getCalendarField(this.field[0]) && !allowTimeZoneEdit) {
                    event.doit = true;
                    break;
                }
                event.doit = false;
                if (this.activeField < 0) {
                    this.fieldNext();
                    break;
                }
                this.fieldPrev();
            }
        }
    }

    private boolean hasField(int field) {
        return field >= 0 && field <= this.field.length;
    }

    public boolean hasSelection() {
        return this.selection.length > 0;
    }

    private void init(int style) {
        this.style = style;
        this.locale = Locale.getDefault();
        try {
            this.timezone = TimeZone.getDefault();
        }
        catch (Exception exception) {
            this.timezone = TimeZone.getTimeZone("GMT");
        }
        this.calendar = Calendar.getInstance(this.timezone, this.locale);
        this.calendar.setTime(new Date());
        this.tabStops = (style & 0x2000000) != 0;
        this.singleSelection = (style & 4) == 0 || (style & 0x40000000) == 0;
        this.setFormat(style);
        if (!this.isSimple()) {
            if (this.isDropDown()) {
                if ((style & 0x40000) != 0) {
                    this.setButtonVisibility(3);
                } else {
                    this.setButtonVisibility(1);
                }
            } else {
                this.setButtonVisibility(2);
                if ((style & 0x4000000) != 0) {
                    int sStyle = 512;
                    if (gtk && (style & 1) != 0) {
                        sStyle |= 0x800;
                    }
                    this.spinner = VNative.create(Spinner.class, (VPanel)this.panel, (int)sStyle);
                    if (win32) {
                        this.spinner.setBackground(((Text)this.text.getControl()).getBackground());
                    }
                    ((Spinner)this.spinner.getControl()).setMinimum(0);
                    ((Spinner)this.spinner.getControl()).setMaximum(50);
                    ((Spinner)this.spinner.getControl()).setDigits(1);
                    ((Spinner)this.spinner.getControl()).setIncrement(1);
                    ((Spinner)this.spinner.getControl()).setPageIncrement(1);
                    ((Spinner)this.spinner.getControl()).setSelection(25);
                    ((Spinner)this.spinner.getControl()).addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            CDateTime.this.internalFocusShift = true;
                            CDateTime.this.setFocus();
                            CDateTime.this.internalFocusShift = false;
                        }
                    });
                    ((Spinner)this.spinner.getControl()).addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent e) {
                            if (e.button == 2) {
                                CDateTime.this.fieldNext();
                            }
                        }
                    });
                    ((Spinner)this.spinner.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (VTracker.getMouseDownButton() != 2) {
                                if (((Spinner)CDateTime.this.spinner.getControl()).getSelection() > 25) {
                                    CDateTime.this.fieldAdjust(1);
                                } else {
                                    CDateTime.this.fieldAdjust(-1);
                                }
                                ((Spinner)CDateTime.this.spinner.getControl()).setSelection(25);
                            }
                        }
                    });
                    this.panel.setLayout((VLayout)new SpinnerLayout());
                }
            }
            this.updateText();
            this.activeField = -5;
            this.setActiveField(-1);
            if (this.checkText()) {
                this.addTextListener();
            }
        }
    }

    boolean isSelected(Date date) {
        Date[] dateArray = this.selection;
        int n = this.selection.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            if (d.equals(date)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isSingleSelection() {
        return this.singleSelection;
    }

    boolean isClosingField(int calendarField) {
        int i = Integer.MIN_VALUE;
        DateFormat.Field[] fieldArray = this.field;
        int n = this.field.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat.Field f = fieldArray[n2];
            i = Math.max(i, f.getCalendarField());
            ++n2;
        }
        return i == calendarField;
    }

    protected void postClose(Shell popup) {
        this.disposePicker();
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener != null) {
            TypedListener l = new TypedListener((SWTEventListener)listener);
            this.removeListener(13, (Listener)l);
            this.removeListener(14, (Listener)l);
        }
    }

    protected void removeTextListener() {
        Text control = (Text)this.text.getControl();
        control.removeListener(1, this.textListener);
        control.removeListener(3, this.textListener);
        control.removeListener(37, this.textListener);
        control.removeListener(4, this.textListener);
        control.removeListener(25, this.textListener);
        this.text.removeListener(31, this.textListener);
    }

    private void setActiveField(int field) {
        if (this.activeField != field) {
            this.commitEditField();
            this.editField = null;
            this.activeField = field;
        }
    }

    public void setBuilder(CDateTimeBuilder builder) {
        this.builder = builder;
        if (this.picker != null) {
            this.disposePicker();
            this.createPicker();
        }
    }

    public void setButtonImage(Image image) {
        super.setButtonImage(image);
    }

    protected boolean setContentFocus() {
        if (this.checkPicker()) {
            this.internalFocusShift = true;
            boolean result = this.picker.setFocus();
            this.internalFocusShift = false;
            return result;
        }
        return false;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.checkPicker()) {
            if (this.picker instanceof DatePicker) {
                ((DatePicker)this.picker).setEditable(editable);
            } else {
                this.picker.setActivatable(editable);
            }
        }
    }

    private boolean checkPicker() {
        return this.picker != null && !this.picker.isDisposed();
    }

    public void setFormat(int format) throws IllegalArgumentException {
        int dateStyle;
        int n = (format & 0x100000) != 0 ? 3 : ((format & 0x200000) != 0 ? 2 : (dateStyle = (format & 0x400000) != 0 ? 1 : -1));
        int timeStyle = (format & 0x800000) != 0 ? 3 : ((format & 0x1000000) != 0 ? 2 : -1);
        String str = null;
        if (dateStyle != -1 && timeStyle != -1) {
            str = ((SimpleDateFormat)DateFormat.getDateTimeInstance(dateStyle, timeStyle, this.locale)).toPattern();
        } else if (dateStyle != -1) {
            str = ((SimpleDateFormat)DateFormat.getDateInstance(dateStyle, this.locale)).toPattern();
        } else if (timeStyle != -1) {
            str = ((SimpleDateFormat)DateFormat.getTimeInstance(timeStyle, this.locale)).toPattern();
        } else if (this.pattern == null) {
            format = 0x100000;
            str = ((SimpleDateFormat)DateFormat.getDateInstance(3, this.locale)).toPattern();
        }
        if (str != null) {
            this.format = format;
            this.setPattern(str);
        }
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!this.locale.equals(locale)) {
            this.locale = locale;
            if (this.format > 0) {
                this.setFormat(this.format);
            } else {
                this.setPattern(this.pattern);
            }
            this.updateNullText();
        }
    }

    protected void setModifyEventProperties(Event e) {
        e.data = this.calendar.getTime();
    }

    public void setNullText(String text) {
        this.defaultNullText = false;
        this.nullText = text;
        this.updateText();
    }

    public void setOpen(boolean open) {
        this.setOpen(open, null);
    }

    public void setOpen(boolean open, Runnable callback) {
        if (open) {
            this.cancelDate = this.getSelection();
            this.createPicker();
        } else {
            this.cancelDate = null;
        }
        super.setOpen(open, callback);
        if (this.hasSelection()) {
            this.show(this.getSelection());
        }
    }

    public void setPainter(CDateTimePainter painter) {
        if (painter != null) {
            painter.setCDateTime(this);
        }
        this.painter = painter;
    }

    public void setPattern(String pattern) throws IllegalArgumentException {
        this.allowedTimezones = null;
        if (this.isOpen()) {
            this.setOpen(false);
        }
        this.df = new SimpleDateFormat(pattern, this.locale);
        this.df.setTimeZone(this.timezone);
        if (this.updateFields()) {
            this.pattern = pattern;
            this.format = -1;
            boolean wasDate = this.isDate;
            boolean wasTime = this.isTime;
            this.isTime = false;
            this.isDate = false;
            this.calendarFields = new int[this.field.length];
            int i = 0;
            while (i < this.calendarFields.length) {
                this.calendarFields[i] = this.getCalendarField(this.field[i]);
                switch (this.calendarFields[i]) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.isTime = true;
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.isDate = true;
                        break;
                    }
                }
                ++i;
            }
            if (this.checkButton() && (this.isDate != wasDate || this.isTime != wasTime)) {
                if (this.defaultButtonImage) {
                    if (this.isDate && this.isTime) {
                        this.doSetButtonImage(Resources.getIconCalendarClock());
                    } else if (this.isDate) {
                        this.doSetButtonImage(Resources.getIconCalendar());
                    } else {
                        this.doSetButtonImage(Resources.getIconClock());
                    }
                }
                this.updateNullText();
            }
            if (this.checkText()) {
                this.updateText();
            }
            if (this.isSimple()) {
                this.disposePicker();
                this.createPicker();
            }
        } else {
            throw new IllegalArgumentException("Problem setting pattern: \"" + pattern + "\"");
        }
    }

    void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
        if (this.isSimple() && !scrollable && this.picker != null && this.picker instanceof DatePicker) {
            this.updatePicker();
        }
    }

    public void setSelection(Date selection) {
        if (this.getEditable()) {
            this.selection = selection == null ? new Date[0] : new Date[]{selection};
        }
        if (this.singleSelection && this.selection.length > 0) {
            this.show(selection);
        } else {
            this.updateText();
            this.updatePicker();
        }
    }

    public void setTimeZone(String zoneID) {
        if (zoneID == null) {
            this.setTimeZone((TimeZone)null);
        } else {
            this.setTimeZone(TimeZone.getTimeZone(zoneID));
        }
    }

    public void setTimeZone(TimeZone zone) {
        if (zone == null) {
            this.timezone = TimeZone.getDefault();
        }
        if (!this.timezone.equals(zone)) {
            this.timezone = zone;
            this.calendar.setTimeZone(this.timezone);
            this.df.setTimeZone(this.timezone);
            this.updateText();
        }
    }

    public void show(Date date) {
        if (date == null) {
            this.calendar.setTime(new Date());
        } else {
            this.calendar.setTime(date);
        }
        this.updateText();
        this.updatePicker();
    }

    public void showSelection() {
        if (this.selection.length > 0) {
            this.show(this.selection[0]);
        }
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " {" + this.getCalendarTime() + "}";
    }

    private boolean updateFields() {
        DateFormat.Field[] bak = new DateFormat.Field[this.field == null ? 0 : this.field.length];
        if (bak.length > 0) {
            System.arraycopy(this.field, 0, bak, 0, this.field.length);
        }
        AttributedCharacterIterator aci = this.df.formatToCharacterIterator(this.calendar.getTime());
        this.field = new DateFormat.Field[aci.getAllAttributeKeys().size()];
        this.separator = new String[this.field.length + 1];
        int i = 0;
        Object last = null;
        char c = aci.first();
        while (c != '\uffff') {
            Object[] oa = aci.getAttributes().keySet().toArray();
            if (oa.length > 0) {
                if (oa[0] != last && i < this.field.length) {
                    if (this.getCalendarField((DateFormat.Field)oa[0]) < 0) {
                        if (bak.length > 0) {
                            this.field = new DateFormat.Field[bak.length];
                            System.arraycopy(bak, 0, this.field, 0, bak.length);
                        }
                        return false;
                    }
                    this.field[i] = (DateFormat.Field)oa[0];
                    last = oa[0];
                    ++i;
                }
            } else if (this.separator[i] == null) {
                this.separator[i] = String.valueOf(c);
            }
            c = aci.next();
        }
        this.df.setLenient(false);
        this.setActiveField(-1);
        return true;
    }

    private void updateNullText() {
        if (this.defaultNullText) {
            this.nullText = this.isDate ? Resources.getString("null_text.date", this.locale) : Resources.getString("null_text.time", this.locale);
            if (!this.hasSelection()) {
                this.updateText();
            }
        }
    }

    private void updatePicker() {
        if (this.picker != null) {
            if (this.picker instanceof DatePicker) {
                ((DatePicker)this.picker).updateView();
            } else if (this.picker instanceof AnalogTimePicker) {
                ((AnalogTimePicker)this.picker).updateView();
            } else if (this.picker instanceof DiscreteTimePicker) {
                ((DiscreteTimePicker)this.picker).updateView();
            }
        }
    }

    private void updateText() {
        this.updateText(false);
    }

    private void updateText(boolean async) {
        String buffer = this.hasSelection() ? this.df.format(this.getSelection()) : this.getNullText();
        int s0 = 0;
        int s1 = 0;
        if (!this.hasSelection()) {
            s0 = 0;
            s1 = buffer.length();
        } else if (this.activeField >= 0 && this.activeField < this.field.length) {
            AttributedCharacterIterator aci = this.df.formatToCharacterIterator(this.getSelection());
            char c = aci.first();
            while (c != '\uffff') {
                if (aci.getAttribute(this.field[this.activeField]) != null) {
                    s0 = aci.getRunStart();
                    s1 = aci.getRunLimit();
                    if (this.editField != null) {
                        String str = this.editField.toString();
                        buffer = String.valueOf(buffer.substring(0, s0)) + str + buffer.substring(s1);
                        int oldS1 = s1;
                        s1 = s0 + str.length();
                        this.textSelectionOffset.x = Math.min(oldS1, s1);
                        this.textSelectionOffset.y = oldS1 - s0 - str.length();
                    } else {
                        this.textSelectionOffset.x = buffer.length() + 1;
                        this.textSelectionOffset.y = 0;
                    }
                    break;
                }
                c = aci.next();
            }
        } else {
            this.setActiveField(-1);
        }
        final String string = buffer;
        final int selStart = s0;
        final int selEnd = s1;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (CDateTime.this.text != null && !CDateTime.this.text.isDisposed()) {
                    if (!string.equals(CDateTime.this.text.getText())) {
                        ((Text)CDateTime.this.text.getControl()).removeListener(25, CDateTime.this.textListener);
                        CDateTime.this.text.setText(string);
                        ((Text)CDateTime.this.text.getControl()).addListener(25, CDateTime.this.textListener);
                    }
                    ((Text)CDateTime.this.text.getControl()).setSelection(selStart, selEnd);
                }
            }
        };
        if (async) {
            this.getDisplay().asyncExec(runnable);
        } else {
            this.getDisplay().syncExec(runnable);
        }
    }

    void verify(Event e) {
        if (!e.doit) {
            return;
        }
        e.doit = false;
        if (this.field.length == 0 || this.activeField == -1) {
            return;
        }
        char c = e.character;
        if (e.text.length() == 1 && String.valueOf(c).equals(e.text) && Character.isDigit(c) || e.text.length() > 1) {
            if (e.text.length() == 1) {
                if (this.editField == null) {
                    int cf = this.getCalendarField();
                    if (cf >= 0) {
                        int digits;
                        switch (cf) {
                            case 1: {
                                digits = 4;
                                break;
                            }
                            case 6: {
                                digits = 3;
                                break;
                            }
                            case 0: 
                            case 7: 
                            case 9: {
                                digits = 1;
                                break;
                            }
                            case 14: {
                                digits = 3;
                                break;
                            }
                            default: {
                                digits = 2;
                            }
                        }
                        this.editField = new EditField(digits, this.calendar.get(cf));
                    } else {
                        return;
                    }
                }
                if (this.editField.addChar(c)) {
                    if (this.commitEditField()) {
                        this.fieldNext();
                    } else {
                        this.editField = null;
                        if (this.selection.length > 0) {
                            this.selection[0] = this.calendar.getTime();
                        }
                        this.updateText();
                    }
                }
                if (this.selection.length > 0) {
                    this.selection[0] = this.calendar.getTime();
                }
                this.updatePicker();
            } else {
                try {
                    this.setSelection(this.df.parse(e.text));
                    this.fireSelectionChanged();
                }
                catch (ParseException parseException) {}
            }
        }
        this.updateText();
    }

    public void setPattern(String pattern, TimeZone[] allowedTimeZones) throws IllegalArgumentException {
        this.setPattern(pattern);
        if (pattern.indexOf(122) != -1) {
            this.allowedTimezones = allowedTimeZones;
        }
    }

    private class EditField {
        private String buffer;
        private int digits;
        private int count = 0;

        EditField(int digits, int initialValue) {
            this.digits = digits;
            this.buffer = Integer.toString(initialValue);
        }

        boolean addChar(char c) {
            if (Character.isDigit(c)) {
                this.buffer = this.count > 0 ? this.buffer : "";
                this.buffer = String.valueOf(this.buffer) + String.valueOf(c);
                if (this.buffer.length() > this.digits) {
                    this.buffer = this.buffer.substring(this.buffer.length() - this.digits, this.buffer.length());
                }
            }
            return ++this.count > this.digits - 1;
        }

        int getValue() {
            return Integer.parseInt(this.buffer);
        }

        void removeLastCharacter() {
            if (this.buffer.length() > 0) {
                this.buffer = this.buffer.substring(0, this.buffer.length() - 1);
                --this.count;
            }
        }

        void reset() {
            this.count = 0;
        }

        public String toString() {
            if (this.buffer.length() < this.digits) {
                char[] ca = new char[this.digits - this.buffer.length()];
                Arrays.fill(ca, '0');
                this.buffer = String.valueOf(ca).concat(this.buffer);
            }
            return this.buffer;
        }
    }

    class SpinnerLayout
    extends VLayout {
        SpinnerLayout() {
        }

        protected Point computeSize(VPanel panel, int wHint, int hHint, boolean flushCache) {
            Point size = CDateTime.this.text.computeSize(-1, -1);
            Rectangle sRect = ((Spinner)CDateTime.this.spinner.getControl()).computeTrim(0, 0, 0, 0);
            int sWidth = sRect.x + sRect.width - 2 * ((Spinner)CDateTime.this.spinner.getControl()).getBorderWidth() + 1;
            size.x += sWidth;
            ++size.x;
            size.y += textMarginHeight;
            if (wHint != -1) {
                size.x = Math.min(size.x, wHint);
            }
            if (hHint != -1) {
                size.y = Math.min(size.y, hHint);
            }
            return size;
        }

        protected void layout(VPanel panel, boolean flushCache) {
            Rectangle cRect = panel.getClientArea();
            if (cRect.isEmpty()) {
                return;
            }
            Point tSize = ((Text)CDateTime.this.text.getControl()).computeSize(-1, -1);
            tSize.y += textMarginHeight;
            CDateTime.this.spinner.setBounds(cRect.x, cRect.y, cRect.width, tSize.y);
            Rectangle sRect = ((Spinner)CDateTime.this.spinner.getControl()).computeTrim(0, 0, 0, 0);
            int sWidth = sRect.x + sRect.width - 2 * ((Spinner)CDateTime.this.spinner.getControl()).getBorderWidth() + 1;
            tSize.x = cRect.width - sWidth;
            CDateTime.this.text.setBounds(cRect.x, cRect.y + CDateTime.this.getBorderWidth(), tSize.x, tSize.y);
        }
    }
}

