/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.advices.values;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.types.Activator;
import org.eclipse.papyrus.infra.emf.types.advices.values.ConstantValue;
import org.eclipse.papyrus.infra.emf.types.advices.values.DynamicValue;
import org.eclipse.papyrus.infra.emf.types.advices.values.FeatureValue;
import org.eclipse.papyrus.infra.emf.types.advices.values.ListValue;
import org.eclipse.papyrus.infra.emf.types.advices.values.QueryExecutionValue;
import org.eclipse.papyrus.infra.emf.types.advices.values.util.SetValuesAdviceSwitch;
import org.eclipse.papyrus.infra.emf.types.converter.ConverterNotfoundException;
import org.eclipse.papyrus.infra.emf.types.converter.ConverterRegistry;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.ValueSpecification;

public class FeatureValueUtils {
    protected FeatureValueUtils() {
    }

    public static Object getValue(final EObject elementToConfigure, final EStructuralFeature feature, FeatureValue featureValue) {
        Object result = new SetValuesAdviceSwitch<Object>(){

            @Override
            public Object caseConstantValue(ConstantValue object) {
                ValueSpecification valueSpecification = object.getValueInstance();
                if (valueSpecification == null) {
                    return null;
                }
                try {
                    EClassifier type = feature.getEType();
                    if (type instanceof EEnum) {
                        String value = ((InstanceValue)valueSpecification).getInstance().getName();
                        return ((EEnum)type).getEEnumLiteral(value).getInstance();
                    }
                    if (type instanceof EDataType) {
                        EDataType pType = (EDataType)type;
                        String name = pType.getName();
                        if ("Boolean".equals(name)) {
                            return ConverterRegistry.getSingleton().convert(Boolean.TYPE, valueSpecification);
                        }
                        if ("Integer".equals(name)) {
                            return ConverterRegistry.getSingleton().convert(Integer.TYPE, valueSpecification);
                        }
                        if ("Real".equals(name)) {
                            return ConverterRegistry.getSingleton().convert(Double.TYPE, valueSpecification);
                        }
                        if ("String".equals(name)) {
                            return ConverterRegistry.getSingleton().convert(String.class, valueSpecification);
                        }
                        if ("UnlimitedNatural".equals(name)) {
                            return ConverterRegistry.getSingleton().convert(Integer.TYPE, valueSpecification);
                        }
                        return ConverterRegistry.getSingleton().convert(String.class, valueSpecification);
                    }
                    if (type instanceof DataType) {
                        return ConverterRegistry.getSingleton().convert(String.class, valueSpecification);
                    }
                    return ConverterRegistry.getSingleton().convert(feature.getEType().getInstanceClass(), valueSpecification);
                }
                catch (ConverterNotfoundException e) {
                    Activator.log.error("Impossible to convert " + valueSpecification + " to fit feature type :" + feature, (Throwable)e);
                    return super.caseConstantValue(object);
                }
            }

            @Override
            public Object caseQueryExecutionValue(QueryExecutionValue object) {
                throw new UnsupportedOperationException("Query execution values resolution has not been implemented yet");
            }

            @Override
            public Object caseDynamicValue(DynamicValue object) {
                throw new UnsupportedOperationException("Dynamic values resolution has not been implemented yet");
            }

            @Override
            public Object caseListValue(ListValue object) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (FeatureValue value : object.getValues()) {
                    Object singleResult = FeatureValueUtils.getValue(elementToConfigure, feature, value);
                    results.add(singleResult);
                }
                return results;
            }
        }.doSwitch(featureValue);
        return result;
    }
}

