/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.PapyrusMarkerAdapter;
import org.eclipse.papyrus.infra.services.markerlistener.providers.AbstractMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider2;
import org.eclipse.papyrus.infra.services.markerlistener.providers.MarkerCache;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceMarkerProvider
extends AbstractMarkerProvider
implements IMarkerProvider2 {
    private final MarkerCache markerCache = new MarkerCache(this.createMarkerCacheLoader());

    @Override
    public boolean canProvideMarkersFor(Resource resource) {
        return MarkerListenerUtils.getFile(resource) != null;
    }

    @Override
    public Collection<? extends IPapyrusMarker> getMarkers(Resource resource, String type, boolean includeSubtypes) throws CoreException {
        IFile file = MarkerListenerUtils.getFile(resource);
        if (file != null) {
            IMarker[] markers = file.findMarkers(type, true, 0);
            return PapyrusMarkerAdapter.wrap(resource, Arrays.asList(markers));
        }
        return Collections.emptyList();
    }

    public void createMarkers(Resource resource, Diagnostic diagnostic) {
    }

    @Override
    protected void doCreateMarker(Resource resource, Diagnostic diagnostic) throws CoreException {
        if (MarkerListenerUtils.eclipseResourcesUtil != null) {
            MarkerListenerUtils.eclipseResourcesUtil.createMarkers(resource, diagnostic);
        }
    }

    @Override
    @Deprecated
    public void deleteMarkers(Resource resource, IProgressMonitor monitor) {
        try {
            this.deleteMarkers(resource, monitor, null, true);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void deleteMarkers(Resource resource, IProgressMonitor monitor, String markerType, boolean includeSubtypes) throws CoreException {
        if (MarkerListenerUtils.eclipseResourcesUtil != null) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
            MarkerListenerUtils.eclipseResourcesUtil.deleteMarkers((Object)resource);
            sub.done();
        }
    }

    @Override
    public boolean hasMarkers(Resource context, EObject object) {
        return !this.markerCache.getMarkers(context).isEmpty();
    }

    @Override
    public ICommand getMarkerDeletionCommand(Resource context, EObject object) {
        return new MarkerDeletionCommand(context, object);
    }

    private MarkerCache.CacheLoader createMarkerCacheLoader() {
        return new MarkerCache.CacheLoader(){

            @Override
            public Collection<? extends IPapyrusMarker> getMarkers(Resource resource) throws CoreException {
                return WorkspaceMarkerProvider.this.getMarkers(resource, null, true);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MarkerData {
        final String type;
        final Map<String, ?> attributes;

        MarkerData(String type, Map<String, ?> attributes) {
            this.type = type;
            this.attributes = attributes;
        }
    }

    private class MarkerDeletionCommand
    extends AbstractCommand {
        private Resource context;
        private EObject object;
        private Collection<MarkerData> markerDataForUndo;

        public MarkerDeletionCommand(Resource context, EObject object) {
            super("Delete markers");
            this.context = context;
            this.object = object;
        }

        public void dispose() {
            this.context = null;
            this.object = null;
            this.markerDataForUndo = null;
            super.dispose();
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            Collection<IPapyrusMarker> markers = WorkspaceMarkerProvider.this.markerCache.getMarkers(this.context, this.object);
            if (markers.isEmpty()) {
                return CommandResult.newOKCommandResult();
            }
            CoreException exception = null;
            ArrayList<MarkerData> markerData = new ArrayList<MarkerData>();
            for (IPapyrusMarker marker : markers) {
                try {
                    markerData.add(new MarkerData(marker.getType(), marker.getAttributes()));
                    marker.delete();
                }
                catch (CoreException e) {
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (!markerData.isEmpty()) {
                this.markerDataForUndo = markerData;
            }
            return exception == null ? CommandResult.newOKCommandResult() : CommandResult.newErrorCommandResult(exception);
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.markerDataForUndo == null) {
                return CommandResult.newOKCommandResult();
            }
            CoreException exception = null;
            final Collection<MarkerData> markerData = this.markerDataForUndo;
            this.markerDataForUndo = null;
            Resource resource = this.object.eResource();
            if (resource != null) {
                this.context = resource;
                try {
                    final IFile file = MarkerListenerUtils.getFile(resource);
                    if (file != null) {
                        file.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                for (MarkerData data : markerData) {
                                    file.createMarker(data.type).setAttributes(data.attributes);
                                }
                                if (monitor != null) {
                                    monitor.done();
                                }
                            }
                        }, progressMonitor);
                    }
                }
                catch (CoreException e) {
                    exception = e;
                }
            }
            return exception == null ? CommandResult.newOKCommandResult() : CommandResult.newErrorCommandResult(exception);
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return this.doExecuteWithResult(progressMonitor, info);
        }
    }
}

