/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.emf.commands.CreateEAnnotationCommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AnnotationModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AnnotationModelElementFactory;
import org.eclipse.papyrus.infra.ui.emf.databinding.AnnotationObservableValue;

public class GateModelElementFactory
extends AnnotationModelElementFactory {
    private static final String GATE_SHOW_NAME = "showName";

    protected AnnotationModelElement doCreateFromSource(Object sourceElement, DataContextElement context) {
        View source = NotationHelper.findView((Object)sourceElement);
        if (source == null) {
            Activator.log.warn("Unable to resolve the selected element to an EObject");
            return null;
        }
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)source);
        return new AnnotationModelElement((EModelElement)source, domain, GATE_SHOW_NAME){

            public IObservable doGetObservable(String propertyPath) {
                return new AnnotationObservableValue(this.source, this.domain, GateModelElementFactory.GATE_SHOW_NAME, GateModelElementFactory.GATE_SHOW_NAME){

                    protected Command getCommand(final Object value) {
                        return new CreateEAnnotationCommand((TransactionalEditingDomain)this.domain, this.source, GateModelElementFactory.GATE_SHOW_NAME){

                            protected void doExecute() {
                                EAnnotation annotation = this.createEAnnotation();
                                this.replaceEannotation(annotation, this.getObject());
                                this.replaceEntry(annotation, GateModelElementFactory.GATE_SHOW_NAME, value == null ? "" : value.toString());
                            }
                        };
                    }

                    protected Object doGetValue() {
                        Object value = super.doGetValue();
                        if (value == null) {
                            return "true";
                        }
                        return value;
                    }
                };
            }
        };
    }

    public static final boolean isShowNameChanged(Notification msg) {
        if (msg == null || !(msg.getNewValue() instanceof EAnnotation)) {
            return false;
        }
        EAnnotation anno = (EAnnotation)msg.getNewValue();
        return GATE_SHOW_NAME.equals(anno.getSource());
    }

    public static final boolean isShowName(View view) {
        EAnnotation anno;
        if (view != null && (anno = view.getEAnnotation(GATE_SHOW_NAME)) != null) {
            return !"false".equalsIgnoreCase((String)anno.getDetails().get((Object)GATE_SHOW_NAME));
        }
        return true;
    }
}

