/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.DefaultCopyCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.copy.CopyStrategyManager;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.copy.ICopyStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.PasteStrategyManager;
import org.eclipse.papyrus.infra.ui.command.AbstractCommandHandler;

public class CopyHandler
extends AbstractCommandHandler {
    public static boolean isCopyEnabled(Collection<EObject> selectedElements) {
        return !CopyHandler.getElementsToPutInClipboard(selectedElements).isEmpty();
    }

    protected static List<EObject> getElementsToPutInClipboard(Collection<EObject> selectedElements) {
        ArrayList<EObject> elementsInClipboard = new ArrayList<EObject>(selectedElements);
        List allStrategies = CopyStrategyManager.getInstance().getAllStrategies();
        for (IStrategy iStrategy : allStrategies) {
            ICopyStrategy iCopyStrategy = (ICopyStrategy)iStrategy;
            iCopyStrategy.prepareElementsInClipboard(elementsInClipboard, selectedElements);
        }
        return elementsInClipboard;
    }

    public static Command buildCopyCommand(TransactionalEditingDomain editingDomain, Collection<EObject> selectedElements) {
        PapyrusClipboard papyrusClipboard = PapyrusClipboard.getNewInstance();
        DefaultCopyCommand defaultCopyCommand = new DefaultCopyCommand((EditingDomain)editingDomain, papyrusClipboard, CopyHandler.getElementsToPutInClipboard(selectedElements));
        List allStrategies = PasteStrategyManager.getInstance().getAllStrategies();
        for (IStrategy iStrategy : allStrategies) {
            IPasteStrategy iPasteStrategy = (IPasteStrategy)iStrategy;
            iPasteStrategy.prepare(papyrusClipboard, selectedElements);
        }
        return defaultCopyCommand;
    }

    protected Command getCommand(IEvaluationContext context) {
        return CopyHandler.buildCopyCommand(this.getEditingDomain(context), this.getSelectedElements());
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        return CopyHandler.isCopyEnabled(this.getSelectedElements());
    }

    public void setEnabled(Object evaluationContext) {
        PapyrusClipboard instance = PapyrusClipboard.getInstance();
        super.setEnabled(evaluationContext);
        PapyrusClipboard.setInstance((PapyrusClipboard)instance);
    }
}

