/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.ui.items;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.profile.Message;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.uml2.uml.Property;

public class CompositeItems {
    public CompositeItems(Table table, Property property, Object value) {
        if (property.getLower() > 0) {
            Message.error("Property of type Stereotype and multiplicity lower value != 0.\n The profile is ill formed !");
        }
        if (property.isMultivalued()) {
            List propValues = (List)value;
            int i = 0;
            while (i < propValues.size()) {
                this.createItem(table, property, propValues.get(i));
                ++i;
            }
        } else if (value != null) {
            this.createItem(table, property, value);
        }
    }

    private void createItem(Table table, Property property, Object object) {
        EObject eObject = null;
        if (object instanceof EObject) {
            eObject = (EObject)object;
        } else {
            String err = "Type " + object.toString() + " of Property " + property.getName() + " is not an EObject.";
            Message.error(err);
        }
        if (eObject != null) {
            TableItem propValueItem = new TableItem(table, 0);
            propValueItem.setText(eObject.getClass().getName());
            propValueItem.setData((Object)eObject);
        }
    }
}

