/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.extension.ExtensionException;
import org.eclipse.papyrus.infra.core.extension.ExtensionUtils;
import org.eclipse.papyrus.infra.core.resource.AbstractModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.IModelSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class ModelsReader
extends ExtensionUtils {
    public static final String LOAD_AFTER_ELEMENT_NAME = "loadAfter";
    public static final String UNLOAD_BEFORE_ELEMENT_NAME = "unloadBefore";
    public static final String DEPENDENCY_ELEMENT_NAME = "dependency";
    public static final String EXTENSION_POINT_NAME = "model";
    public static final String MODEL_ELEMENT_NAME = "model";
    public static final String MODEL_SNIPPET_ELEMENT_NAME = "modelSnippet";
    public static final String MODEL_SET_SNIPPET_ELEMENT_NAME = "modelSetSnippet";
    private static final String CLASSNAME_ATTRIBUTE = "classname";
    public static final String IDENTIFIER_ATTRIBUTE_NAME = "identifier";
    private static final String EXTENSION_ATTRIBUTE = "fileExtension";
    private static final String REQUIRED_ATTRIBUTE = "required";
    protected String extensionPointNamespace;

    public ModelsReader() {
        this("org.eclipse.papyrus.infra.core");
    }

    public ModelsReader(String extensionPointNamespace) {
        this.extensionPointNamespace = extensionPointNamespace;
    }

    public void readModel(ModelSet modelSet) {
        IConfigurationElement[] configElements = this.getExtensions();
        this.addDeclaredModels(configElements, modelSet);
        this.addDeclaredModelSetSnippets(configElements, modelSet);
    }

    private IConfigurationElement[] getExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointNamespace, "model");
    }

    public boolean hasAssociatedModel(URI uri) {
        boolean result = false;
        String extension = uri.fileExtension();
        if (extension != null) {
            IConfigurationElement[] configs = this.getExtensions();
            int i = 0;
            while (!result && i < configs.length) {
                String modelExtension = configs[i].getAttribute(EXTENSION_ATTRIBUTE);
                result = modelExtension != null && modelExtension.equals(extension);
                ++i;
            }
        }
        return result;
    }

    public Collection<URI> getKnownModelURIs(URI prototypeURI) {
        HashSet result = Sets.newHashSet();
        URI uriWithoutExtension = prototypeURI.trimFileExtension();
        IConfigurationElement[] configs = this.getExtensions();
        int i = 0;
        while (i < configs.length) {
            String modelExtension = configs[i].getAttribute(EXTENSION_ATTRIBUTE);
            if (modelExtension != null) {
                result.add(uriWithoutExtension.appendFileExtension(modelExtension));
            }
            ++i;
        }
        return result;
    }

    private void addDeclaredModels(IConfigurationElement[] configElements, ModelSet modelSet) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                if ("model".equals(ele.getName())) {
                    IModel model = this.instanciateModel(ele);
                    AbstractModel previous = (AbstractModel)TypeUtils.as((Object)modelSet.getModel(model.getIdentifier()), AbstractModel.class);
                    modelSet.registerModel(model);
                    model = modelSet.getModel(model.getIdentifier());
                    if (previous != null && previous != model) {
                        this.inherit(model, previous);
                    }
                    this.addDeclaredModelSnippet(ele, model);
                    this.addDeclaredDependencies(ele, model);
                    Activator.log.debug("model loaded: '" + model.getClass().getName() + "'");
                }
            }
            catch (ExtensionException e) {
                Activator.log.error("Problems occur while instanciating model", (Throwable)e);
            }
            ++n2;
        }
    }

    private void inherit(IModel special, AbstractModel general) {
        general.snippets.forEach(special::addModelSnippet);
        special.setAfterLoadModelDependencies(general.getAfterLoadModelIdentifiers());
        special.setBeforeUnloadDependencies(general.getUnloadBeforeModelIdentifiers());
    }

    private void addDeclaredModelSetSnippets(IConfigurationElement[] configElements, ModelSet modelSet) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                if (MODEL_SET_SNIPPET_ELEMENT_NAME.equals(ele.getName())) {
                    IModelSetSnippet snippet = this.instanciateModelSetSnippet(ele);
                    modelSet.addModelSetSnippet(snippet);
                    Activator.log.debug("modelSet snippet added: '" + ((Object)((Object)modelSet)).getClass().getName() + "().add(" + snippet.getClass().getName() + ")'");
                }
            }
            catch (ExtensionException e) {
                Activator.log.error("Problems occur while instanciating snippet", (Throwable)e);
            }
            ++n2;
        }
    }

    private IModel instanciateModel(IConfigurationElement ele) throws ExtensionException {
        IModel model;
        Class<?> modelInstance = this.parseClass(ele, CLASSNAME_ATTRIBUTE, "model");
        try {
            model = (IModel)modelInstance.newInstance();
        }
        catch (InstantiationException e) {
            throw new ExtensionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionException(e);
        }
        return model;
    }

    private IModelSnippet instanciateModelSnippet(IConfigurationElement ele) throws ExtensionException {
        IModelSnippet snippet;
        Class<?> modelInstance = this.parseClass(ele, CLASSNAME_ATTRIBUTE, MODEL_SNIPPET_ELEMENT_NAME);
        try {
            snippet = (IModelSnippet)modelInstance.newInstance();
        }
        catch (InstantiationException e) {
            throw new ExtensionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionException(e);
        }
        return snippet;
    }

    private IModelSetSnippet instanciateModelSetSnippet(IConfigurationElement ele) throws ExtensionException {
        IModelSetSnippet snippet;
        Class<?> modelInstance = this.parseClass(ele, CLASSNAME_ATTRIBUTE, MODEL_SET_SNIPPET_ELEMENT_NAME);
        try {
            snippet = (IModelSetSnippet)modelInstance.newInstance();
        }
        catch (InstantiationException e) {
            throw new ExtensionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionException(e);
        }
        return snippet;
    }

    private void addDeclaredModelSnippet(IConfigurationElement parentElement, IModel model) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = parentElement.getChildren(MODEL_SNIPPET_ELEMENT_NAME);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                IModelSnippet snippet = this.instanciateModelSnippet(ele);
                model.addModelSnippet(snippet);
                Activator.log.debug("model snippet added: '" + model.getClass().getName() + "().add(" + snippet.getClass().getName() + ")'");
            }
            catch (ExtensionException e) {
                Activator.log.error("Problems occur while instanciating model snippet", (Throwable)e);
            }
            ++n2;
        }
    }

    protected void addDeclaredDependencies(IConfigurationElement modelConfigurationElement, IModel model) {
        IConfigurationElement[] dependencyElements = modelConfigurationElement.getChildren(DEPENDENCY_ELEMENT_NAME);
        LinkedHashSet<String> afterLoadModelIdentifiers = null;
        LinkedHashSet<String> unloadBeforeModelIdentifiers = null;
        IConfigurationElement[] iConfigurationElementArray = dependencyElements;
        int n = dependencyElements.length;
        int n2 = 0;
        while (n2 < n) {
            List<String> existing;
            String identifier;
            IConfigurationElement dependencyElement = iConfigurationElementArray[n2];
            IConfigurationElement[] loadAfterElements = dependencyElement.getChildren(LOAD_AFTER_ELEMENT_NAME);
            IConfigurationElement[] unloadBeforeElements = dependencyElement.getChildren(UNLOAD_BEFORE_ELEMENT_NAME);
            IConfigurationElement[] iConfigurationElementArray2 = loadAfterElements;
            int n3 = loadAfterElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement loadAfterElement = iConfigurationElementArray2[n4];
                identifier = loadAfterElement.getAttribute(IDENTIFIER_ATTRIBUTE_NAME);
                if (identifier != null && identifier.length() > 0) {
                    if (afterLoadModelIdentifiers == null) {
                        afterLoadModelIdentifiers = new LinkedHashSet<String>();
                        existing = model.getAfterLoadModelIdentifiers();
                        if (existing != null) {
                            afterLoadModelIdentifiers.addAll(existing);
                        }
                    }
                    afterLoadModelIdentifiers.add(identifier);
                }
                ++n4;
            }
            iConfigurationElementArray2 = unloadBeforeElements;
            n3 = unloadBeforeElements.length;
            n4 = 0;
            while (n4 < n3) {
                IConfigurationElement unloadBeforeElement = iConfigurationElementArray2[n4];
                identifier = unloadBeforeElement.getAttribute(IDENTIFIER_ATTRIBUTE_NAME);
                if (identifier != null && identifier.length() > 0) {
                    if (unloadBeforeModelIdentifiers == null) {
                        unloadBeforeModelIdentifiers = new LinkedHashSet<String>();
                        existing = model.getUnloadBeforeModelIdentifiers();
                        if (existing != null) {
                            unloadBeforeModelIdentifiers.addAll(existing);
                        }
                    }
                    unloadBeforeModelIdentifiers.add(identifier);
                }
                ++n4;
            }
            ++n2;
        }
        if (afterLoadModelIdentifiers != null) {
            model.setAfterLoadModelDependencies(new ArrayList<String>(afterLoadModelIdentifiers));
        }
        if (unloadBeforeModelIdentifiers != null) {
            model.setBeforeUnloadDependencies(new ArrayList<String>(unloadBeforeModelIdentifiers));
        }
    }

    public Set<IModel> getRequiredModels(ModelSet modelSet) {
        return this.getRequiredModels(modelSet, IModel.class);
    }

    public <M extends IModel> Set<M> getRequiredModels(ModelSet modelSet, Class<M> modelType) {
        Set<String> requiredModelClasses = Stream.of(this.getExtensions()).filter(c -> Boolean.parseBoolean(c.getAttribute(REQUIRED_ATTRIBUTE))).map(c -> c.getAttribute(CLASSNAME_ATTRIBUTE)).filter(Objects::nonNull).collect(Collectors.toSet());
        return modelSet.models.values().stream().filter(modelType::isInstance).map(modelType::cast).filter(ModelsReader.instanceOfAny(requiredModelClasses)).collect(Collectors.toSet());
    }

    private static Predicate<IModel> instanceOfAny(Set<String> classNames) {
        return model -> {
            boolean result = false;
            Class<?> type = model.getClass();
            while (!result && type != null) {
                result = classNames.contains(type.getName());
                type = type.getSuperclass();
            }
            return result;
        };
    }
}

