/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.functions;

import java.util.List;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.LocalVarContext;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.common.StacktraceEntry;
import org.eclipse.xtend.backend.functions.AbstractFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceDefinedFunction
extends AbstractFunction {
    private final QualifiedName _name;
    private final List<String> _paramNames;
    private final ExpressionBase _def;

    public SourceDefinedFunction(QualifiedName name, List<String> paramNames, List<BackendType> paramTypes, BackendType returnType, ExpressionBase def, boolean cached, ExpressionBase guard) {
        super(guard, paramTypes, returnType, cached);
        this._name = name;
        this._paramNames = paramNames;
        this._def = def;
    }

    @Override
    public Object invoke(ExecutionContext ctx, Object[] params) {
        LocalVarContext lvc = new LocalVarContext();
        int i = 0;
        while (i < this._paramNames.size()) {
            lvc.getLocalVars().put(this._paramNames.get(i), params[i]);
            ++i;
        }
        LocalVarContext oldLvc = ctx.getLocalVarContext();
        try {
            ctx.setLocalVarContext(lvc);
            if (ctx.isLogStacktrace()) {
                ctx.getStacktrace().add(new StacktraceEntry(this._def.getPos(), ctx));
            }
            Object object = this._def.evaluate(ctx);
            return object;
        }
        finally {
            if (ctx.isLogStacktrace()) {
                ctx.getStacktrace().remove(ctx.getStacktrace().size() - 1);
            }
            ctx.setLocalVarContext(oldLvc);
        }
    }

    public QualifiedName getName() {
        return this._name;
    }

    public List<String> getParamNames() {
        return this._paramNames;
    }

    public ExpressionBase getDefExpression() {
        return this._def;
    }

    public String toString() {
        return "SourceDefinedFunction '" + this._name + "' " + this.getParameterTypes();
    }
}

