/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.internal;

import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

public class JDTUtil {
    private static final Pattern patternNamespace = Pattern.compile("::");

    public static IStorage findStorage(IJavaProject project, ResourceID id, boolean searchJars) {
        IPath p = JDTUtil.path(id);
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IStorage storage;
                IPackageFragmentRoot root2 = iPackageFragmentRootArray[n2];
                IPackageFragmentRoot root = root2;
                if (!root.isArchive()) {
                    IResource r;
                    IStorage member;
                    IResource resource;
                    IContainer rootFolder = null;
                    IResource correspondingResource = root.getCorrespondingResource();
                    if (correspondingResource instanceof IContainer) {
                        rootFolder = (IContainer)correspondingResource;
                    } else if (root instanceof ExternalPackageFragmentRoot && (resource = ((ExternalPackageFragmentRoot)root).resource()) instanceof IContainer && (member = (IStorage)(rootFolder = (IContainer)resource).findMember(p)) != null) {
                        return member;
                    }
                    if (rootFolder != null && (r = project.getProject().findMember(rootFolder.getProjectRelativePath().append(p))) instanceof IFile) {
                        return (IFile)r;
                    }
                } else if (searchJars && (storage = JDTUtil.loadFromJar(id, root)) != null) {
                    return storage;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            XtendLog.logInfo(e);
        }
        return null;
    }

    public static IStorage loadFromJar(ResourceID id, IPackageFragmentRoot root) throws JavaModelException {
        if (root instanceof JarPackageFragmentRoot) {
            ZipFile zipFile;
            JarPackageFragmentRoot jar = (JarPackageFragmentRoot)root;
            try {
                zipFile = jar.getJar();
            }
            catch (CoreException e) {
                XtendLog.logError(e);
                return null;
            }
            ZipEntry entry = zipFile.getEntry(id.toFileName());
            if (entry != null) {
                return new ZipEntryStorage(zipFile, entry);
            }
        }
        return null;
    }

    public static ResourceID findXtendXpandResourceID(IJavaProject project, IStorage file) {
        if (file == null) {
            return null;
        }
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getPath().isPrefixOf(file.getFullPath())) {
                    int j;
                    IPath shortOne = file.getFullPath().removeFirstSegments(root.getPath().segmentCount());
                    if (shortOne.getDevice() != null && (j = shortOne.toString().indexOf(58)) != -1) {
                        shortOne = new Path(shortOne.toString().substring(j + 1, shortOne.toString().length()));
                    }
                    return JDTUtil.toResourceID(shortOne);
                }
                ++n2;
            }
        }
        catch (JavaModelException e1) {
            XtendLog.logInfo(e1);
        }
        return null;
    }

    public static IJavaProject getJProject(IStorage s) {
        IProject[] projects;
        if (s instanceof IFile) {
            return JavaCore.create((IProject)((IFile)s).getProject());
        }
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IJavaProject p = JavaCore.create((IProject)project);
            if (p.exists()) {
                try {
                    IPackageFragmentRoot[] roots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots = p.getPackageFragmentRoots();
                    int n3 = roots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                        if (root.getPath().isPrefixOf(s.getFullPath())) {
                            return p;
                        }
                        ++n4;
                    }
                }
                catch (JavaModelException e) {
                    XtendLog.logError(e);
                }
            }
            ++n2;
        }
        return null;
    }

    private static IPath path(ResourceID id) {
        return new Path(String.valueOf(patternNamespace.matcher(id.name).replaceAll("/")) + "." + id.extension);
    }

    private static ResourceID toResourceID(IPath path) {
        return new ResourceID(path.removeFileExtension().toString().replace("/", "::"), path.getFileExtension());
    }

    public static String getQualifiedName(IStorage source) {
        ResourceID id = JDTUtil.findXtendXpandResourceID(JDTUtil.getJProject(source), source);
        if (id != null) {
            return id.name;
        }
        return null;
    }
}

