/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.internal.command;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.commands.operations.IOperationApprover2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.internal.command.ICommandWithSettableResult;

public class FileModificationApprover
implements IOperationApprover2 {
    public IStatus proceedExecuting(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        if (operation instanceof ICommand) {
            return this.approveFileModification((ICommand)operation);
        }
        return Status.OK_STATUS;
    }

    public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        if (operation instanceof ICommand) {
            return this.approveFileModification((ICommand)operation);
        }
        return Status.OK_STATUS;
    }

    public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        if (operation instanceof ICommand) {
            return this.approveFileModification((ICommand)operation);
        }
        return Status.OK_STATUS;
    }

    private IStatus approveFileModification(ICommand fileModifier) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (IFile nextFile : fileModifier.getAffectedFiles()) {
            if (nextFile == null) continue;
            if (nextFile.exists()) {
                files.add(nextFile);
                continue;
            }
            IPath path = nextFile.getRawLocation();
            if (path == null) {
                this.setCommandResult(fileModifier, Status.CANCEL_STATUS);
                return Status.CANCEL_STATUS;
            }
            File file = path.toFile();
            if (file == null || !file.exists() || file.canWrite()) continue;
            this.setCommandResult(fileModifier, Status.CANCEL_STATUS);
            return Status.CANCEL_STATUS;
        }
        IStatus status = FileModificationValidator.approveFileModification(files.toArray(new IFile[0]));
        if (!status.isOK()) {
            this.setCommandResult(fileModifier, status);
        }
        return status;
    }

    private void setCommandResult(ICommand command, IStatus status) {
        if (command instanceof ICommandWithSettableResult) {
            ((ICommandWithSettableResult)((Object)command)).internalSetResult(new CommandResult(status));
        }
    }
}

