/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class LEDFigure
extends NodeFigure
implements HandleBounds {
    private Color fontColor;
    public static final Color DISPLAY_SHADOW = new Color(null, 57, 117, 90);
    public static final Color DISPLAY_TEXT = new Color(null, 255, 199, 16);
    protected String value;
    private Dimension prefSize;

    public LEDFigure(Dimension prefSize) {
        this.getBounds().width = prefSize.width;
        this.getBounds().height = prefSize.height;
        this.prefSize = new Dimension(prefSize);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(this.prefSize);
    }

    protected void paintFigure(Graphics g) {
        IMapMode mm = MapModeUtil.getMapMode((IFigure)this);
        Rectangle displayRectangle = new Rectangle(mm.DPtoLP(15), mm.DPtoLP(11), mm.DPtoLP(31), mm.DPtoLP(25));
        Rectangle displayShadow = new Rectangle(mm.DPtoLP(14), mm.DPtoLP(10), mm.DPtoLP(32), mm.DPtoLP(26));
        Rectangle displayHighlight = new Rectangle(mm.DPtoLP(15), mm.DPtoLP(11), mm.DPtoLP(32), mm.DPtoLP(26));
        Point valuePoint = new Point(mm.DPtoLP(16), mm.DPtoLP(10));
        int Y1 = mm.DPtoLP(0);
        int Y2 = mm.DPtoLP(44);
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        g.fillRectangle(mm.DPtoLP(0), mm.DPtoLP(0), r.width, r.height);
        int right = r.width - 1;
        g.drawLine(mm.DPtoLP(0), Y1, right, Y1);
        g.drawLine(mm.DPtoLP(0), Y1, mm.DPtoLP(0), Y2);
        g.drawLine(mm.DPtoLP(0), Y2, right, Y2);
        g.drawLine(right, Y1, right, Y2);
        RGB whiteColor = ColorConstants.white.getRGB();
        RGB backgroundColor = this.getBackgroundColor().getRGB();
        RGB newHightlightRGB = new RGB((whiteColor.red + backgroundColor.red) / 2, (whiteColor.green + backgroundColor.green) / 2, (whiteColor.blue + backgroundColor.blue) / 2);
        g.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(newHightlightRGB));
        g.fillRectangle(displayHighlight);
        RGB blackColor = ColorConstants.black.getRGB();
        RGB newShadowRGB = new RGB((blackColor.red + backgroundColor.red) / 2, (blackColor.green + backgroundColor.green) / 2, (blackColor.blue + backgroundColor.blue) / 2);
        g.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(newShadowRGB));
        g.fillRectangle(displayShadow);
        g.setBackgroundColor(ColorConstants.black);
        g.fillRectangle(displayRectangle);
        g.setForegroundColor(this.getFontColor());
        g.drawText(this.value, valuePoint);
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color c) {
        this.fontColor = c;
        this.revalidate();
    }

    public void setValue(int val) {
        this.value = String.valueOf(val);
        if (val < 10) {
            this.value = "0" + this.value;
        }
        this.repaint();
    }

    public String toString() {
        return "LEDFigure";
    }
}

