/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.tools;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.util.SelectInDiagramHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;

public class RubberbandSelectionTool
extends AbstractTool {
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private int mode;
    private Figure marqueeRectangleFigure;
    private HashSet allChildren = new HashSet();
    private List selectedEditParts;
    private Request targetRequest;
    private Point feedBackStartLocation = null;
    private WeakReference weakReference;
    private static final Request MARQUEE_REQUEST = new Request((Object)"selection");

    public RubberbandSelectionTool() {
        this.setDefaultCursor(SharedCursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    private List calculateNewSelection() {
        ArrayList<EditPart> newSelections = new ArrayList<EditPart>();
        Iterator children = this.getAllChildren().iterator();
        Rectangle marqueeBounds = this.getMarqueeBounds();
        while (children.hasNext()) {
            EditPart child = (EditPart)children.next();
            IFigure figure = ((GraphicalEditPart)child).getFigure();
            if (!child.isSelectable() || child.getTargetEditPart(MARQUEE_REQUEST) != child || !this.isFigureVisible(figure)) continue;
            Rectangle r = child instanceof ConnectionEditPart ? ((Connection)figure).getPoints().getBounds().getCopy() : figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)r);
            this.getMarqueeFeedbackFigure().translateToRelative((Translatable)r);
            if (!marqueeBounds.contains(r.getTopLeft()) || !marqueeBounds.contains(r.getBottomRight())) continue;
            newSelections.add(child);
        }
        return newSelections;
    }

    private boolean isFigureVisible(IFigure fig) {
        Rectangle figBounds = fig.getBounds().getCopy();
        IFigure walker = fig.getParent();
        Viewport topViewport = ((FigureCanvas)this.getCurrentViewer().getControl()).getViewport();
        while (!figBounds.isEmpty() && walker != null && walker != topViewport) {
            walker.translateToParent((Translatable)figBounds);
            figBounds.intersect(walker.getBounds());
            walker = walker.getParent();
        }
        return !figBounds.isEmpty();
    }

    private Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.allChildren = new HashSet();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
        this.feedBackStartLocation = null;
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        ListIterator oldEditParts = this.selectedEditParts.listIterator();
        while (oldEditParts.hasNext()) {
            EditPart editPart = (EditPart)oldEditParts.next();
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    private HashSet getAllChildren(EditPart editPart, HashSet allChildren1) {
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            if (!(child instanceof IBorderItemEditPart)) {
                allChildren1.add(child);
                this.getAllChildren((EditPart)child, allChildren1);
            }
            allChildren1.addAll(child.getSourceConnections());
            allChildren1.addAll(child.getTargetConnections());
            ++i;
        }
        return allChildren1;
    }

    private HashSet getAllChildren() {
        if (this.allChildren.isEmpty()) {
            this.allChildren = this.getAllChildren(this.getCurrentViewer().getContents(), new HashSet());
        }
        return this.allChildren;
    }

    protected String getCommandName() {
        return "selection";
    }

    protected String getDebugName() {
        return "Marquee Tool";
    }

    protected IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    private Rectangle getMarqueeBounds() {
        if (this.getMarqueeFeedbackFigure() == null) {
            return new Rectangle();
        }
        Rectangle rect = new Rectangle();
        if (this.feedBackStartLocation == null) {
            rect = this.getMarqueeSelectionRectangle();
            this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rect);
            this.feedBackStartLocation = rect.getLocation();
            return rect;
        }
        Point location = this.getLocation().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)location);
        rect = new Rectangle(this.feedBackStartLocation, location);
        return rect;
    }

    private int getSelectionMode() {
        return this.mode;
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isControlKeyDown()) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            }
            this.clearFocus();
        }
        return true;
    }

    private void clearFocus() {
        EditPart focusPart = this.getCurrentViewer().getFocusEditPart();
        if (focusPart != null) {
            this.getCurrentViewer().setFocus(this.getCurrentViewer().getContents());
        }
    }

    protected void handleFinished() {
        this.getCurrentViewer().setFocus(null);
        super.handleFinished();
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.performMarqueeSelect();
            this.eraseMarqueeFeedback();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateNewSelection();
            this.showTargetFeedback();
            SelectInDiagramHelper.exposeLocation((FigureCanvas)this.getCurrentViewer().getControl(), this.getLocation());
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        return this.getCurrentViewer().getKeyHandler() != null && this.getCurrentViewer().getKeyHandler().keyPressed(e);
    }

    private boolean isGraphicalViewer() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    protected void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        List newSelections = this.calculateNewSelection();
        if (this.getSelectionMode() == 2) {
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                viewer.appendSelection(editPart);
                ++i;
            }
        } else if (this.getSelectionMode() == 1) {
            ArrayList<EditPart> selected = new ArrayList<EditPart>(viewer.getSelectedEditParts());
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                if (editPart.getSelected() != 0) {
                    selected.remove(editPart);
                } else {
                    selected.add(editPart);
                }
                ++i;
            }
            viewer.setSelection((ISelection)new StructuredSelection(selected));
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(newSelections));
        }
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(SharedCursors.CROSS);
        } else {
            this.setDefaultCursor(SharedCursors.NO);
        }
        if (viewer != null) {
            this.weakReference = new WeakReference<EditPartViewer>(viewer);
        }
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    private void showMarqueeFeedback() {
        this.getMarqueeFeedbackFigure().setBounds(this.getMarqueeBounds());
    }

    private void showTargetFeedback() {
        int i = 0;
        while (i < this.selectedEditParts.size()) {
            EditPart editPart = (EditPart)this.selectedEditParts.get(i);
            editPart.showTargetFeedback(this.getTargetRequest());
            ++i;
        }
    }

    protected void removeFeedback(IFigure figure) {
        EditPartViewer viewer = this.getCurrentViewer();
        if (viewer == null && this.weakReference != null) {
            viewer = (EditPartViewer)this.weakReference.get();
        }
        if (viewer != null) {
            LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
            if (lm == null) {
                return;
            }
            lm.getLayer((Object)"Feedback Layer").remove(figure);
        }
    }

    class MarqueeRectangleFigure
    extends Figure {
        private int offset = 0;
        private boolean schedulePaint = true;
        private static final int DELAY = 110;

        MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds1 = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setLineStyle(3);
            int[] points = new int[]{0 + this.offset, 0, bounds1.width - 1, 0, bounds1.width - 1, bounds1.height - 1};
            graphics.drawPolyline(points);
            points[0] = 0;
            points[1] = 0 + this.offset;
            points[2] = 0;
            points[3] = bounds1.height - 1;
            points[4] = bounds1.width - 1;
            points[5] = bounds1.height - 1;
            graphics.drawPolyline(points);
            graphics.translate(this.getLocation().getNegated());
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(){

                    @Override
                    public void run() {
                        MarqueeRectangleFigure marqueeRectangleFigure = MarqueeRectangleFigure.this;
                        marqueeRectangleFigure.offset = marqueeRectangleFigure.offset + 1;
                        if (MarqueeRectangleFigure.this.offset > 5) {
                            MarqueeRectangleFigure.this.offset = 0;
                        }
                        MarqueeRectangleFigure.this.schedulePaint = true;
                        MarqueeRectangleFigure.this.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }
    }
}

