/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.merge.service;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.eclipse.emf.compare.diff.merge.EMFCompareEObjectCopier;
import org.eclipse.emf.compare.diff.merge.IMergeListener;
import org.eclipse.emf.compare.diff.merge.IMerger;
import org.eclipse.emf.compare.diff.merge.MergeEvent;
import org.eclipse.emf.compare.diff.merge.service.MergeFactory;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeService {
    private static EMFCompareEObjectCopier copier;
    private static final List<IMergeListener> MERGE_LISTENERS;

    static {
        MERGE_LISTENERS = new ArrayList<IMergeListener>();
    }

    private MergeService() {
    }

    public static void addMergeListener(IMergeListener listener) {
        MERGE_LISTENERS.add(listener);
    }

    public static EMFCompareEObjectCopier getCopier(DiffElement diff) {
        DiffModel diffModel = MergeService.getContainerDiffModel(diff);
        if (diffModel == null) {
            throw new IllegalArgumentException("The diff element should be contained in a DiffModel instance");
        }
        if (copier == null) {
            copier = new EMFCompareEObjectCopier(diffModel);
        } else if (copier.getDiffModel() != diffModel) {
            copier.clear();
            copier = new EMFCompareEObjectCopier(diffModel);
        }
        return copier;
    }

    private static DiffModel getContainerDiffModel(DiffElement diff) {
        EObject container = diff.eContainer();
        while (container != null) {
            if (container instanceof DiffModel) {
                return (DiffModel)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    public static void merge(DiffElement element, boolean leftToRight) {
        MergeService.fireMergeOperationStart(element);
        MergeService.doMerge(element, leftToRight);
        MergeService.fireMergeOperationEnd(element);
    }

    public static void merge(List<DiffElement> elements, boolean leftToRight) throws ConcurrentModificationException {
        MergeService.fireMergeOperationStart(elements);
        for (DiffElement element : elements) {
            if (element.eContainer() == null) continue;
            MergeService.doMerge(element, leftToRight);
        }
        MergeService.fireMergeOperationEnd(elements);
    }

    public static void removeMergeListener(IMergeListener listener) {
        MERGE_LISTENERS.remove(listener);
    }

    protected static void doMerge(DiffElement element, boolean leftToRight) {
        MergeService.fireMergeDiffStart(element);
        IMerger merger = element instanceof ConflictingDiffElement ? MergeFactory.createMerger((DiffElement)element.getSubDiffElements().get(0)) : MergeFactory.createMerger(element);
        if (leftToRight && merger.canUndoInTarget()) {
            merger.undoInTarget();
        } else if (!leftToRight && merger.canApplyInOrigin()) {
            merger.applyInOrigin();
        }
        MergeService.fireMergeDiffEnd(element);
    }

    protected static void fireMergeDiffEnd(DiffElement diff) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeDiffEnd(new MergeEvent(diff));
        }
    }

    protected static void fireMergeDiffStart(DiffElement diff) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeDiffStart(new MergeEvent(diff));
        }
    }

    protected static void fireMergeOperationEnd(DiffElement diff) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeOperationEnd(new MergeEvent(diff));
        }
    }

    protected static void fireMergeOperationEnd(List<DiffElement> diffs) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeOperationEnd(new MergeEvent(diffs));
        }
    }

    protected static void fireMergeOperationStart(DiffElement diff) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeOperationStart(new MergeEvent(diff));
        }
    }

    protected static void fireMergeOperationStart(List<DiffElement> diffs) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeOperationStart(new MergeEvent(diffs));
        }
    }
}

