/*
 * Decompiled with CFR 0.152.
 */
package graph.util.extensions;

import graph.Attribute;
import graph.Edge;
import graph.Graph;
import graph.Node;
import graph.util.extensions.Constants;
import graph.util.extensions.ExtendedNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GraphPrinter {
    private Graph graph;
    private int lastPrinted;
    private StringBuffer result;

    public GraphPrinter(Graph graph) {
        this.graph = graph;
        this.lastPrinted = -1;
    }

    private List<ExtendedNode> getExtendedNodes(Graph graph) {
        ArrayList<ExtendedNode> extNodes = new ArrayList<ExtendedNode>();
        for (Node n : graph.getNodes()) {
            extNodes.add(new ExtendedNode(n));
        }
        for (ExtendedNode extNode : extNodes) {
            for (Edge edge : graph.getEdges()) {
                if (extNode.getNode() == edge.getTarget()) {
                    extNode.setPredecessor(this.getExtendedNode(extNodes, edge.getSource()));
                }
                if (extNode.getNode() != edge.getSource()) continue;
                extNode.addSuccessor(this.getExtendedNode(extNodes, edge.getTarget()));
            }
        }
        ArrayList<ExtendedNode> rootExtNodes = new ArrayList<ExtendedNode>();
        for (ExtendedNode extNode : extNodes) {
            if (extNode.getPredecessor() != null) continue;
            rootExtNodes.add(extNode);
        }
        return rootExtNodes;
    }

    private ExtendedNode getExtendedNode(List<ExtendedNode> extNodes, Node node) {
        for (ExtendedNode extNode : extNodes) {
            if (extNode.getNode() != node) continue;
            return extNode;
        }
        return null;
    }

    public void printDocument() {
        this.result = new StringBuffer(this.printPreambel());
        this.result.append("\\begin{document}\n");
        this.result.append(this.printGraph());
        this.result.append("\n\\end{document}");
        this.saveFile();
    }

    public String printPreambel() {
        StringBuffer preambel = new StringBuffer("\\documentclass[12pt]{article}\n");
        preambel.append("\\usepackage{texstyles/tikz-cellular}\n");
        preambel.append("\\usepackage{texstyles/tikz-vcond}\n");
        preambel.append("\\usepackage{texstyles/tikz-extension}\n");
        preambel.append("\\usepackage{amssymb}\n");
        return preambel.toString();
    }

    public String printPreambel2() {
        StringBuffer preambel = new StringBuffer("\\documentclass[12pt]{standalone}\n");
        preambel.append("\\usepackage{texstyles/tikz-cellular}\n");
        preambel.append("\\usepackage{texstyles/tikz-vcond}\n");
        preambel.append("\\usepackage{texstyles/tikz-extension}\n");
        preambel.append("\\usetikzlibrary{arrows,arrows.meta}\n");
        preambel.append("\\usepackage{amssymb}\n");
        return preambel.toString();
    }

    public String printGraph() {
        StringBuffer ret;
        if (this.graph.getNodes().isEmpty()) {
            ret = new StringBuffer("\\emptyset");
        } else {
            ret = new StringBuffer("\\tikz { ");
            ret.append(this.printExtendedNodes(this.getExtendedNodes(this.graph), false));
            for (Edge edge : this.graph.getEdges()) {
                ret.append(this.printEdge(edge));
            }
            ret.append(" } ");
        }
        this.lastPrinted = -1;
        return ret.toString();
    }

    private String printEdge(Edge edge) {
        EList<Node> nodes = this.graph.getNodes();
        StringBuffer ret = edge.getType().isContainment() ? new StringBuffer("\\draw [{Diamond}-{Stealth}]  (" + this.getNodeName(nodes, edge.getSource()) + ") ") : new StringBuffer("\\draw [->] (" + this.getNodeName(nodes, edge.getSource()) + ") ");
        ret.append(" to node [above,sloped] { \\tiny " + edge.getType().getName() + " } ");
        ret.append(" (" + this.getNodeName(nodes, edge.getTarget()) + ") " + " ; " + "\n");
        return ret.toString();
    }

    private String printExtendedNodes(List<ExtendedNode> extendedNodes, boolean succ) {
        int source = -1;
        if (succ && !extendedNodes.isEmpty()) {
            source = this.graph.getNodes().indexOf((Object)extendedNodes.get(0).getPredecessor().getNode());
        }
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < extendedNodes.size()) {
            ret.append(this.printNode(extendedNodes.get(i).getNode(), i, succ, source));
            this.lastPrinted = this.graph.getNodes().indexOf((Object)extendedNodes.get(i).getNode());
            ++i;
        }
        i = 0;
        while (i < extendedNodes.size()) {
            ret.append(this.printExtendedNodes(extendedNodes.get(i).getSuccessors(), true));
            ++i;
        }
        return ret.toString();
    }

    private String printNode(Node node, int index, boolean succ, int source) {
        EList<Node> nodes = this.graph.getNodes();
        String sro = "";
        if (this.lastPrinted > -1) {
            sro = ",";
            sro = source < 0 ? String.valueOf(sro) + " strictly below of= " + this.getNodeName(nodes, (Node)nodes.get(this.lastPrinted)) + ",node distance=4em" : String.valueOf(sro) + " strictly right of= " + this.getNodeName(nodes, (Node)nodes.get(source)) + ",node distance=4em";
            if (succ && index > 0) {
                sro = index == 1 ? String.valueOf(sro) + ", above=4ex" : String.valueOf(sro) + ", below=4ex";
            }
        }
        StringBuffer ret = new StringBuffer("\\node (" + this.getNodeName(nodes, node) + ") ");
        if (node.getAttributes().isEmpty()) {
            ret.append("[SClass" + sro + "]" + " { ");
            if (node.getName() != null && !node.getName().isEmpty()) {
                ret.append(node.getName());
            }
            ret.append(":" + node.getType().getName());
            ret.append(" } ");
        } else {
            ret.append("[Class" + sro + "]" + " { ");
            ret.append("\\gnodelabelClass { ");
            if (node.getName() != null && !node.getName().isEmpty()) {
                ret.append(node.getName());
            }
            ret.append(":" + node.getType().getName() + " } ");
            if (!node.getAttributes().isEmpty()) {
                ret.append(" { ");
            }
            for (Attribute attr : node.getAttributes()) {
                if (node.getAttributes().indexOf((Object)attr) != 0) {
                    ret.append(Constants.DOUBLEBS);
                }
                ret.append(this.printAttribute(attr));
            }
            if (!node.getAttributes().isEmpty()) {
                ret.append(" } ");
            }
            ret.append(" } ");
        }
        ret.append(" ; \n");
        return ret.toString();
    }

    private String getNodeName(EList<Node> nodes, Node n) {
        if (n.getName() != null && !n.getName().isEmpty()) {
            return n.getName();
        }
        return "n" + String.valueOf(nodes.indexOf((Object)n));
    }

    private String printAttribute(Attribute attr) {
        StringBuffer ret = new StringBuffer(attr.getType().getName());
        ret.append(" ");
        ret.append(this.printOp(attr.getOp()));
        ret.append(" ");
        if (attr.getValue() == null || attr.getValue().isEmpty()) {
            ret.append("' '");
        } else {
            ret.append(attr.getValue());
        }
        return ret.toString();
    }

    private String printOp(String op) {
        if (op.equals(">=")) {
            return "$\\geq$";
        }
        if (op.equals("<>")) {
            return "$<>$";
        }
        if (op.equals("!=")) {
            return "$!=$";
        }
        if (op.equals(">")) {
            return "$>$";
        }
        if (op.equals("=")) {
            return "$=$";
        }
        if (op.equals("<")) {
            return "$<$";
        }
        return "TODO";
    }

    private void saveFile() {
        URI uri = this.getActualProject().getLocationURI();
        String path = uri.getPath().concat("\\tex\\graph.tex");
        File file = new File(path);
        Writer writer = null;
        try {
            try {
                writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                writer.write(this.result.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    writer.close();
                    this.getActualProject().refreshLocal(2, null);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                writer.close();
                this.getActualProject().refreshLocal(2, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private IProject getActualProject() {
        IProject actualProject = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            try {
                IEditorInput input;
                IEditorPart editorPart = window.getActivePage().getActiveEditor();
                if (editorPart != null && (input = editorPart.getEditorInput()) instanceof IFileEditorInput) {
                    IFileEditorInput fileInput = (IFileEditorInput)input;
                    actualProject = fileInput.getFile().getProject();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return actualProject;
    }
}

