/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.conditions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.emf.henshin.interpreter.matching.conditions.DebugApplicationCondition;

public abstract class HenshinBreakpoint
extends Breakpoint {
    public String getModelIdentifier() {
        return "org.eclipse.emf.henshin.model";
    }

    protected int getIntAttribute(String name, int defaultValue) {
        try {
            return this.ensureMarker().getAttribute(name, defaultValue);
        }
        catch (DebugException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    protected boolean getBooleanAttribute(String name) {
        return Boolean.parseBoolean(this.getAttribute(name, ""));
    }

    protected String getAttribute(String name, String defaultValue) {
        try {
            return this.ensureMarker().getAttribute(name, defaultValue);
        }
        catch (DebugException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public DebugApplicationCondition.DebugLevel getDebugLevel() {
        try {
            return DebugApplicationCondition.DebugLevel.valueOf(this.getAttribute("DebugLevel", ""));
        }
        catch (Exception exception) {
            return DebugApplicationCondition.DebugLevel.NONE;
        }
    }

    public void setDebugLevel(DebugApplicationCondition.DebugLevel debugLevel) {
        try {
            this.setAttribute("DebugLevel", debugLevel.toString());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getMessage() {
        return this.getAttribute("message", null);
    }

    public void setMessage(String message) {
        try {
            this.setAttribute("message", message);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

