/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.wrap.copy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.emf.henshin.trace.util.TraceUtil;
import org.eclipse.emf.henshin.wrap.WrapFactory;
import org.eclipse.emf.henshin.wrap.util.WrapUtil;

public class CopyExample {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/wrap/copy";

    public static void run(String path) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("copy.henshin", false);
        resourceSet.registerDynamicEPackages("../../bank/bank.ecore");
        EList model = resourceSet.getResource("../../bank/example-bank.xmi").getContents();
        Map wrappers = WrapFactory.eINSTANCE.createWModelTree((Collection)model, true);
        EGraphImpl graph = new EGraphImpl(wrappers.values());
        EngineImpl engine = new EngineImpl(new String[0]);
        UnitApplicationImpl app = new UnitApplicationImpl((Engine)engine);
        app.setEGraph((EGraph)graph);
        app.setUnit(module.getUnit("main"));
        if (!app.execute(null)) {
            throw new RuntimeException("Error copying example model.");
        }
        List copy = WrapUtil.getEObjects((List)TraceUtil.getTargets((List)WrapUtil.getWObjects((List)model, (Map)wrappers), (Collection)graph));
        if (!EcoreUtil.equals((EObject)((EObject)model.get(0)), (EObject)((EObject)copy.get(0)))) {
            resourceSet.saveEObject((EObject)copy.get(0), "invalid-copy.xmi");
            throw new RuntimeException("Copied model is not the same as the original. Saved result to invalid-copy.xmi.");
        }
        System.out.println("Successfully copied bank model.");
    }

    public static void main(String[] args) {
        CopyExample.run(PATH);
    }
}

