/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.csp;

import agg.util.csp.Query;
import agg.util.csp.Variable;
import agg.xt_basis.GraphObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Vector;

public class Query_Type
extends Query {
    private HashSet<GraphObject> itsObjects;
    private HashSet<GraphObject> objList;
    private boolean randomized;
    int outgoing = -1;
    int incoming = -1;

    public Query_Type(HashSet<GraphObject> objects, Variable querytar) {
        super(querytar, 0);
        this.objList = objects;
        this.itsObjects = new LinkedHashSet<GraphObject>(objects);
        this.itsWeight = 0;
        if (querytar.getKind() == 1) {
            this.itsWeight += 3;
        }
    }

    public Query_Type(Variable querytar) {
        super(querytar, 0);
        this.itsObjects = new LinkedHashSet<GraphObject>();
        this.itsWeight = 0;
        if (querytar.getKind() == 1) {
            this.itsWeight += 3;
        }
    }

    public void setObjects(HashSet<GraphObject> objects) {
        if (objects != null && this.objList != objects) {
            this.objList = objects;
            if (this.randomized && this.objList.size() > 1) {
                this.itsObjects.clear();
                this.randomize(this.objList);
            } else {
                this.itsObjects.clear();
                this.itsObjects.addAll(this.objList);
            }
            this.getTarget().setDomainSize(this.itsObjects.size());
        }
    }

    public void resetObjects() {
        if (this.objList != null) {
            if (this.randomized && this.objList.size() > 1) {
                this.itsObjects.clear();
                this.randomize(this.objList);
            } else {
                this.itsObjects.clear();
                this.itsObjects.addAll(this.objList);
            }
            this.getTarget().setDomainSize(this.itsObjects.size());
        }
    }

    @Override
    public final HashSet<?> execute() {
        return this.itsObjects;
    }

    public final void removeObject(GraphObject obj) {
        if (obj != null && this.itsObjects.size() > 0) {
            this.itsObjects.remove(obj);
        }
    }

    @Override
    public final int getSize() {
        return this.itsObjects.size();
    }

    @Override
    public final String getKind() {
        return "Query_Type";
    }

    public final int getAvgOutgoingDegree() {
        if (this.getSize() <= 0) {
            return 0;
        }
        if (this.outgoing == -1) {
            this.outgoing = 0;
            for (GraphObject go : this.itsObjects) {
                this.outgoing += go.getNumberOfOutgoingArcs();
            }
            this.outgoing /= this.getSize();
        }
        return this.outgoing;
    }

    public final int getAvgIncomingDegree() {
        if (this.getSize() <= 0) {
            return 0;
        }
        if (this.incoming == -1) {
            this.incoming = 0;
            for (GraphObject go : this.itsObjects) {
                this.incoming += go.getNumberOfIncomingArcs();
            }
            this.incoming /= this.getSize();
        }
        return this.incoming;
    }

    @Override
    public boolean isDomainEmpty() {
        return this.itsObjects.isEmpty();
    }

    private void randomize(HashSet<GraphObject> objects) {
        Vector<GraphObject> newDom = new Vector<GraphObject>(objects);
        Random r = new Random();
        while (newDom.size() > 0) {
            int domSize = newDom.size();
            int i = r.nextInt(domSize);
            GraphObject anObj = newDom.remove(i);
            this.itsObjects.add(anObj);
        }
    }

    public void setRandomizedDomain(boolean randomized) {
        this.randomized = randomized;
    }
}

