/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.csp;

import agg.attribute.AttrContext;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Pair;
import agg.util.csp.SolutionStrategy;
import agg.util.csp.Solution_Backjump;
import agg.util.csp.Variable;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Morphism;
import agg.xt_basis.NACStarMorphism;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.PACStarMorphism;
import agg.xt_basis.Type;
import agg.xt_basis.csp.ALR_CSP;
import java.util.BitSet;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Completion_CSP
extends MorphCompletionStrategy {
    protected static final BitSet itsSupportedProperties = new BitSet(6);
    protected ALR_CSP itsCSP;
    protected Morphism itsMorph;
    protected Dictionary<Object, Variable> relatedVarMap;
    protected final HashMap<String, String> inputParameterMap = new HashMap(1);
    protected final List<VarMember> disabledInputParameter = new Vector<VarMember>(2);
    protected String errorMsg;

    static {
        itsSupportedProperties.set(0);
        itsSupportedProperties.set(1);
        itsSupportedProperties.set(2);
    }

    public Completion_CSP() {
        super(itsSupportedProperties);
        this.itsName = "CSP";
    }

    public Completion_CSP(boolean randomizeDomain) {
        super(itsSupportedProperties);
        this.randomDomain = randomizeDomain;
        this.itsName = "CSP";
    }

    public void setProperties(MorphCompletionStrategy fromStrategy) {
        this.initialize(itsSupportedProperties, (BitSet)fromStrategy.getProperties().clone());
    }

    public void clear() {
        if (this.itsCSP != null) {
            this.itsCSP.clear();
        }
    }

    @Override
    public void dispose() {
        if (this.itsCSP != null) {
            this.itsCSP.resetSolverVariables();
            this.itsCSP.clear();
        }
        this.relatedVarMap = null;
        this.itsMorph = null;
    }

    @Override
    public void initialize(OrdinaryMorphism morph) throws BadMappingException {
        this.itsMorph = morph;
        AttrContext aContext = this.initializeAttrContext(morph);
        this.itsCSP = new ALR_CSP(morph.getOriginal(), aContext, this.createSolutionStrategy(this.getProperties().get(0)), this.randomDomain);
        if (morph.getImage().getTypeObjectsMap().isEmpty()) {
            morph.getImage().fillTypeObjectsMap();
        }
        this.itsCSP.setRequester(morph);
        this.itsCSP.setDomain(morph.getImage());
        this.inputParameterMap.clear();
        this.disabledInputParameter.clear();
        this.itsCSP.getSolutionSolver().enableParallelSearch(this.parallel);
        this.itsCSP.getSolutionSolver().setStartParallelSearchByFirst(this.startParallelMatchByFirstCSPVar);
        this.setPartialMorphism(morph);
    }

    public void initialize(OrdinaryMorphism morph, Collection<Node> nodes, Collection<Arc> edges) throws BadMappingException {
        this.itsMorph = morph;
        AttrContext aContext = this.initializeAttrContext(morph);
        this.itsCSP = nodes != null && edges != null ? new ALR_CSP(nodes, edges, aContext, true, this.randomDomain) : new ALR_CSP(morph.getOriginal(), aContext, this.createSolutionStrategy(this.getProperties().get(0)), this.randomDomain);
        if (morph.getImage().getTypeObjectsMap().isEmpty()) {
            morph.getImage().fillTypeObjectsMap();
        }
        this.itsCSP.setRequester(morph);
        this.itsCSP.setDomain(morph.getImage());
        this.inputParameterMap.clear();
        this.disabledInputParameter.clear();
        this.itsCSP.getSolutionSolver().enableParallelSearch(this.parallel);
        this.itsCSP.getSolutionSolver().setStartParallelSearchByFirst(this.startParallelMatchByFirstCSPVar);
        this.setPartialMorphism(morph);
    }

    protected AttrContext initializeAttrContext(OrdinaryMorphism morph) {
        if (morph instanceof Match) {
            ContextView c = (ContextView)morph.getAttrManager().newContext(((ContextView)morph.getAttrContext()).getAllowedMapping(), ((Match)morph).getRule().getAttrContext());
            c.setIgnoreOfConstContext(((ContextView)morph.getAttrContext()).isIgnoreConstContext());
            return c;
        }
        if (morph instanceof NACStarMorphism) {
            ((NACStarMorphism)morph).setPartialMorphismCompletion(true);
            return morph.getAttrManager().newContext(1, ((NACStarMorphism)morph).getRelatedMatchContext());
        }
        if (morph instanceof PACStarMorphism) {
            ((PACStarMorphism)morph).setPartialMorphismCompletion(true);
            return morph.getAttrManager().newContext(1, ((PACStarMorphism)morph).getRelatedMorphContext());
        }
        return morph.getAttrManager().newContext(0);
    }

    @Override
    public void setPartialMorphism(OrdinaryMorphism morph) {
        if (this.itsMorph != null) {
            this.itsCSP.enableAllVariables();
            for (Node anObj : morph.getOriginal().getNodesSet()) {
                Variable anObjVar;
                GraphObject anImage = morph.getImage(anObj);
                if (anImage == null || (anObjVar = this.itsCSP.getVariable(anObj)) == null || anObjVar.getInstance() == anImage) continue;
                anObjVar.setInstance(anImage);
                Enumeration<Variable> conflicts = anObjVar.checkConstraints();
                if (!conflicts.hasMoreElements()) continue;
                anObjVar.setInstance(null);
                morph.removeMapping(anObj);
            }
            for (Arc anObj : morph.getOriginal().getArcsSet()) {
                Variable anObjVar;
                GraphObject anImage = morph.getImage(anObj);
                if (anImage == null || (anObjVar = this.itsCSP.getVariable(anObj)) == null || anObjVar.getInstance() == anImage) continue;
                anObjVar.setInstance(anImage);
                Enumeration<Variable> conflicts = anObjVar.checkConstraints();
                if (!conflicts.hasMoreElements()) continue;
                anObjVar.setInstance(null);
                morph.removeMapping(anObj);
            }
        }
    }

    protected SolutionStrategy createSolutionStrategy(boolean injective) {
        return new Solution_Backjump(injective);
    }

    @Override
    public void resetSolverQuery_Type() {
        if (this.itsCSP != null) {
            this.itsCSP.resetQuery_Type();
        }
    }

    @Override
    public void enableParallelSearch(boolean b) {
        this.parallel = b;
        if (this.itsCSP != null) {
            this.itsCSP.getSolutionSolver().enableParallelSearch(b);
        }
    }

    @Override
    public void setStartParallelSearchByFirst(boolean b) {
        this.startParallelMatchByFirstCSPVar = b;
        if (this.itsCSP != null) {
            this.itsCSP.getSolutionSolver().setStartParallelSearchByFirst(b);
        }
    }

    @Override
    public AttrContext getAttrContext() {
        return this.itsCSP != null ? this.itsCSP.getAttrContext() : null;
    }

    @Override
    public void resetSolver(boolean doUpdateQueries) {
        if (this.itsCSP != null) {
            this.itsCSP.resetSolver(doUpdateQueries);
        }
    }

    @Override
    public void reinitializeSolver(boolean doUpdateQueries) {
        if (this.itsCSP != null) {
            this.itsCSP.reinitializeSolver(doUpdateQueries);
        }
    }

    @Override
    public void resetSolverVariables() {
        if (this.itsCSP != null) {
            this.itsCSP.resetSolverVariables();
        }
    }

    @Override
    public boolean isDomainOfTypeEmpty(Type t) {
        return this.itsCSP.isDomainOfTypeEmpty(t);
    }

    @Override
    public boolean isDomainOfTypeEmpty(Type t, Type src, Type tar) {
        return this.itsCSP.isDomainOfTypeEmpty(t, src, tar);
    }

    @Override
    public void setRelatedInstanceVarMap(Dictionary<Object, Variable> relVarMap) {
        this.relatedVarMap = relVarMap;
    }

    @Override
    public boolean hasRelatedInstanceVarMap() {
        return this.relatedVarMap != null;
    }

    @Override
    public Dictionary<Object, Variable> getInstanceVarMap() {
        if (this.itsCSP != null) {
            return this.itsCSP.getInstanceVarMap();
        }
        return null;
    }

    @Override
    public void removeFromObjectVarMap(GraphObject anObj) {
        if (this.itsCSP != null) {
            this.itsCSP.removeFromObjectVarMap(anObj);
        }
    }

    @Override
    public final void reset() {
        if (this.itsCSP != null && this.parallel) {
            this.itsCSP.reset();
        }
    }

    @Override
    public void removeFromTypeObjectsMap(GraphObject anObj) {
        if (this.itsCSP != null) {
            this.itsCSP.removeFromTypeObjectsMap(anObj);
        }
    }

    @Override
    public void resetTypeMap(Hashtable<String, HashSet<GraphObject>> typeMap) {
        if (this.itsCSP != null) {
            this.itsCSP.resetTypeMap(typeMap);
        }
    }

    @Override
    public void resetTypeMap(Graph g) {
        if (this.itsCSP != null) {
            this.itsCSP.resetTypeMap(g);
        }
    }

    @Override
    public void resetVariableDomain(boolean initInstanceByNull) {
        if (this.itsCSP != null) {
            this.itsCSP.resetVariableDomain(initInstanceByNull);
            this.inputParameterMap.clear();
            this.disabledInputParameter.clear();
        }
    }

    @Override
    public void resetVariableDomain(GraphObject go) {
        if (this.itsCSP != null) {
            this.itsCSP.resetVariableDomain(go);
        }
    }

    @Override
    protected void unsetAttrContextVariable() {
        this.itsCSP.unsetAttrContextVariable();
    }

    @Override
    public final boolean next(OrdinaryMorphism morph) {
        if (morph != this.itsMorph) {
            try {
                this.initialize(morph);
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        return this.doNext((OrdinaryMorphism)this.itsMorph);
    }

    @Override
    public final boolean next(OrdinaryMorphism morph, Collection<Node> varnodes, Collection<Arc> varedges) {
        if (morph != this.itsMorph) {
            try {
                this.initialize(morph, varnodes, varedges);
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        return this.doNext((OrdinaryMorphism)this.itsMorph);
    }

    private boolean doNext(OrdinaryMorphism morph) {
        this.itsCSP.setRelatedInstanceVarMap(this.relatedVarMap);
        boolean flag = false;
        this.errorMsg = "";
        if (morph.getAttrContext() != null) {
            ((VarTuple)morph.getAttrContext().getVariables()).unsetNotInputVariables();
            this.storeValueOfInputParameter(morph);
        }
        while (this.itsCSP.nextSolution()) {
            flag = true;
            this.errorMsg = "";
            Iterator<Node> anNodeIter = morph.getOriginal().getNodesSet().iterator();
            while (flag && anNodeIter.hasNext()) {
                GraphObject anOrig = anNodeIter.next();
                Variable lhsVariable = this.itsCSP.getVariable(anOrig);
                if (lhsVariable == null) continue;
                GraphObject anImage = (GraphObject)lhsVariable.getInstance();
                try {
                    morph.addMapping(anOrig, anImage);
                }
                catch (BadMappingException ex) {
                    flag = false;
                }
            }
            Iterator<Arc> anArcIter = morph.getOriginal().getArcsSet().iterator();
            while (flag && anArcIter.hasNext()) {
                GraphObject anOrig = anArcIter.next();
                Variable lhsVariable = this.itsCSP.getVariable(anOrig);
                if (lhsVariable == null) continue;
                GraphObject anImage = (GraphObject)lhsVariable.getInstance();
                try {
                    morph.addMapping(anOrig, anImage);
                }
                catch (BadMappingException ex) {
                    flag = false;
                }
            }
            if (flag && morph instanceof Match && (!((Match)morph).areTotalIdentDanglAttrGluingSatisfied() || !((Match)morph).isParallelArcSatisfied())) {
                flag = false;
            }
            if (flag && morph.getAttrContext() != null) {
                boolean bl = flag = this.checkInputParameter(morph) && this.checkObjectsWithSameVariable(morph);
                if (flag && !(morph instanceof NACStarMorphism) && !(morph instanceof PACStarMorphism) && !this.checkAttrCondition(morph)) {
                    flag = false;
                }
            }
            if (flag) {
                morph.clearErrorMsg();
                this.restoreValueOfInputParameter(morph);
                break;
            }
            morph.setErrorMsg(this.errorMsg);
            this.restoreValueOfInputParameter(morph);
            if (morph.getAttrContext() == null) continue;
            ((VarTuple)morph.getAttrContext().getVariables()).unsetNotInputVariables();
        }
        return flag;
    }

    private void storeValueOfInputParameter(OrdinaryMorphism morph) {
        AttrVariableTuple avt = morph.getAttrContext().getVariables();
        int num = avt.getSize();
        int i = 0;
        while (i < num) {
            VarMember var = avt.getVarMemberAt(i);
            if (var.isInputParameter() && this.inputParameterMap.get(var.getName()) == null) {
                if (var.isSet()) {
                    this.inputParameterMap.put(var.getName(), var.getExprAsText());
                } else {
                    this.disabledInputParameter.add(var);
                }
            }
            ++i;
        }
    }

    private void restoreValueOfInputParameter(OrdinaryMorphism morph) {
        if (morph.getAttrContext() != null) {
            AttrVariableTuple avt = morph.getAttrContext().getVariables();
            if (!this.inputParameterMap.isEmpty()) {
                for (String name : this.inputParameterMap.keySet()) {
                    String val = this.inputParameterMap.get(name);
                    VarMember var = avt.getVarMemberAt(name);
                    if (var == null || val.equals(var.getExprAsText())) continue;
                    var.setExprAsText(val);
                }
            }
        }
    }

    private boolean checkInputParameter(OrdinaryMorphism morph) {
        block9: {
            VarMember matchVM;
            VarTuple varsOfMatch;
            OrdinaryMorphism relatedMatch;
            VarMember VM;
            block10: {
                AttrVariableTuple avt = morph.getAttrContext().getVariables();
                if (!this.inputParameterMap.isEmpty()) {
                    for (String IPname : this.inputParameterMap.keySet()) {
                        String IPvalue = this.inputParameterMap.get(IPname);
                        VM = avt.getVarMemberAt(IPname);
                        if (VM == null || !VM.isInputParameter() || !VM.isEnabled()) continue;
                        String VMvalue = VM.getExprAsText();
                        if (morph instanceof Match) {
                            if (VMvalue == null || VM.getMark() == 2 || VM.getMark() == 3 || IPvalue.equals(VMvalue)) continue;
                            this.errorMsg = "Value of the input parameter  [ " + VM.getName() + " ] not found.";
                            return false;
                        }
                        if (morph instanceof NACStarMorphism) {
                            if (VMvalue == null || VM.getMark() != 2 || IPvalue.equals(VMvalue)) continue;
                            this.errorMsg = "Value of the input parameter  [ " + VM.getName() + " ] not found.";
                            return false;
                        }
                        if (morph instanceof PACStarMorphism) {
                            if (VMvalue == null || VM.getMark() != 3 || IPvalue.equals(VMvalue)) continue;
                            this.errorMsg = "Value of the input parameter  [ " + VM.getName() + " ] not found.";
                            return false;
                        }
                        if (VMvalue == null || VM.getMark() == 2 || VM.getMark() == 3 || IPvalue.equals(VMvalue)) continue;
                        this.errorMsg = "Value of the input parameter  [ " + VM.getName() + " ] not found.";
                        return false;
                    }
                }
                if (this.disabledInputParameter.isEmpty()) break block9;
                if (!(morph instanceof NACStarMorphism)) break block10;
                relatedMatch = ((NACStarMorphism)morph).getRelatedMatch();
                varsOfMatch = (VarTuple)relatedMatch.getAttrContext().getVariables();
                int i = 0;
                while (i < this.disabledInputParameter.size()) {
                    VM = this.disabledInputParameter.get(i);
                    if (VM != null && (matchVM = varsOfMatch.getVarMemberAt(VM.getName())) != null && matchVM.getMark() == 2 && !matchVM.isEnabled()) {
                        return false;
                    }
                    ++i;
                }
                break block9;
            }
            if (!(morph instanceof PACStarMorphism)) break block9;
            relatedMatch = ((PACStarMorphism)morph).getRelatedMorph();
            varsOfMatch = (VarTuple)relatedMatch.getAttrContext().getVariables();
            int i = 0;
            while (i < this.disabledInputParameter.size()) {
                VM = this.disabledInputParameter.get(i);
                if (VM != null && (matchVM = varsOfMatch.getVarMemberAt(VM.getName())) != null && matchVM.getMark() == 3 && !matchVM.isEnabled()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean checkObjectsWithSameVariable(OrdinaryMorphism morph) {
        VarTuple variables = (VarTuple)morph.getAttrContext().getVariables();
        int i = 0;
        while (i < variables.getSize()) {
            ValueMember mem;
            VarMember var = variables.getVarMemberAt(i);
            Vector<Pair<GraphObject, String>> v = new Vector<Pair<GraphObject, String>>();
            for (GraphObject graphObject : morph.getOriginal().getNodesSet()) {
                if (graphObject.getAttribute() == null) continue;
                ValueTuple valueTuple = (ValueTuple)graphObject.getAttribute();
                int k = 0;
                while (k < valueTuple.getSize()) {
                    ValueMember mem2 = valueTuple.getValueMemberAt(k);
                    if (mem2.isSet() && mem2.getExpr().isVariable() && mem2.getExprAsText().equals(var.getName()) && mem2.getDeclaration().getTypeName().equals(var.getDeclaration().getTypeName())) {
                        v.add(new Pair<GraphObject, String>(graphObject, mem2.getName()));
                    }
                    ++k;
                }
            }
            for (GraphObject graphObject : morph.getOriginal().getArcsSet()) {
                if (graphObject.getAttribute() == null) continue;
                ValueTuple origVal = (ValueTuple)graphObject.getAttribute();
                int k = 0;
                while (k < origVal.getSize()) {
                    mem = origVal.getValueMemberAt(k);
                    if (mem.isSet() && mem.getExpr().isVariable() && mem.getExprAsText().equals(var.getName()) && mem.getDeclaration().getTypeName().equals(var.getDeclaration().getTypeName())) {
                        v.add(new Pair<GraphObject, String>(graphObject, mem.getName()));
                    }
                    ++k;
                }
            }
            if (v.size() > 1) {
                Pair pair = (Pair)v.elementAt(0);
                GraphObject img = morph.getImage((GraphObject)pair.first);
                ValueTuple val = (ValueTuple)img.getAttribute();
                mem = val.getValueMemberAt((String)pair.second);
                int j = 1;
                while (j < v.size()) {
                    Pair pj = (Pair)v.elementAt(j);
                    GraphObject imgj = morph.getImage((GraphObject)pj.first);
                    ValueTuple valj = (ValueTuple)imgj.getAttribute();
                    ValueMember memj = valj.getValueMemberAt((String)pj.second);
                    if (mem.isSet() && memj.isSet()) {
                        if (mem.getExpr().isConstant() && memj.getExpr().isConstant()) {
                            if (!mem.getExprAsText().equals(memj.getExprAsText())) {
                                this.errorMsg = "Attribute check (value is Constant): equal value due to equal variable - failed!";
                                return false;
                            }
                        } else if (mem.getExpr().isVariable() && memj.getExpr().isVariable()) {
                            if (!mem.getExprAsText().equals(memj.getExprAsText())) {
                                if (morph.getTarget().isCompleteGraph()) {
                                    this.errorMsg = "Attribute check (value is Variable): equal value due to equal variable - failed!";
                                    return false;
                                }
                                if ((mem.isTransient() || memj.isTransient()) && (morph.getOriginal().getKind() == "PREMISE" || morph.getOriginal().getKind() == "CONCLUSION")) {
                                    this.errorMsg = "Attribute check (value is Variable): equal (transient) variable due to equal variable - failed!";
                                    return false;
                                }
                            }
                        } else if (morph.getTarget().isCompleteGraph()) {
                            this.errorMsg = "Attribute check: equal value due to equal variable - failed!";
                            System.out.println(String.valueOf(this.getClass().getName()) + ":  " + this.errorMsg);
                            return false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean checkAttrCondition(OrdinaryMorphism morph) {
        CondTuple conds = (CondTuple)morph.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getSize()) {
            CondMember cond = conds.getCondMemberAt(i);
            if (cond.isEnabled() && cond.getMark() == 0 && cond.isDefinite() && !cond.isTrue()) {
                this.errorMsg = "Attribute condition  [ " + cond.getExprAsText() + " ]  failed.";
                ((VarTuple)morph.getAttrContext().getVariables()).unsetVariables();
                morph.removeAllMappings();
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void addObjectNameConstraint(GraphObject anObj) {
        if (this.itsCSP != null) {
            this.itsCSP.addObjectNameConstraint(anObj);
        }
    }

    @Override
    public void removeObjectNameConstraint(GraphObject anObj) {
        if (this.itsCSP != null) {
            this.itsCSP.removeObjectNameConstraint(anObj);
        }
    }
}

