/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.gui.event.TreeViewEvent;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.gui.treeview.nodedata.GrammarTreeNodeData;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Rule;
import agg.xt_basis.agt.RuleScheme;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class GraGraTreeViewKeyAdapter
extends KeyAdapter {
    private GraGraTreeView treeView;
    private TreePath selPath;
    private DefaultMutableTreeNode graNode;
    private EdGraGra gragra;
    private boolean copyRule = false;
    private EdRule ruleCopy;
    private int indx;

    public GraGraTreeViewKeyAdapter(GraGraTreeView treeview) {
        this.treeView = treeview;
        this.treeView.addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.performShortKeyEvent(e, true)) {
            this.propagateShortKeyToEditor(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean performShortKeyEvent(KeyEvent e, boolean treeviewowner) {
        int keyCode = e.getKeyCode();
        if (e.isControlDown()) {
            String typedKey = KeyEvent.getKeyText(keyCode);
            if (e.isAltDown()) {
                if (typedKey.equals("T")) {
                    this.treeView.executeCommand("newTypeGraph");
                    return true;
                } else if (typedKey.equals("G")) {
                    this.treeView.executeCommand("newGraph");
                    return true;
                } else if (typedKey.equals("R")) {
                    this.treeView.executeCommand("newRule");
                    return true;
                } else if (typedKey.equals("A")) {
                    this.treeView.executeCommand("newAtomic");
                    return true;
                } else {
                    if (!typedKey.equals("C")) return false;
                    this.treeView.executeCommand("newConstraint");
                }
                return true;
            } else if (e.isShiftDown()) {
                if (!typedKey.equals("G")) return false;
                this.treeView.resetGraph();
                return true;
            } else if (typedKey.equals("C")) {
                this.copySelected();
                return true;
            } else if (typedKey.equals("V")) {
                this.pasteSelected();
                return true;
            } else if (typedKey.equals("N")) {
                this.treeView.executeCommand("newGraGra");
                return true;
            } else if (typedKey.equals("O")) {
                this.treeView.executeCommand("open");
                return true;
            } else if (typedKey.equals("S")) {
                this.treeView.executeCommand("save");
                return true;
            } else if (typedKey.equals("W")) {
                this.treeView.delete("GraGra");
                return true;
            } else {
                if (!typedKey.equals("Q")) return false;
                this.treeView.executeCommand("exit");
            }
            return true;
        } else if (e.isShiftDown()) {
            if (e.isAltDown()) {
                String typedKey = KeyEvent.getKeyText(keyCode);
                if (typedKey.equals("G")) {
                    this.treeView.executeCommand("importGGX");
                    return true;
                } else if (typedKey.equals("X")) {
                    this.treeView.executeCommand("importGXL");
                    return true;
                } else if (typedKey.equals("O")) {
                    this.treeView.executeCommand("importOMONDOXMI");
                    return true;
                } else if (typedKey.equals("N")) {
                    this.treeView.executeCommand("newNAC");
                    return true;
                } else if (typedKey.equals("L")) {
                    this.treeView.setRuleLayer();
                    return true;
                } else if (typedKey.equals("P")) {
                    this.treeView.setRulePriority();
                    return true;
                } else if (typedKey.equals("C")) {
                    this.treeView.executeCommand("newConclusion");
                    return true;
                } else if (typedKey.equals("R")) {
                    this.treeView.reloadGraGra();
                    return true;
                } else {
                    if (!typedKey.equals("D")) return false;
                    this.treeView.copyRule();
                }
                return true;
            } else {
                String typedKey = KeyEvent.getKeyText(keyCode);
                if (typedKey.equals("J")) {
                    this.treeView.executeCommand("exportGraphJPEG");
                    return true;
                } else if (typedKey.equals("X")) {
                    this.treeView.executeCommand("exportGXL");
                    return true;
                } else {
                    if (!typedKey.equals("T")) return false;
                    this.treeView.executeCommand("exportGTXL");
                }
            }
            return true;
        } else if (e.isAltDown()) {
            String typedKey = KeyEvent.getKeyText(keyCode);
            if (!typedKey.equals("S")) return false;
            this.treeView.executeCommand("saveAs");
            return true;
        } else if (KeyEvent.getKeyText(keyCode).equals("F")) {
            this.treeView.getFileMenu().doClick();
            return true;
        } else {
            if (!KeyEvent.getKeyText(keyCode).equals("Delete") && !KeyEvent.getKeyText(keyCode).equals("Entf")) return false;
            if (this.treeView.getSelectedPath() != null) {
                this.treeView.deleteTreeNode((DefaultMutableTreeNode)this.treeView.getSelectedPath().getLastPathComponent(), this.treeView.getSelectedPath(), true);
                return true;
            } else {
                if (!treeviewowner) return true;
                return false;
            }
        }
    }

    protected void propagateShortKeyToEditor(KeyEvent e) {
        this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 24, e));
    }

    protected void copySelected() {
        this.copyRule = false;
        this.graNode = null;
        this.ruleCopy = null;
        this.gragra = null;
        this.indx = -1;
        this.selPath = this.treeView.getSelectedPath();
        if (this.selPath != null) {
            TreePath graPath;
            DefaultMutableTreeNode rnode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
            GraGraTreeNodeData rd = (GraGraTreeNodeData)rnode.getUserObject();
            if (rd.isRuleScheme()) {
                TreePath graPath2 = this.selPath.getParentPath();
                if (graPath2 != null) {
                    GraGraTreeNodeData graData;
                    this.graNode = (DefaultMutableTreeNode)graPath2.getLastPathComponent();
                    if (this.graNode.getUserObject() instanceof GrammarTreeNodeData && (graData = (GraGraTreeNodeData)this.graNode.getUserObject()).getGraGra().isEditable()) {
                        RuleScheme r = BaseFactory.theFactory().cloneRuleScheme(rd.getRuleScheme().getBasisRuleScheme(), rd.getRule().getTypeSet().getBasisTypeSet());
                        r.setName(String.valueOf(rd.getRuleScheme().getBasisRuleScheme().getName()) + "_clone");
                        this.ruleCopy = new EdRuleScheme(r, rd.getRuleScheme().getTypeSet());
                        ((EdRuleScheme)this.ruleCopy).setLayoutByIndexFrom(rd.getRuleScheme());
                        this.indx = this.graNode.getIndex(rnode) + 1;
                        this.copyRule = true;
                        this.gragra = graData.getGraGra();
                        this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 74, "<Ctrl + C>  Copy  RuleScheme  -  successful"));
                    }
                }
            } else if (rd.isRule() && (graPath = this.selPath.getParentPath()) != null) {
                GraGraTreeNodeData graData;
                this.graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
                if (this.graNode.getUserObject() instanceof GrammarTreeNodeData && (graData = (GraGraTreeNodeData)this.graNode.getUserObject()).getGraGra().isEditable()) {
                    Rule r = BaseFactory.theFactory().cloneRule(rd.getRule().getBasisRule(), rd.getRule().getTypeSet().getBasisTypeSet(), true);
                    r.setName(String.valueOf(rd.getRule().getBasisRule().getName()) + "_clone");
                    this.ruleCopy = new EdRule(r, rd.getRule().getTypeSet());
                    this.ruleCopy.setLayoutByIndexFrom(rd.getRule(), false);
                    this.indx = this.graNode.getIndex(rnode) + 1;
                    this.copyRule = true;
                    this.gragra = graData.getGraGra();
                    this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 74, "<Ctrl + C>  Copy  Rule  -  successful"));
                }
            }
        }
    }

    protected void pasteSelected() {
        if (this.copyRule) {
            TreePath graPath;
            DefaultMutableTreeNode rnode;
            GraGraTreeNodeData rd;
            this.selPath = this.treeView.getSelectedPath();
            if (this.selPath != null && (rd = (GraGraTreeNodeData)(rnode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent()).getUserObject()).isRule() && (graPath = this.selPath.getParentPath()) != null) {
                this.graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
                GraGraTreeNodeData graData = (GraGraTreeNodeData)this.graNode.getUserObject();
                if (graData instanceof GrammarTreeNodeData && ((GrammarTreeNodeData)graData).getGraGra() == this.gragra) {
                    this.indx = this.graNode.getIndex(rnode) + 1;
                    int r_indx = graData.getGraGra().getRules().indexOf(rd.getRule()) + 1;
                    if (this.ruleCopy instanceof EdRuleScheme) {
                        this.ruleCopy.setGraGra(graData.getGraGra());
                        graData.getGraGra().getBasisGraGra().getListOfRules().add(r_indx, ((EdRuleScheme)this.ruleCopy).getBasisRuleScheme());
                        graData.getGraGra().getRules().add(r_indx, (EdRuleScheme)this.ruleCopy);
                        this.treeView.putRuleSchemeIntoTree((EdRuleScheme)this.ruleCopy, this.graNode, this.indx);
                        TreePath tp = this.treeView.getTreePathOfGrammarElement((EdRuleScheme)this.ruleCopy);
                        this.treeView.selectPath(tp);
                        this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 73, tp));
                        this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 74, "<Ctrl + V>  Paste  RuleScheme  -  successful"));
                        this.copyRule = false;
                    } else {
                        this.ruleCopy.setGraGra(graData.getGraGra());
                        graData.getGraGra().getBasisGraGra().getListOfRules().add(r_indx, this.ruleCopy.getBasisRule());
                        graData.getGraGra().getRules().add(r_indx, this.ruleCopy);
                        this.treeView.putRuleIntoTree(this.ruleCopy, this.graNode, this.indx);
                        TreePath tp = this.treeView.getTreePathOfGrammarElement(this.ruleCopy);
                        this.treeView.selectPath(tp);
                        this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 73, tp));
                        this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 74, "<Ctrl + V>  Paste  Rule  -  successful"));
                        this.copyRule = false;
                    }
                }
            }
        }
    }
}

