/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.gui.editor.GraphCanvas;
import agg.xt_basis.Arc;
import agg.xt_basis.Node;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class GraphPanel
extends JPanel {
    private Object itsParent;
    protected GraphCanvas canvas;
    protected EdGraph eGraph;
    protected JScrollPane jsp;
    protected Cursor lastEditCursor = new Cursor(0);
    private boolean mappedObjDeleted = false;
    private boolean attrEditorOn = false;
    private String name = "";
    private Cursor editCursor = new Cursor(0);
    private int lastEditMode = 11;

    public GraphPanel(Object parent) {
        this();
        this.itsParent = parent;
    }

    public GraphPanel() {
        super(new BorderLayout(), true);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.WHITE);
        this.canvas = new GraphCanvas();
        try {
            this.jsp = new JScrollPane(this.canvas, 20, 30);
            this.jsp.setBackground(Color.white);
            this.jsp.setForeground(Color.white);
            this.jsp.getHorizontalScrollBar().setUnitIncrement(30);
            this.jsp.getVerticalScrollBar().setUnitIncrement(30);
            this.jsp.getHorizontalScrollBar().setBlockIncrement(50);
            this.jsp.getVerticalScrollBar().setBlockIncrement(50);
            this.jsp.getHorizontalScrollBar().getModel().setValueIsAdjusting(true);
            this.jsp.getVerticalScrollBar().getModel().setValueIsAdjusting(true);
            this.add((Component)this.jsp, "Center");
            this.canvas.setViewport(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Object getParentEditor() {
        return this.itsParent;
    }

    @Override
    public void setName(String n) {
        this.name = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.jsp != null) {
            this.jsp.setBackground(c);
        }
        if (this.canvas != null) {
            this.canvas.setBackground(c);
        }
    }

    public JScrollPane getScrollPane() {
        return this.jsp;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(250, 200);
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.jsp.getHorizontalScrollBar();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.jsp.getVerticalScrollBar();
    }

    public void setViewportView(GraphCanvas view) {
        this.jsp.setViewportView(view);
    }

    public void updateGraphics() {
        this.canvas.repaint();
    }

    public void updateGraphics(boolean graphDimensionCheck) {
        if (this.eGraph != null) {
            if (graphDimensionCheck) {
                Dimension maxDim = this.getGraphDimension();
                if (maxDim.width != 0 || maxDim.height != 0) {
                    this.canvas.setSize(maxDim);
                }
            }
            this.canvas.repaint();
        }
    }

    public void adjustGraphPanelSize() {
        Dimension maxDim = this.getGraphDimension();
        if (maxDim.width != 0 || maxDim.height != 0) {
            this.canvas.setSize(maxDim);
        }
    }

    public void updateGraphicsAfterDelete() {
        if (this.eGraph != null) {
            Dimension maxDim = this.getGraphDimension();
            if (maxDim.width != 0 || maxDim.height != 0) {
                this.canvas.setSize(maxDim);
            }
            this.canvas.repaint();
        }
    }

    private Dimension getGraphDimension() {
        Dimension maxDim = new Dimension(0, 0);
        if (this.eGraph != null) {
            maxDim.setSize(this.canvas.getGraphDimension());
            this.canvas.setRealWidth(maxDim.width);
            this.canvas.setRealHeight(maxDim.height);
            return maxDim;
        }
        return maxDim;
    }

    public void resizeAfterTransform(boolean val) {
        this.canvas.resizeAfterTransform(val);
    }

    public EdGraph getGraph() {
        return this.eGraph;
    }

    public void setGraph(EdGraph eg, boolean adjustCanvasSize) {
        this.eGraph = eg;
        this.canvas.setGraph(this.eGraph);
        if (this.eGraph != null) {
            if (adjustCanvasSize) {
                Dimension maxDim = this.canvas.getGraphDimension();
                this.canvas.setSize(new Dimension(maxDim.width, maxDim.height));
                this.canvas.setRealWidth(maxDim.width);
                this.canvas.setRealHeight(maxDim.height);
            } else {
                this.canvas.repaint();
            }
        } else {
            this.canvas.setSize(new Dimension(this.getWidth() - this.jsp.getVerticalScrollBar().getWidth() - 3, this.getHeight() - this.jsp.getHorizontalScrollBar().getHeight() - 3));
            this.canvas.setRealWidth(this.canvas.getWidth());
            this.canvas.setRealHeight(this.canvas.getHeight());
        }
        this.jsp.getHorizontalScrollBar().setValue(0);
        this.jsp.getVerticalScrollBar().setValue(0);
    }

    public void setGraph(EdGraph eg) {
        this.setGraph(eg, true);
    }

    public GraphCanvas getCanvas() {
        return this.canvas;
    }

    public int getEditMode() {
        return this.canvas.getEditMode();
    }

    public void setEditMode(int m) {
        this.canvas.setEditMode(m);
    }

    public void setEditCursor(Cursor cur) {
        this.editCursor = cur;
    }

    public Cursor getEditCursor() {
        return this.editCursor;
    }

    public void setLastEditMode(int m) {
        this.lastEditMode = m;
    }

    public int getLastEditMode() {
        if (this.lastEditMode == 113) {
            return 11;
        }
        return this.lastEditMode;
    }

    public void setLastEditCursor(Cursor cur) {
        this.lastEditCursor = cur;
    }

    public Cursor getLastEditCursor() {
        return this.lastEditCursor;
    }

    @Override
    public void setVisible(boolean vis) {
        this.canvas.setVisible(vis);
    }

    public void setMappedObjDeleted(boolean b) {
        this.mappedObjDeleted = b;
    }

    public boolean isMappedObjDeleted() {
        return this.mappedObjDeleted;
    }

    public void setAttrEditorActivated(boolean b) {
        this.attrEditorOn = b;
    }

    public boolean isAttrEditorActivated() {
        return this.attrEditorOn;
    }

    public void delArc(Arc bArc) {
        this.canvas.delArc(bArc);
    }

    public void delNode(Node bNode) {
        this.canvas.delNode(bNode);
    }

    public void delSelectedNode(EdNode eNode) {
        this.canvas.delSelectedNode(eNode);
    }

    public void delSelectedArc(EdArc eArc) {
        this.canvas.delSelectedArc(eArc);
    }

    public void deleteSelectedNodes() {
        this.canvas.deleteSelectedNodes();
    }

    public void deleteSelectedArcs() {
        this.canvas.deleteSelectedArcs();
    }

    public void deleteSelected() {
        this.canvas.deleteSelected();
    }

    public boolean deleteObj(int x, int y) {
        return this.canvas.deleteObj(x, y);
    }

    public void deleteObj(EdGraphObject ego) {
        this.canvas.deleteObj(ego);
    }

    boolean hasSelection() {
        return this.eGraph != null && this.eGraph.hasSelection();
    }

    public void deselect(EdGraphObject ego) {
        this.canvas.deselect(ego);
        this.updateGraphics();
    }

    public EdGraphObject select(int x, int y) {
        return this.canvas.select(x, y);
    }

    public void selectAll() {
        this.canvas.selectAll();
        this.updateGraphics();
    }

    public void deselectAll() {
        if (this.canvas.deselectAll()) {
            this.updateGraphics();
        }
    }

    public void selectNodesOfSelectedNodeType() {
        if (this.canvas.selectNodesOfSelectedNodeType()) {
            this.updateGraphics();
        }
    }

    public void selectArcsOfSelectedArcType() {
        if (this.canvas.selectArcsOfSelectedArcType()) {
            this.updateGraphics();
        }
    }

    public void straightenSelectedArcs() {
        if (this.canvas.straigthSelectedArcs()) {
            this.updateGraphics();
        }
    }
}

