/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.helpers.ModuleEditHelper;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class NodeTypeParser
extends AbstractParser {
    public NodeTypeParser() {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
    }

    public String getPrintString(IAdaptable element, int flags) {
        Node node = (Node)element.getAdapter(EObject.class);
        String name = node.getName() != null ? node.getName().trim() : "";
        Action action = node.getAction();
        if (action != null && action.getType() == Action.Type.PRESERVE) {
            String rhsName;
            Rule rule = node.getGraph().getRule();
            Node rhsNode = rule.getMappings().getImage(node, rule.getRhs());
            String string = rhsName = rhsNode.getName() != null ? rhsNode.getName().trim() : "";
            if (!name.equals(rhsName)) {
                if (name.length() == 0) {
                    name = "?";
                }
                if (rhsName.length() == 0) {
                    rhsName = "?";
                }
                name = String.valueOf(name) + "->" + rhsName;
            }
        }
        if (node.getType() != null) {
            return String.valueOf(name) + ":" + node.getType().getName();
        }
        return name;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final Node node = (Node)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)node);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Parse Node Name", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return NodeTypeParser.this.doParsing(value, node);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value, Node node) {
        Node rhsNode;
        EClassifier[] classifiers;
        String type;
        String name;
        Rule rule = node.getGraph().getRule();
        Module module = rule.getModule();
        int colon = value.indexOf(":");
        if (colon >= 0) {
            name = value.substring(0, colon).trim();
            type = value.substring(colon + 1).trim();
        } else {
            name = value.trim();
            type = "";
        }
        int arrow = name.indexOf("->");
        String name2 = name;
        if (arrow >= 0) {
            name2 = name.substring(arrow + 2).trim();
            name = name.substring(0, arrow).trim();
        }
        EClass nodeType = null;
        EClassifier[] eClassifierArray = classifiers = ModuleEditHelper.getEClassifiers(module, type);
        int n = classifiers.length;
        int n2 = 0;
        while (n2 < n) {
            EClassifier classifier = eClassifierArray[n2];
            if (classifier instanceof EClass) {
                nodeType = (EClass)classifier;
                break;
            }
            ++n2;
        }
        Action action = node.getAction();
        if (action != null && action.getType() == Action.Type.PRESERVE && (rhsNode = rule.getMappings().getImage(node, rule.getRhs())) != null) {
            if (name2.length() == 0 || name2.equals("?")) {
                name2 = null;
            }
            rhsNode.setName(name2);
            if (nodeType != null) {
                rhsNode.setType(nodeType);
            }
            node.setName(String.valueOf(name) + "2");
        }
        if (name.length() == 0 || name.equals("?")) {
            name = null;
        }
        node.setName(name);
        if (nodeType != null) {
            node.setType(nodeType);
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getNamedElement_Name()) {
            return true;
        }
        return feature == HenshinPackage.eINSTANCE.getNode_Type();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

