/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.diagram.parsers.NodeActionParser;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;

public class EdgeActionParser
extends AbstractParser {
    public EdgeActionParser() {
        super(new EAttribute[0]);
    }

    public String getEditString(IAdaptable element, int flags) {
        Edge edge = (Edge)element.getAdapter(EObject.class);
        Action action = edge.getAction();
        return action != null ? action.toString() : "unknown";
    }

    public String getPrintString(IAdaptable element, int flags) {
        return NodeActionParser.addActionQuotes(this.getEditString(element, flags));
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final Edge edge = (Edge)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)edge);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Parse Edge Action", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return EdgeActionParser.this.doParsing(value, edge);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value, Edge edge) {
        try {
            Action action = Action.parse((String)value);
            Node src = edge.getSource().getActionNode();
            Node trg = edge.getTarget().getActionNode();
            Action srcAction = src.getAction();
            Action trgAction = trg.getAction();
            if (!srcAction.equals((Object)action) && srcAction.getType() != Action.Type.PRESERVE) {
                src.setAction(action);
            }
            if (!trgAction.equals((Object)action) && trgAction.getType() != Action.Type.PRESERVE) {
                trg.setAction(action);
            }
            edge.setAction(action);
            return CommandResult.newOKCommandResult();
        }
        catch (Throwable t) {
            HenshinDiagramEditorPlugin.getInstance().logError("Error setting edge action", t);
            return CommandResult.newErrorCommandResult((Throwable)t);
        }
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    @Override
    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }
}

