/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.InternalBuffer;

public class Buffer
implements InternalBuffer {
    private static final int EOS_OFFSET = 1;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_BUFFER, Buffer.class);
    private IBufferProvider bufferProvider;
    private short channelIndex;
    private boolean eos;
    private BufferState state = BufferState.INITIAL;
    private ByteBuffer byteBuffer;

    public Buffer(IBufferProvider provider, short capacity) {
        this.bufferProvider = provider;
        this.byteBuffer = ByteBuffer.allocateDirect(capacity);
    }

    public boolean isEOS() {
        return this.eos;
    }

    public void setEOS(boolean eos) {
        this.eos = eos;
    }

    public IBufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    public void setBufferProvider(IBufferProvider bufferProvider) {
        this.bufferProvider = bufferProvider;
    }

    public short getChannelIndex() {
        if (this.state == BufferState.INITIAL || this.state == BufferState.READING_HEADER) {
            throw new IllegalStateException("state == " + (Object)((Object)this.state));
        }
        return this.channelIndex;
    }

    public short getCapacity() {
        return (short)this.byteBuffer.capacity();
    }

    public ByteBuffer getByteBuffer() {
        if (this.state != BufferState.GETTING && this.state != BufferState.PUTTING) {
            throw new IllegalStateException("state == " + (Object)((Object)this.state));
        }
        return this.byteBuffer;
    }

    public BufferState getState() {
        return this.state;
    }

    public void release() {
        if (this.bufferProvider != null) {
            this.bufferProvider.retainBuffer(this);
        }
    }

    public void clear() {
        this.byteBuffer.clear();
        this.state = BufferState.INITIAL;
        this.channelIndex = Short.MIN_VALUE;
        this.eos = false;
    }

    public void dispose() {
        this.bufferProvider = null;
        this.byteBuffer = null;
    }

    public ByteBuffer startGetting(SocketChannel socketChannel) throws IOException {
        if (this.state != BufferState.INITIAL && this.state != BufferState.READING_HEADER && this.state != BufferState.READING_BODY) {
            throw new IllegalStateException("state == " + (Object)((Object)this.state));
        }
        if (this.state == BufferState.INITIAL) {
            this.byteBuffer.limit(4);
            this.state = BufferState.READING_HEADER;
        }
        if (this.state == BufferState.READING_HEADER) {
            int num = socketChannel.read(this.byteBuffer);
            if (num == -1) {
                throw new ClosedChannelException();
            }
            if (this.byteBuffer.hasRemaining()) {
                return null;
            }
            this.byteBuffer.flip();
            this.channelIndex = this.byteBuffer.getShort();
            short payloadSize = this.byteBuffer.getShort();
            if (payloadSize < 0) {
                this.eos = true;
                payloadSize = -payloadSize;
            }
            payloadSize = (short)(payloadSize - 1);
            this.byteBuffer.clear();
            this.byteBuffer.limit(payloadSize);
            this.state = BufferState.READING_BODY;
        }
        if (socketChannel.read(this.byteBuffer) == -1) {
            throw new ClosedChannelException();
        }
        if (this.byteBuffer.hasRemaining()) {
            return null;
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Read " + this.byteBuffer.limit() + " bytes" + (this.eos ? " (EOS)" : "") + StringUtil.NL + this.formatContent(false));
        }
        this.byteBuffer.flip();
        this.state = BufferState.GETTING;
        return this.byteBuffer;
    }

    public ByteBuffer startPutting(short channelIndex) {
        if (this.state == BufferState.PUTTING) {
            if (channelIndex != this.channelIndex) {
                throw new IllegalArgumentException("channelIndex != this.channelIndex");
            }
        } else {
            if (this.state != BufferState.INITIAL) {
                throw new IllegalStateException("state == " + (Object)((Object)this.state));
            }
            this.state = BufferState.PUTTING;
            this.channelIndex = channelIndex;
            this.byteBuffer.clear();
            this.byteBuffer.position(4);
        }
        return this.byteBuffer;
    }

    public boolean write(SocketChannel socketChannel) throws IOException {
        int numBytes;
        if (this.state != BufferState.PUTTING && this.state != BufferState.WRITING) {
            throw new IllegalStateException("state == " + (Object)((Object)this.state));
        }
        if (this.state == BufferState.PUTTING) {
            if (this.channelIndex == Short.MIN_VALUE) {
                throw new IllegalStateException("channelIndex == NO_CHANNEL");
            }
            int payloadSize = this.byteBuffer.position() - 4 + 1;
            if (this.eos) {
                payloadSize = -payloadSize;
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("Writing " + (Math.abs(payloadSize) - 1) + " bytes" + (this.eos ? " (EOS)" : "") + StringUtil.NL + this.formatContent(false));
            }
            this.byteBuffer.flip();
            this.byteBuffer.putShort(this.channelIndex);
            this.byteBuffer.putShort((short)payloadSize);
            this.byteBuffer.position(0);
            this.state = BufferState.WRITING;
        }
        if ((numBytes = socketChannel.write(this.byteBuffer)) == -1) {
            throw new IOException("Channel closed");
        }
        if (this.byteBuffer.hasRemaining()) {
            return false;
        }
        this.clear();
        return true;
    }

    public void flip() {
        if (this.state != BufferState.PUTTING) {
            throw new IllegalStateException("state == " + (Object)((Object)this.state));
        }
        this.byteBuffer.flip();
        this.byteBuffer.position(4);
        this.state = BufferState.GETTING;
    }

    public String toString() {
        return "Buffer@" + ReflectUtil.getID((Object)this);
    }

    public String formatContent(boolean showHeader) {
        int oldPosition = this.byteBuffer.position();
        int oldLimit = this.byteBuffer.limit();
        try {
            if (this.state != BufferState.GETTING) {
                this.byteBuffer.flip();
            }
            if (this.state == BufferState.PUTTING && !showHeader) {
                this.byteBuffer.position(4);
            }
            StringBuilder builder = new StringBuilder();
            while (this.byteBuffer.hasRemaining()) {
                int b = this.byteBuffer.get();
                HexUtil.appendHex((StringBuilder)builder, (int)(b < 0 ? ~b : b));
                builder.append(' ');
            }
            String string = builder.toString();
            return string;
        }
        finally {
            this.byteBuffer.position(oldPosition);
            this.byteBuffer.limit(oldLimit);
        }
    }
}

