/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.trace;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.EventObject;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.io.IOUtil;

public class RemoteTraceServer {
    public static final String DEFAULT_ADDRESS = "0.0.0.0";
    public static final int DEFAULT_PORT = 2035;
    public static final int ANY_PORT = 0;
    private static long lastEventID = 0L;
    private int port;
    private String address;
    private ServerSocket serverSocket;
    private Queue<Listener> listeners = new ConcurrentLinkedQueue<Listener>();

    public RemoteTraceServer() throws IOException {
        this(2035);
    }

    public RemoteTraceServer(int port) throws IOException {
        this(port, DEFAULT_ADDRESS);
    }

    public RemoteTraceServer(int port, String address) throws IOException {
        this.port = port;
        this.address = address;
        this.serverSocket = this.bind();
        new Thread("RemoteTraceServer"){

            public void run() {
                RemoteTraceServer.this.handleConnections();
            }
        }.start();
    }

    public void addListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public Exception close() {
        try {
            this.serverSocket.close();
            return null;
        }
        catch (IOException ex) {
            OM.LOG.error(ex);
            return ex;
        }
    }

    protected ServerSocket bind() throws IOException {
        InetAddress addr = InetAddress.getByName(this.address);
        return new ServerSocket(this.port, 5, addr);
    }

    protected void handleConnections() {
        try {
            while (true) {
                final Socket socket = this.serverSocket.accept();
                new Thread(){

                    public void run() {
                        RemoteTraceServer.this.handleSession(socket);
                    }
                }.start();
            }
        }
        catch (IOException ex) {
            if (!this.serverSocket.isClosed()) {
                IOUtil.print(ex);
            }
            return;
        }
    }

    protected void handleSession(Socket socket) {
        try {
            InputStream inputStream = socket.getInputStream();
            DataInputStream in = new DataInputStream(inputStream);
            while (true) {
                this.handleTrace(in);
            }
        }
        catch (IOException ex) {
            IOUtil.print(ex);
            return;
        }
    }

    protected void handleTrace(DataInputStream in) throws IOException {
        Event event = new Event();
        event.timeStamp = in.readLong();
        event.agentID = in.readUTF();
        event.bundleID = in.readUTF();
        event.tracerName = in.readUTF();
        event.context = in.readUTF();
        event.message = in.readUTF();
        if (in.readBoolean()) {
            event.throwable = in.readUTF();
            int size = in.readInt();
            event.stackTrace = new StackTraceElement[size];
            int i = 0;
            while (i < size) {
                String className = in.readUTF();
                String methodName = in.readUTF();
                String fileName = in.readUTF();
                int lineNumber = in.readInt();
                event.stackTrace[i] = new StackTraceElement(className, methodName, fileName, lineNumber);
                ++i;
            }
        }
        this.fireEvent(event);
    }

    protected void fireEvent(Event event) {
        for (Listener listener : this.listeners) {
            try {
                listener.notifyRemoteTrace(event);
            }
            catch (RuntimeException ex) {
                IOUtil.print(ex);
            }
        }
    }

    public class Event
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private long id;
        long timeStamp;
        String agentID;
        String bundleID;
        String tracerName;
        String context;
        String message;
        String throwable;
        StackTraceElement[] stackTrace;

        Event() {
            super(RemoteTraceServer.this);
            long l = lastEventID + 1L;
            lastEventID = l;
            this.id = l;
        }

        public RemoteTraceServer getRemoteTraceServer() {
            return (RemoteTraceServer)this.source;
        }

        public long getID() {
            return this.id;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public String getAgentID() {
            return this.agentID;
        }

        public String getBundleID() {
            return this.bundleID;
        }

        public String getContext() {
            return this.context;
        }

        public String getMessage() {
            return this.message;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        public String getThrowable() {
            return this.throwable;
        }

        public String getTracerName() {
            return this.tracerName;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TraceEvent[agentID=");
            builder.append(this.agentID);
            builder.append(", bundleID=");
            builder.append(this.bundleID);
            builder.append(", tracerName=");
            builder.append(this.tracerName);
            builder.append(", context=");
            builder.append(this.context);
            builder.append(", message=");
            builder.append(this.message);
            builder.append(", throwable=");
            builder.append(this.throwable);
            builder.append(", stackTrace=");
            builder.append(this.stackTrace);
            builder.append("]");
            return builder.toString();
        }

        public String getText(int index) {
            switch (index) {
                case 0: {
                    return Long.toString(this.id);
                }
                case 1: {
                    return new Date(this.timeStamp).toString();
                }
                case 2: {
                    return this.agentID;
                }
                case 3: {
                    return this.bundleID;
                }
                case 4: {
                    return this.tracerName;
                }
                case 5: {
                    return this.context;
                }
                case 6: {
                    return this.message;
                }
                case 7: {
                    return this.throwable;
                }
            }
            throw new IllegalArgumentException("Invalid index: " + index);
        }

        public boolean hasError() {
            return this.throwable != null && this.throwable.length() != 0 || this.stackTrace != null && this.stackTrace.length != 0;
        }
    }

    public static interface Listener {
        public void notifyRemoteTrace(Event var1);
    }

    public static class PrintListener
    implements Listener {
        public static final PrintListener CONSOLE = new PrintListener();
        private PrintStream stream;

        public PrintListener(PrintStream stream) {
            this.stream = stream;
        }

        protected PrintListener() {
            this(IOUtil.OUT());
        }

        public void notifyRemoteTrace(Event event) {
            StackTraceElement[] stackTrace;
            this.stream.println("[TRACE] " + event.getAgentID());
            this.stream.println(event.getBundleID());
            this.stream.println(event.getTracerName());
            this.stream.println(event.getContext());
            this.stream.println(event.getMessage());
            String throwable = event.getThrowable();
            if (throwable != null && throwable.length() != 0) {
                this.stream.println(throwable);
            }
            if ((stackTrace = event.getStackTrace()) != null) {
                StackTraceElement[] stackTraceElementArray = stackTrace;
                int n = stackTrace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    this.stream.print(element.getClassName());
                    this.stream.print("." + element.getMethodName());
                    this.stream.print("(" + element.getFileName());
                    this.stream.print(":" + element.getLineNumber());
                    this.stream.println(")");
                    ++n2;
                }
            }
            this.stream.println();
        }
    }
}

