/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.io.IOFilter;
import org.eclipse.net4j.util.io.IORunnable;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtil {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final String WILDCARD_SINGLE_CHAR = "?";
    public static final String WILDCARD_MULTI_CHARS = "*";
    public static final String WILDCARD_MULTI_DIRS = "**";
    private static final char SEP = File.separatorChar;
    private static final char SEP_UNIX = '/';
    private static final char SEP_WINDOWS = '\\';

    private IOUtil() {
    }

    public static InputStream IN() {
        return System.in;
    }

    public static PrintStream OUT() {
        return System.out;
    }

    public static PrintStream ERR() {
        return System.err;
    }

    public static void print(Throwable t, PrintStream stream) {
        t.printStackTrace(stream);
    }

    public static void print(Throwable t) {
        IOUtil.print(t, System.err);
    }

    public static String toString(Throwable t) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            String message = String.valueOf(t.getMessage()) + "\n";
            bytes.write(message.getBytes());
            IOUtil.print(t, new PrintStream(bytes));
            return bytes.toString();
        }
        catch (IOException ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static FileInputStream openInputStream(String fileName) throws IORuntimeException {
        return IOUtil.openInputStream(new File(fileName));
    }

    public static FileInputStream openInputStream(File file) throws IORuntimeException {
        try {
            return new FileInputStream(file);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static FileOutputStream openOutputStream(String fileName) throws IORuntimeException {
        return IOUtil.openOutputStream(new File(fileName));
    }

    public static FileOutputStream openOutputStream(File file) throws IORuntimeException {
        try {
            return new FileOutputStream(file);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static FileReader openReader(String fileName) throws IORuntimeException {
        return IOUtil.openReader(new File(fileName));
    }

    public static FileReader openReader(File file) throws IORuntimeException {
        try {
            return new FileReader(file);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static FileWriter openWriter(String fileName) throws IORuntimeException {
        return IOUtil.openWriter(new File(fileName));
    }

    public static FileWriter openWriter(File file) throws IORuntimeException {
        try {
            return new FileWriter(file);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static Exception closeSilent(java.io.Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return null;
        }
        catch (Exception ex) {
            OM.LOG.error(ex);
            return ex;
        }
    }

    public static void close(java.io.Closeable closeable) throws IORuntimeException {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static Exception closeSilent(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return null;
        }
        catch (Exception ex) {
            OM.LOG.error(ex);
            return ex;
        }
    }

    public static void close(Closeable closeable) throws IORuntimeException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static String makeRelative(File file, File toFolder) {
        String folderName;
        String fileName = IOUtil.normalizeSeparator(file.getAbsolutePath());
        if (fileName.startsWith(folderName = IOUtil.normalizeSeparator(toFolder.getAbsolutePath()))) {
            String relative = fileName.substring(folderName.length());
            if (relative.startsWith(File.separator)) {
                relative = relative.substring(1);
            }
            return relative;
        }
        throw new IllegalArgumentException("Different prefixes: " + fileName + " != " + folderName);
    }

    public static String normalizeSeparator(String string) {
        if (SEP == '/') {
            return string.replace('\\', '/');
        }
        if (SEP == '\\') {
            return string.replace('/', '\\');
        }
        return string;
    }

    public static void mkdirs(File folder) {
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IORuntimeException("Unable to create directory " + folder.getAbsolutePath());
        }
    }

    public static int delete(File file) {
        if (file == null) {
            return 0;
        }
        int deleted = 0;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                deleted += IOUtil.delete(child);
                ++n2;
            }
        }
        if (file.delete()) {
            return deleted + 1;
        }
        file.deleteOnExit();
        return deleted;
    }

    public static void copyTree(File source, File target) throws IORuntimeException {
        if (source.isDirectory()) {
            File[] files;
            IOUtil.mkdirs(target);
            File[] fileArray = files = source.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                IOUtil.copyTree(new File(source, name), new File(target, name));
                ++n2;
            }
        } else {
            IOUtil.copyFile(source, target);
        }
    }

    public static void copyTrees(Collection<File> sources, File target) throws IORuntimeException {
        for (File source : sources) {
            IOUtil.copyTree(source, target);
        }
    }

    public static void copyText(File source, File target, IOFilter<String> ... lineFilters) throws IORuntimeException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(IOUtil.openReader(source));
            writer = new BufferedWriter(IOUtil.openWriter(target));
            IOUtil.copyText(reader, writer, lineFilters);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(reader);
            IOUtil.closeSilent(writer);
            throw throwable;
        }
        IOUtil.closeSilent(reader);
        IOUtil.closeSilent(writer);
    }

    public static void copyText(BufferedReader reader, BufferedWriter writer, IOFilter<String> ... lineFilters) {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                IOFilter<String>[] iOFilterArray = lineFilters;
                int n = lineFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    IOFilter<String> lineFilter = iOFilterArray[n2];
                    line = lineFilter.filter(line);
                    ++n2;
                }
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static int copy(InputStream input, OutputStream output, int size, byte[] buffer) throws IORuntimeException {
        try {
            int written = 0;
            int bufferSize = buffer.length;
            int n = Math.min(size, bufferSize);
            while (n > 0 && (n = input.read(buffer, 0, n)) != -1) {
                output.write(buffer, 0, n);
                written += n;
                size -= n;
                n = Math.min(size, bufferSize);
            }
            return written;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static void copy(InputStream input, OutputStream output, byte[] buffer) throws IORuntimeException {
        try {
            int n;
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static void copy(InputStream input, OutputStream output, int bufferSize) throws IORuntimeException {
        IOUtil.copy(input, output, new byte[bufferSize]);
    }

    public static void copy(InputStream input, OutputStream output) throws IORuntimeException {
        IOUtil.copy(input, output, 8192);
    }

    public static void copyFile(File source, File target) throws IORuntimeException {
        IOUtil.mkdirs(target.getParentFile());
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = IOUtil.openInputStream(source);
            output = IOUtil.openOutputStream(target);
            IOUtil.copy(input, output);
        }
        finally {
            IOUtil.closeSilent(input);
            IOUtil.closeSilent(output);
        }
    }

    public static byte[] readFile(File file) throws IORuntimeException {
        if (file.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + file.length());
        }
        int size = (int)file.length();
        FileInputStream input = IOUtil.openInputStream(file);
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream(size);
            IOUtil.copy(input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            IOUtil.closeSilent(input);
        }
    }

    public static void writeFile(File file, byte[] bytes) throws IORuntimeException {
        FileOutputStream output = IOUtil.openOutputStream(file);
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            IOUtil.copy(input, output);
        }
        finally {
            IOUtil.closeSilent(output);
        }
    }

    public static List<File> listDepthFirst(File file) {
        FileCollector collector = new FileCollector();
        IOUtil.visitDepthFirst(file, (IOVisitor)collector);
        return collector.getFiles();
    }

    public static List<File> listBreadthFirst(File file) {
        FileCollector collector = new FileCollector();
        IOUtil.visitBreadthFirst(file, (IOVisitor)collector);
        return collector.getFiles();
    }

    public static void visitDepthFirst(File file, IOVisitor visitor) throws IORuntimeException {
        try {
            boolean recurse = visitor.visit(file);
            if (recurse && file.isDirectory()) {
                IOUtil.visitDepthFirst(file.listFiles(), visitor);
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static void visitDepthFirst(File[] files, IOVisitor visitor) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IOUtil.visitDepthFirst(file, visitor);
            ++n2;
        }
    }

    public static void visitBreadthFirst(File file, IOVisitor visitor) throws IORuntimeException {
        File[] files = new File[]{file};
        IOUtil.visitBreadthFirst(files, visitor);
    }

    public static void visitBreadthFirst(File[] files, IOVisitor visitor) throws IORuntimeException {
        try {
            File file;
            boolean[] recurse = new boolean[files.length];
            int i = 0;
            while (i < files.length) {
                file = files[i];
                recurse[i] = visitor.visit(file);
                ++i;
            }
            i = 0;
            while (i < files.length) {
                file = files[i];
                if (file.isDirectory() && recurse[i]) {
                    File[] children;
                    File[] fileArray = children = file.listFiles();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        IOUtil.visitBreadthFirst(child, visitor);
                        ++n2;
                    }
                }
                ++i;
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static <IO extends java.io.Closeable> void safeRun(IO io, IORunnable<IO> runnable) throws IORuntimeException {
        try {
            try {
                runnable.run(io);
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        finally {
            IOUtil.close(io);
        }
    }

    public static void safeInput(File file, IORunnable<FileInputStream> runnable) throws IORuntimeException {
        IOUtil.safeRun(IOUtil.openInputStream(file), runnable);
    }

    public static void safeOutput(File file, IORunnable<FileOutputStream> runnable) throws IORuntimeException {
        IOUtil.safeRun(IOUtil.openOutputStream(file), runnable);
    }

    public static void safeRead(File file, IORunnable<FileReader> runnable) throws IORuntimeException {
        IOUtil.safeRun(IOUtil.openReader(file), runnable);
    }

    public static void safeWrite(File file, IORunnable<FileWriter> runnable) throws IORuntimeException {
        IOUtil.safeRun(IOUtil.openWriter(file), runnable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(InputStream stream1, InputStream stream2) throws IORuntimeException {
        try {
            int byte1;
            do {
                int byte2;
                if ((byte1 = stream1.read()) == (byte2 = stream2.read())) continue;
                return false;
            } while (byte1 != -1);
            return true;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static boolean equals(File file1, File file2) throws IORuntimeException {
        boolean bl;
        if (file1.length() != file2.length()) {
            return false;
        }
        FileInputStream stream1 = null;
        FileInputStream stream2 = null;
        try {
            stream1 = new FileInputStream(file1);
            stream2 = new FileInputStream(file2);
            bl = IOUtil.equals(stream1, stream2);
        }
        catch (IOException ex) {
            try {
                throw new IORuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(stream1);
                IOUtil.closeSilent(stream2);
                throw throwable;
            }
        }
        IOUtil.closeSilent(stream1);
        IOUtil.closeSilent(stream2);
        return bl;
    }

    public static List<File> glob(String pattern, File folder) {
        ArrayList<File> result = new ArrayList<File>();
        if ((pattern = IOUtil.normalizeSeparator(pattern)).endsWith(File.separator)) {
            pattern = String.valueOf(pattern) + WILDCARD_MULTI_DIRS;
        }
        IOUtil.globRecurse(pattern, folder, result);
        return result;
    }

    private static void globRecurse(String pattern, File folder, List<File> result) {
        int sep = pattern.indexOf(SEP);
        if (sep != -1) {
            IOUtil.globSegment(pattern.substring(0, sep), pattern.substring(sep + 1), folder, result);
        } else {
            IOUtil.globSegment(pattern, null, folder, result);
        }
    }

    private static void globSegment(String segment, String pattern, File folder, List<File> result) {
        boolean multiDirs = false;
        if (segment.contains(WILDCARD_MULTI_DIRS)) {
            if (!segment.equals(WILDCARD_MULTI_DIRS)) {
                throw new IllegalArgumentException("Invalid pattern segment: " + segment);
            }
            multiDirs = true;
        }
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String tmp = segment;
            if (multiDirs && file.isDirectory()) {
                IOUtil.globRecurse(WILDCARD_MULTI_DIRS + File.separator + pattern, file, result);
                tmp = WILDCARD_MULTI_CHARS;
            }
            if (StringUtil.glob(tmp, file.getName())) {
                if (pattern == null) {
                    result.add(file);
                } else if (file.isDirectory()) {
                    IOUtil.globRecurse(pattern, file, result);
                }
            }
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileCollector
    implements IOVisitor {
        private List<File> files = new ArrayList<File>();

        public List<File> getFiles() {
            return this.files;
        }

        @Override
        public boolean visit(File file) throws IOException {
            this.files.add(file);
            return true;
        }
    }
}

