/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.epatch.applier;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.epatch.NamedObject;
import org.eclipse.emf.compare.epatch.applier.EpatchMapping;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEpatchMapping
implements EpatchMapping {
    private Map<EObject, EpatchMapping.EpatchMappingEntry> dst = new HashMap<EObject, EpatchMapping.EpatchMappingEntry>();
    private Map<NamedObject, EpatchMapping.EpatchMappingEntry> ptc = new HashMap<NamedObject, EpatchMapping.EpatchMappingEntry>();
    private Map<EObject, EpatchMapping.EpatchMappingEntry> src = new HashMap<EObject, EpatchMapping.EpatchMappingEntry>();

    @Override
    public Set<EpatchMapping.EpatchMappingEntry> getAllEntries() {
        HashSet<EpatchMapping.EpatchMappingEntry> entries = new HashSet<EpatchMapping.EpatchMappingEntry>(this.src.values());
        entries.addAll(this.dst.values());
        entries.addAll(this.ptc.values());
        return entries;
    }

    @Override
    public EpatchMapping.EpatchMappingEntry getByDst(EObject dst) {
        return this.dst.get(dst);
    }

    @Override
    public EpatchMapping.EpatchMappingEntry getByPtc(NamedObject ptc) {
        return this.ptc.get(ptc);
    }

    @Override
    public EpatchMapping.EpatchMappingEntry getBySrc(EObject src) {
        return this.src.get(src);
    }

    @Override
    public Map<EObject, EObject> getDstToSrcMap() {
        HashMap<EObject, EObject> map = new HashMap<EObject, EObject>();
        for (Map.Entry<EObject, EpatchMapping.EpatchMappingEntry> e : this.dst.entrySet()) {
            map.put(e.getKey(), e.getValue().getSrc());
        }
        return map;
    }

    @Override
    public Map<EObject, EObject> getSrcToDstMap() {
        HashMap<EObject, EObject> map = new HashMap<EObject, EObject>();
        for (Map.Entry<EObject, EpatchMapping.EpatchMappingEntry> e : this.src.entrySet()) {
            map.put(e.getKey(), e.getValue().getDst());
        }
        return map;
    }

    protected EpatchMapping.EpatchMappingEntry createEPatchMappingEntry(EObject src, EObject dst, NamedObject ptc) {
        return new EpatchMappingEntryImpl(src, dst, ptc);
    }

    @Override
    public void put(EObject src, EObject dst, NamedObject ptc) {
        EpatchMapping.EpatchMappingEntry e = this.createEPatchMappingEntry(src, dst, ptc);
        if (src != null) {
            this.src.put(src, e);
        }
        if (dst != null) {
            this.dst.put(dst, e);
        }
        if (ptc != null) {
            this.ptc.put(ptc, e);
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.getClass().getName());
        b.append(" {\n");
        for (EpatchMapping.EpatchMappingEntry e : this.getAllEntries()) {
            b.append("  ");
            b.append(e.toString());
            b.append("\n");
        }
        b.append("}");
        return b.toString();
    }

    public class EpatchMappingEntryImpl
    implements EpatchMapping.EpatchMappingEntry {
        private EObject dst;
        private NamedObject ptc;
        private EObject src;

        public EpatchMappingEntryImpl(EObject src, EObject dst, NamedObject ptc) {
            this.src = src;
            this.dst = dst;
            this.ptc = ptc;
        }

        public EObject getDst() {
            return this.dst;
        }

        public NamedObject getPtc() {
            return this.ptc;
        }

        public EObject getSrc() {
            return this.src;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("src:");
            b.append(this.src == null ? "null" : String.valueOf(this.src.eClass().getName()) + "@" + Integer.toHexString(this.src.hashCode()));
            b.append(" dst:");
            b.append(this.dst == null ? "null" : String.valueOf(this.dst.eClass().getName()) + "@" + Integer.toHexString(this.dst.hashCode()));
            b.append(" ptc:");
            b.append(this.ptc == null ? "null" : String.valueOf(this.ptc.eClass().getName()) + "@" + Integer.toHexString(this.ptc.hashCode()));
            return b.toString();
        }
    }
}

