/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionResolverImpl;
import org.eclipse.emf.cdo.session.CDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.RWLockManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORevisionManagerImpl
extends CDORevisionResolverImpl
implements CDORevisionManager {
    private InternalCDOSession session;
    private CDOFetchRuleManager ruleManager = CDOFetchRuleManager.NOOP;
    private RWLockManager<CDORevisionManager, Object> lockmanager = new RWLockManager();
    private Set<CDORevisionManagerImpl> singletonCollection = Collections.singleton(this);

    public CDORevisionManagerImpl(InternalCDOSession session) {
        this.session = session;
    }

    @Override
    public InternalCDOSession getSession() {
        return this.session;
    }

    public CDOFetchRuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setRuleManager(CDOFetchRuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public CDOIDObjectFactory getCDOIDObjectFactory() {
        return this.session;
    }

    public Object resolveElementProxy(CDORevision revision, EStructuralFeature feature, int accessIndex, int serverIndex) {
        return this.session.options().getCollectionLoadingPolicy().resolveProxy(this, revision, feature, accessIndex, serverIndex);
    }

    @Override
    public Object loadChunkByRange(CDORevision revision, EStructuralFeature feature, int accessIndex, int fetchIndex, int fromIndex, int toIndex) {
        return this.session.getSessionProtocol().loadChunk((InternalCDORevision)revision, feature, accessIndex, fetchIndex, fromIndex, toIndex);
    }

    protected InternalCDORevision loadRevision(CDOID id, int referenceChunk) {
        return this.loadRevisions(Collections.singleton(id), referenceChunk).get(0);
    }

    protected InternalCDORevision loadRevisionByTime(CDOID id, int referenceChunk, long timeStamp) {
        return this.loadRevisionsByTime(Collections.singleton(id), referenceChunk, timeStamp).get(0);
    }

    protected InternalCDORevision loadRevisionByVersion(CDOID id, int referenceChunk, int version) {
        return this.session.getSessionProtocol().loadRevisionByVersion(id, referenceChunk, version);
    }

    protected List<InternalCDORevision> loadRevisions(Collection<CDOID> ids, int referenceChunk) {
        return this.session.getSessionProtocol().loadRevisions(ids, referenceChunk);
    }

    protected List<InternalCDORevision> loadRevisionsByTime(Collection<CDOID> ids, int referenceChunk, long timeStamp) {
        return this.session.getSessionProtocol().loadRevisionsByTime(ids, referenceChunk, timeStamp);
    }

    protected void acquireAtomicRequestLock(Object key) {
        try {
            this.lockmanager.lock(RWLockManager.LockType.WRITE, key, (Object)this, 0L);
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    protected void releaseAtomicRequestLock(Object key) {
        this.lockmanager.unlock(RWLockManager.LockType.WRITE, key, this.singletonCollection);
    }
}

