/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionResolver;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.common.io.CDODataInputImpl;
import org.eclipse.emf.cdo.internal.common.io.CDODataOutputImpl;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.revision.CDOListWithElementProxiesImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.signal.RequestWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTransactionRequest
extends RequestWithMonitoring<CDOSessionProtocol.CommitTransactionResult> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionRequest.class);
    protected InternalCDOTransaction.InternalCDOCommitContext commitContext;

    public CommitTransactionRequest(CDOClientProtocol protocol, InternalCDOTransaction.InternalCDOCommitContext commitContext) {
        this(protocol, 12, commitContext);
    }

    public CommitTransactionRequest(CDOClientProtocol protocol, short signalID, InternalCDOTransaction.InternalCDOCommitContext commitContext) {
        super((SignalProtocol)protocol, signalID);
        this.commitContext = commitContext;
    }

    protected InternalCDOTransaction.InternalCDOCommitContext getCommitContext() {
        return this.commitContext;
    }

    public CDOClientProtocol getProtocol() {
        return (CDOClientProtocol)super.getProtocol();
    }

    protected InternalCDOSession getSession() {
        return (InternalCDOSession)this.getProtocol().getSession();
    }

    protected CDOIDProvider getIDProvider() {
        return this.commitContext.getTransaction();
    }

    protected final void requesting(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
        this.requesting((CDODataOutput)new CDODataOutputImpl((ExtendedDataOutput)out){

            protected StringIO getPackageURICompressor() {
                return CommitTransactionRequest.this.getProtocol().getPackageURICompressor();
            }

            public CDOIDProvider getIDProvider() {
                return CommitTransactionRequest.this.getIDProvider();
            }
        }, monitor);
    }

    protected final CDOSessionProtocol.CommitTransactionResult confirming(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
        return this.confirming((CDODataInput)new CDODataInputImpl((ExtendedDataInput)in){

            protected StringIO getPackageURICompressor() {
                return CommitTransactionRequest.this.getProtocol().getPackageURICompressor();
            }

            protected CDOPackageRegistry getPackageRegistry() {
                return CommitTransactionRequest.this.getSession().getPackageRegistry();
            }

            protected CDORevisionResolver getRevisionResolver() {
                return CommitTransactionRequest.this.getSession().getRevisionManager();
            }

            protected CDOIDObjectFactory getIDFactory() {
                return CommitTransactionRequest.this.getSession();
            }

            protected CDOListFactory getListFactory() {
                return CDOListWithElementProxiesImpl.FACTORY;
            }
        }, monitor);
    }

    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        this.requestingTransactionInfo(out);
        this.requestingCommit(out);
    }

    protected CDOSessionProtocol.CommitTransactionResult confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        CDOSessionProtocol.CommitTransactionResult result = this.confirmingCheckError(in);
        if (result != null) {
            return result;
        }
        result = this.confirmingTransactionResult(in);
        this.confirmingNewPackage(in, result);
        this.confirmingIdMapping(in, result);
        return result;
    }

    protected void requestingTransactionInfo(CDODataOutput out) throws IOException {
        out.writeInt(this.commitContext.getTransaction().getViewID());
    }

    protected void requestingCommit(CDODataOutput out) throws IOException {
        List<CDOPackageUnit> newPackageUnits = this.commitContext.getNewPackageUnits();
        Collection<CDOResource> newResources = this.commitContext.getNewResources().values();
        Collection<CDOObject> newObjects = this.commitContext.getNewObjects().values();
        Collection<CDORevisionDelta> revisionDeltas = this.commitContext.getRevisionDeltas().values();
        Set<CDOID> detachedObjects = this.commitContext.getDetachedObjects().keySet();
        out.writeBoolean(this.commitContext.getTransaction().options().isAutoReleaseLocksEnabled());
        out.writeInt(newPackageUnits.size());
        out.writeInt(newResources.size() + newObjects.size());
        out.writeInt(revisionDeltas.size());
        out.writeInt(detachedObjects.size());
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} new package units", new Object[]{newPackageUnits.size()});
        }
        for (CDOPackageUnit newPackageUnit : newPackageUnits) {
            out.writeCDOPackageUnit(newPackageUnit, true);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} new objects", new Object[]{newResources.size() + newObjects.size()});
        }
        this.writeRevisions(out, newResources);
        this.writeRevisions(out, newObjects);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} dirty objects", new Object[]{revisionDeltas.size()});
        }
        for (CDORevisionDelta revisionDelta : revisionDeltas) {
            out.writeCDORevisionDelta(revisionDelta);
        }
        for (CDOID id : detachedObjects) {
            out.writeCDOID(id);
        }
    }

    protected CDOSessionProtocol.CommitTransactionResult confirmingCheckError(CDODataInput in) throws IOException {
        boolean success = in.readBoolean();
        if (!success) {
            String rollbackMessage = in.readString();
            OM.LOG.error(rollbackMessage);
            return new CDOSessionProtocol.CommitTransactionResult(this.commitContext, rollbackMessage);
        }
        return null;
    }

    protected CDOSessionProtocol.CommitTransactionResult confirmingTransactionResult(CDODataInput in) throws IOException {
        long timeStamp = in.readLong();
        return new CDOSessionProtocol.CommitTransactionResult(this.commitContext, timeStamp);
    }

    protected void confirmingNewPackage(CDODataInput in, CDOSessionProtocol.CommitTransactionResult result) throws IOException {
        InternalCDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        for (CDOPackageUnit newPackageUnit : this.commitContext.getNewPackageUnits()) {
            CDOPackageInfo[] cDOPackageInfoArray = newPackageUnit.getPackageInfos();
            int n = cDOPackageInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOPackageInfo packageInfo = cDOPackageInfoArray[n2];
                CDOIDMetaRange oldRange = packageInfo.getMetaIDRange();
                CDOIDMetaRange newRange = in.readCDOIDMetaRange();
                ((InternalCDOPackageInfo)packageInfo).setMetaIDRange(newRange);
                int i = 0;
                while (i < oldRange.size()) {
                    CDOIDTemp oldID = (CDOIDTemp)oldRange.get(i);
                    CDOID newID = newRange.get(i);
                    packageRegistry.getMetaInstanceMapper().remapMetaInstanceID((CDOID)oldID, newID);
                    result.addIDMapping(oldID, newID);
                    ++i;
                }
                ++n2;
            }
        }
    }

    protected void confirmingIdMapping(CDODataInput in, CDOSessionProtocol.CommitTransactionResult result) throws IOException {
        CDOIDTemp oldID;
        while (!CDOIDUtil.isNull((CDOID)(oldID = (CDOIDTemp)in.readCDOID()))) {
            CDOID newID = in.readCDOID();
            result.addIDMapping(oldID, newID);
        }
    }

    protected int getMonitorProgressSeconds() {
        CDOSession session = (CDOSession)this.commitContext.getTransaction().getSession();
        return session.options().getProgressInterval();
    }

    protected int getMonitorTimeoutSeconds() {
        CDOSession session = (CDOSession)this.commitContext.getTransaction().getSession();
        return session.options().getCommitTimeout();
    }

    private void writeRevisions(CDODataOutput out, Collection<?> objects) throws IOException {
        for (CDOObject object : objects) {
            CDORevision revision = object.cdoRevision();
            out.writeCDORevision(revision, -1);
        }
    }
}

