/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerRequest;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitNotificationRequest
extends CDOServerRequest {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CommitNotificationRequest.class);
    private long timeStamp;
    private final CDOPackageUnit[] packageUnits;
    private List<CDOIDAndVersion> dirtyIDs;
    private List<CDORevisionDelta> deltas;
    private List<CDOID> detachedObjects;

    public CommitNotificationRequest(IChannel channel, long timeStamp, CDOPackageUnit[] packageUnits, List<CDOIDAndVersion> dirtyIDs, List<CDOID> detachedObjects, List<CDORevisionDelta> deltas) {
        super(channel, (short)17);
        this.timeStamp = timeStamp;
        this.packageUnits = packageUnits;
        this.dirtyIDs = dirtyIDs;
        this.deltas = deltas;
        this.detachedObjects = detachedObjects;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing timeStamp: {0,date} {0,time}", new Object[]{this.timeStamp});
        }
        out.writeLong(this.timeStamp);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} dirty IDs", new Object[]{this.dirtyIDs.size()});
        }
        out.writeCDOPackageUnits(this.packageUnits);
        out.writeInt(this.dirtyIDs == null ? 0 : this.dirtyIDs.size());
        for (CDOIDAndVersion dirtyID : this.dirtyIDs) {
            if (TRACER.isEnabled()) {
                TRACER.format("Writing dirty ID: {0}", new Object[]{dirtyID});
            }
            out.writeCDOIDAndVersion(dirtyID);
        }
        out.writeInt(this.deltas == null ? 0 : this.deltas.size());
        for (CDORevisionDelta delta : this.deltas) {
            out.writeCDORevisionDelta(delta);
        }
        out.writeInt(this.detachedObjects == null ? 0 : this.detachedObjects.size());
        for (CDOID id : this.detachedObjects) {
            out.writeCDOID(id);
        }
    }
}

