/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateFactoryImpl;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOPropertyGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.hibernate.HibernateException;

public class CDOIDPropertyGetter
extends CDOPropertyGetter {
    private static final long serialVersionUID = 1L;

    public CDOIDPropertyGetter(CDORevisionTuplizer tuplizer, String propertyName) {
        super(tuplizer, propertyName);
    }

    public Object get(Object target) throws HibernateException {
        InternalCDORevision revision = (InternalCDORevision)target;
        if (!(revision.getID() instanceof CDOIDHibernate)) {
            if (!this.isVirtualProperty()) {
                Object value = super.get(target);
                this.setCDOID((CDORevision)revision, value);
                return value;
            }
            return null;
        }
        CDOIDHibernate cdoID = (CDOIDHibernate)revision.getID();
        if (this.isVirtualProperty()) {
            return cdoID.getId();
        }
        Object id = super.get(target);
        this.setCDOID((CDORevision)revision, id);
        return id;
    }

    private void setCDOID(CDORevision target, Object value) {
        CDOID cdoID;
        InternalCDORevision revision = (InternalCDORevision)target;
        HibernateCommitContext hcc = null;
        if (HibernateThreadContext.isHibernateCommitContextSet()) {
            hcc = HibernateThreadContext.getHibernateCommitContext();
        }
        if ((cdoID = revision.getID()) == null) {
            CDOIDHibernate newCDOID = CDOIDHibernateFactoryImpl.getInstance().createCDOID((Serializable)value, revision.getEClass().getName());
            revision.setID((CDOID)newCDOID);
            if (hcc != null) {
                hcc.setNewID(cdoID, (CDOID)newCDOID);
            }
        } else if (cdoID instanceof CDOIDTemp) {
            CDOIDHibernate newCDOID = CDOIDHibernateFactoryImpl.getInstance().createCDOID((Serializable)value, revision.getEClass().getName());
            revision.setID((CDOID)newCDOID);
            if (hcc != null) {
                hcc.getCommitContext().addIDMapping((CDOIDTemp)cdoID, (CDOID)newCDOID);
                hcc.setNewID(cdoID, (CDOID)newCDOID);
            }
        }
    }

    protected boolean isVirtualPropertyAllowed() {
        return true;
    }
}

