/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.ui.actions.ViewAction;
import org.eclipse.emf.cdo.internal.ui.dialogs.ImportResourceDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ImportResourceAction
extends ViewAction {
    public static final String ID = "import-resource";
    private static final String TITLE = Messages.getString("ImportResourceAction.1");
    private URI sourceURI;
    private String targetPath;

    public ImportResourceAction(IWorkbenchPage page, CDOView view) {
        super(page, String.valueOf(TITLE) + INTERACTIVE, Messages.getString("ImportResourceAction.2"), null, view);
        this.setId(ID);
    }

    protected void preRun() throws Exception {
        ImportResourceDialog dialog = new ImportResourceDialog(this.getShell(), TITLE, 4096);
        if (dialog.open() == 0) {
            List uris = dialog.getURIs();
            if (uris.size() == 1) {
                this.sourceURI = (URI)uris.get(0);
                this.targetPath = dialog.getTargetPath();
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)Messages.getString("ImportResourceAction.3"));
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        CDOTransaction transaction = this.getTransaction();
        ResourceSetImpl sourceSet = new ResourceSetImpl();
        sourceSet.setPackageRegistry((EPackage.Registry)transaction.getSession().getPackageRegistry());
        Resource source = sourceSet.getResource(this.sourceURI, true);
        ArrayList sourceContents = new ArrayList(source.getContents());
        CDOResource target = transaction.createResource(this.targetPath);
        EList targetContents = target.getContents();
        for (EObject root : sourceContents) {
            targetContents.add((Object)root);
        }
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                CDOEditorUtil.openEditor(ImportResourceAction.this.getPage(), ImportResourceAction.this.getView(), ImportResourceAction.this.targetPath);
            }
        });
    }
}

