/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.server.View;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ChangeSubscriptionIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, ChangeSubscriptionIndication.class);

    public ChangeSubscriptionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)22);
    }

    protected void indicating(CDODataInput in) throws IOException {
        boolean subscribeMode = true;
        int viewID = in.readInt();
        boolean clear = in.readBoolean();
        int size = in.readInt();
        if (size <= 0) {
            subscribeMode = false;
            size = -size;
        }
        View view = (View)this.getSession().getView(viewID);
        if (clear) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Clear subscription");
            }
            view.clearChangeSubscription();
        }
        int i = 0;
        while (i < size) {
            CDOID id = in.readCDOID();
            if (subscribeMode) {
                view.subscribe(id);
            } else {
                view.unsubscribe(id);
            }
            ++i;
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeBoolean(true);
    }
}

