/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.IListIndexAffecting;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOMoveFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOMoveFeatureDelta,
IListIndexAffecting {
    private int oldPosition;
    private int newPosition;

    public CDOMoveFeatureDeltaImpl(CDOFeature feature, int newPosition, int oldPosition) {
        super(feature);
        this.newPosition = newPosition;
        this.oldPosition = oldPosition;
    }

    public CDOMoveFeatureDeltaImpl(ExtendedDataInput in, CDOClass cdoClass) throws IOException {
        super(in, cdoClass);
        this.newPosition = in.readInt();
        this.oldPosition = in.readInt();
    }

    @Override
    public int getNewPosition() {
        return this.newPosition;
    }

    @Override
    public int getOldPosition() {
        return this.oldPosition;
    }

    @Override
    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.MOVE;
    }

    @Override
    public void apply(CDORevision revision) {
        ((InternalCDORevision)revision).getList(this.getFeature()).move(this.newPosition, this.oldPosition);
    }

    @Override
    public void write(ExtendedDataOutput out, CDOClass cdoClass, CDOIDProvider idProvider) throws IOException {
        super.write(out, cdoClass, idProvider);
        out.writeInt(this.newPosition);
        out.writeInt(this.oldPosition);
    }

    @Override
    public void affectIndices(int[] indices) {
        block9: {
            block8: {
                if (this.oldPosition >= this.newPosition) break block8;
                int i = 1;
                while (i <= indices[0]) {
                    if (this.oldPosition < indices[i] && indices[i] <= this.newPosition) {
                        int n = i;
                        indices[n] = indices[n] - 1;
                    } else if (indices[i] == this.oldPosition) {
                        indices[i] = this.newPosition;
                    }
                    ++i;
                }
                break block9;
            }
            if (this.newPosition >= this.oldPosition) break block9;
            int i = 1;
            while (i <= indices[0]) {
                if (this.newPosition <= indices[i] && indices[i] < this.oldPosition) {
                    int n = i;
                    indices[n] = indices[n] + 1;
                } else if (indices[i] == this.oldPosition) {
                    indices[i] = this.newPosition;
                }
                ++i;
            }
        }
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void adjustReferences(Map<CDOIDTemp, CDOID> idMappings) {
    }
}

